/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequestWithMonitoring;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSessionRequest
extends CDOClientRequestWithMonitoring<CDOSessionProtocol.OpenSessionResult> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, OpenSessionRequest.class);
    private String repositoryName;
    private String userID;
    private boolean passiveUpdateEnabled;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode;
    private CDOCommonSession.Options.LockNotificationMode lockNotificationMode;

    public OpenSessionRequest(CDOClientProtocol protocol, String repositoryName, String userID, boolean passiveUpdateEnabled, CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode, CDOCommonSession.Options.LockNotificationMode lockNotificationMode) {
        super(protocol, (short)1);
        this.repositoryName = repositoryName;
        this.userID = userID;
        this.passiveUpdateEnabled = passiveUpdateEnabled;
        this.passiveUpdateMode = passiveUpdateMode;
        this.lockNotificationMode = lockNotificationMode;
    }

    @Override
    protected void requesting(CDODataOutput out, OMMonitor monitor) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing repositoryName: {0}", new Object[]{this.repositoryName});
        }
        out.writeString(this.repositoryName);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing userID: {0}", new Object[]{this.userID});
        }
        out.writeString(this.userID);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing passiveUpdateEnabled: {0}", new Object[]{this.passiveUpdateEnabled});
        }
        out.writeBoolean(this.passiveUpdateEnabled);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing passiveUpdateMode: {0}", new Object[]{this.passiveUpdateMode});
        }
        out.writeEnum((Enum)this.passiveUpdateMode);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing lockNotificationMode: {0}", new Object[]{this.lockNotificationMode});
        }
        out.writeEnum((Enum)this.lockNotificationMode);
    }

    @Override
    protected CDOSessionProtocol.OpenSessionResult confirming(CDODataInput in, OMMonitor monitor) throws IOException {
        int sessionID = in.readXInt();
        if (sessionID == 0) {
            return null;
        }
        return new CDOSessionProtocol.OpenSessionResult(in, sessionID);
    }
}

