/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadChunkRequest
extends CDOClientRequest<Object> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadChunkRequest.class);
    private InternalCDORevision revision;
    private EStructuralFeature feature;
    private int accessIndex;
    private int fromIndex;
    private int toIndex;
    private int fetchIndex;

    public LoadChunkRequest(CDOClientProtocol protocol, InternalCDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
        super(protocol, (short)9);
        this.revision = revision;
        this.feature = feature;
        this.accessIndex = accessIndex;
        this.fetchIndex = fetchIndex;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        CDOID id = this.revision.getID();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision ID: {0}", new Object[]{id});
        }
        out.writeCDOID(id);
        InternalCDOBranch branch = this.revision.getBranch();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing branch: {0}", new Object[]{branch});
        }
        out.writeCDOBranch((CDOBranch)branch);
        int version = this.revision.getVersion();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing  version: {0}", new Object[]{version});
        }
        out.writeXInt(version);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing feature: {0}", new Object[]{this.feature});
        }
        out.writeCDOClassifierRef((EClassifier)this.feature.getEContainingClass());
        out.writeXInt(this.feature.getFeatureID());
        if (TRACER.isEnabled()) {
            TRACER.format("Writing fromIndex: {0}", new Object[]{this.fromIndex});
        }
        int diffIndex = this.accessIndex - this.fetchIndex;
        out.writeXInt(this.fromIndex - diffIndex);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing toIndex: {0}", new Object[]{this.toIndex});
        }
        out.writeXInt(this.toIndex - diffIndex);
    }

    @Override
    protected Object confirming(CDODataInput in) throws IOException {
        CDOType type = CDOModelUtil.getType((EStructuralFeature)this.feature);
        Object accessID = null;
        InternalCDOList list = (InternalCDOList)this.revision.getList(this.feature);
        int i = this.fromIndex;
        while (i <= this.toIndex) {
            Object value = type.readValue(in);
            list.setWithoutFrozenCheck(i, value);
            if (i == this.accessIndex) {
                accessID = value;
            }
            ++i;
        }
        return accessID;
    }
}

