/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;

public class RescueBodyNode
extends Node {
    static final long serialVersionUID = -6414517081810625663L;
    private final Node exceptionNodes;
    private final Node bodyNode;
    private final RescueBodyNode optRescueNode;
    private final ISourcePositionHolder rescueKeyword;

    public RescueBodyNode(ISourcePosition position, Node exceptionNodes, Node bodyNode, RescueBodyNode optRescueNode, ISourcePositionHolder rescueKeyword) {
        super(position, 74);
        this.exceptionNodes = exceptionNodes;
        this.bodyNode = bodyNode;
        this.optRescueNode = optRescueNode;
        this.rescueKeyword = rescueKeyword;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueBodyNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public RescueBodyNode getOptRescueNode() {
        return this.optRescueNode;
    }

    public Node getExceptionNodes() {
        return this.exceptionNodes;
    }

    public ISourcePositionHolder getRescueKeyword() {
        return this.rescueKeyword;
    }

    @Override
    public List childNodes() {
        if (this.optRescueNode != null) {
            return Node.createList(this.exceptionNodes, this.bodyNode, this.optRescueNode);
        }
        return Node.createList(this.exceptionNodes, this.bodyNode);
    }
}

