/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SignatureBuilder;
import org.eclipse.core.runtime.CoreException;

public abstract class CPPEvaluation
implements ICPPEvaluation {
    CPPEvaluation() {
    }

    @Override
    public IBinding getTemplateDefinition() {
        return null;
    }

    @Override
    public char[] getSignature() {
        SignatureBuilder buf = new SignatureBuilder();
        try {
            this.marshal(buf, true);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{'?'};
        }
        return buf.getSignature();
    }

    protected static IBinding resolveUnknown(ICPPUnknownBinding unknown, InstantiationContext context) {
        try {
            return CPPTemplates.resolveUnknown(unknown, context);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            return unknown;
        }
    }

    protected static ICPPTemplateArgument[] instantiateArguments(ICPPTemplateArgument[] args, InstantiationContext context, boolean strict) {
        try {
            return CPPTemplates.instantiateArguments(args, context, strict);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            return args;
        }
    }

    protected static IBinding instantiateBinding(IBinding binding, InstantiationContext context, int maxDepth) {
        try {
            return CPPTemplates.instantiateBinding(binding, context, maxDepth);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            return binding;
        }
    }

    protected static boolean containsDependentType(ICPPEvaluation[] evaluations) {
        ICPPEvaluation[] iCPPEvaluationArray = evaluations;
        int n = evaluations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation eval = iCPPEvaluationArray[n2];
            if (eval.isTypeDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean containsDependentValue(ICPPEvaluation[] evaluations) {
        ICPPEvaluation[] iCPPEvaluationArray = evaluations;
        int n = evaluations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation eval = iCPPEvaluationArray[n2];
            if (eval.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean areAllConstantExpressions(ICPPEvaluation[] evaluations, IASTNode point) {
        return CPPEvaluation.areAllConstantExpressions(evaluations, 0, evaluations.length, point);
    }

    protected static boolean areAllConstantExpressions(ICPPEvaluation[] evaluations, int from, int to, IASTNode point) {
        int i = from;
        while (i < to) {
            if (!evaluations[i].isConstantExpression(point)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean isConstexprValue(IValue value, IASTNode point) {
        if (value == null) {
            return false;
        }
        ICPPEvaluation innerEval = value.getEvaluation();
        if (innerEval == null) {
            if (value instanceof IntegralValue) {
                return value.numberValue() != null;
            }
            return true;
        }
        return innerEval.isConstantExpression(point);
    }

    protected static boolean isNullOrConstexprFunc(ICPPFunction function) {
        return function == null || function.isConstexpr();
    }

    protected static ICPPEvaluation maybeApplyConversion(ICPPEvaluation argument, IType targetType, IASTNode point, boolean allowContextualConversion) {
        IType type = argument.getType(point);
        if (targetType.isSameType(type)) {
            return argument;
        }
        try {
            Cost cost;
            ICPPFunction conversion;
            IType uqType = SemanticUtil.getNestedType(type, 13);
            IASTExpression.ValueCategory valueCategory = argument.getValueCategory(point);
            if (uqType instanceof ICPPClassType && (conversion = (cost = Conversions.initializationByConversion(valueCategory, type, (ICPPClassType)uqType, targetType, false, point, allowContextualConversion)).getUserDefinedConversion()) != null) {
                if (!conversion.isConstexpr()) {
                    return EvalFixed.INCOMPLETE;
                }
                EvalMemberAccess eval = new EvalMemberAccess(uqType, valueCategory, (IBinding)conversion, argument, false, point);
                return new EvalFunctionCall(new ICPPEvaluation[]{eval}, null, null);
            }
            if (!Conversions.checkImplicitConversionSequence(targetType, type, valueCategory, Conversions.UDCMode.FORBIDDEN, Conversions.Context.ORDINARY, point).converts()) {
                return EvalFixed.INCOMPLETE;
            }
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
        }
        return argument;
    }
}

