/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespace;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class CPPScope
implements ICPPASTInternalScope {
    protected static final char[] CONSTRUCTOR_KEY = "!!!CTOR!!!".toCharArray();
    private static final IProgressMonitor NPM = new NullProgressMonitor();
    private static final ICPPNamespace UNINITIALIZED = new CPPNamespace.CPPNamespaceProblem(null, 0, null);
    private final IASTNode physicalNode;
    private boolean isCached = false;
    protected CharArrayObjectMap<Object> bindings;
    private ICPPNamespace fIndexNamespace = UNINITIALIZED;

    public CPPScope(IASTNode physicalNode) {
        this.physicalNode = physicalNode;
    }

    @Override
    public IScope getParent() {
        return CPPVisitor.getContainingNonTemplateScope(this.physicalNode);
    }

    @Override
    public IASTNode getPhysicalNode() {
        return this.physicalNode;
    }

    @Override
    public void addName(IASTName name, boolean adlOnly) {
        char[] c;
        if (!name.isActive()) {
            return;
        }
        if (name instanceof ICPPASTQualifiedName && !(this.physicalNode instanceof ICPPASTCompositeTypeSpecifier) && !(this.physicalNode instanceof ICPPASTNamespaceDefinition)) {
            return;
        }
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((c = name.getLookupKey()).length == 0) {
            return;
        }
        Object o = this.bindings.get(c);
        if (o != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(name);
            } else {
                ObjectSet<Object> temp = new ObjectSet<Object>(2);
                temp.put(o);
                temp.put(name);
                this.bindings.put(c, temp);
            }
        } else {
            this.bindings.put(c, name);
        }
    }

    @Override
    public IBinding getBinding(IASTName name, boolean forceResolve, IIndexFileSet fileSet) {
        IScope.ScopeLookupData lookup = new IScope.ScopeLookupData(name, forceResolve, false);
        lookup.setIgnorePointOfDeclaration(true);
        Object[] bs = this.getBindingsInAST(lookup);
        IBinding binding = CPPSemantics.resolveAmbiguities(name, bs);
        if (binding == null && forceResolve) {
            IIndex index;
            IASTTranslationUnit tu = name.getTranslationUnit();
            IIndex iIndex = index = tu == null ? null : tu.getIndex();
            if (index != null) {
                char[] nchars = name.getLookupKey();
                if (this.physicalNode instanceof IASTTranslationUnit) {
                    try {
                        Object[] bindings = index.findBindings(nchars, IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE, NPM);
                        if (fileSet != null) {
                            bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                        }
                        if ((binding = CPPSemantics.resolveAmbiguities(name, bindings)) instanceof ICPPUsingDeclaration) {
                            binding = CPPSemantics.resolveAmbiguities(name, ((ICPPUsingDeclaration)binding).getDelegates());
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                } else {
                    ICPPNamespace nsbinding = this.getNamespaceIndexBinding(index);
                    if (nsbinding != null) {
                        return nsbinding.getNamespaceScope().getBinding(name, forceResolve, fileSet);
                    }
                }
            }
        }
        return binding;
    }

    protected ICPPNamespace getNamespaceIndexBinding(IIndex index) {
        if (this.fIndexNamespace == UNINITIALIZED) {
            IASTName nsname;
            IBinding nsbinding;
            this.fIndexNamespace = null;
            IASTNode node = this.getPhysicalNode();
            if (node instanceof ICPPASTNamespaceDefinition && (nsbinding = (nsname = ((ICPPASTNamespaceDefinition)node).getName()).resolveBinding()) != null) {
                this.fIndexNamespace = (ICPPNamespace)((Object)index.adaptBinding(nsbinding));
            }
        }
        return this.fIndexNamespace;
    }

    @Override
    @Deprecated
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        IIndex index;
        IBinding[] result = this.getBindingsInAST(lookup);
        IASTTranslationUnit tu = lookup.getTranslationUnit();
        if (tu != null && (index = tu.getIndex()) != null) {
            IIndexFileSet fileSet = lookup.getIncludedFiles();
            if (this.physicalNode instanceof IASTTranslationUnit) {
                try {
                    Object[] bindings;
                    IndexFilter filter = IndexFilter.CPP_DECLARED_OR_IMPLICIT_NO_INSTANCE;
                    char[] nchars = lookup.getLookupKey();
                    Object[] objectArray = bindings = lookup.isPrefixLookup() ? index.findBindingsForContentAssist(nchars, true, filter, null) : index.findBindings(nchars, filter, null);
                    if (fileSet != null) {
                        bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                    }
                    result = ArrayUtil.addAll(IBinding.class, result, bindings);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            } else if (this.physicalNode instanceof ICPPASTNamespaceDefinition) {
                ICPPASTNamespaceDefinition ns = (ICPPASTNamespaceDefinition)this.physicalNode;
                try {
                    IIndexBinding binding = index.findBinding(ns.getName());
                    if (binding instanceof ICPPNamespace) {
                        ICPPNamespaceScope indexNs = ((ICPPNamespace)((Object)binding)).getNamespaceScope();
                        Object[] bindings = indexNs.getBindings(lookup);
                        result = ArrayUtil.addAll(IBinding.class, result, bindings);
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
        }
        return ArrayUtil.trim(IBinding.class, result);
    }

    protected boolean nameIsVisibleToLookup(IScope.ScopeLookupData lookup) {
        return true;
    }

    public IBinding[] getBindingsInAST(IScope.ScopeLookupData lookup) {
        this.populateCache();
        char[] c = lookup.getLookupKey();
        IBinding[] result = IBinding.EMPTY_BINDING_ARRAY;
        if (!this.nameIsVisibleToLookup(lookup)) {
            return result;
        }
        Object obj = null;
        if (lookup.isPrefixLookup()) {
            char[][] keys = this.bindings != null ? this.bindings.keys() : CharArrayUtils.EMPTY_ARRAY_OF_CHAR_ARRAYS;
            ObjectSet<Object> all = new ObjectSet<Object>(16);
            IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(c);
            char[][] cArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                char[] key = cArray[n2];
                if (key != CONSTRUCTOR_KEY && matcher.match(key)) {
                    obj = this.bindings.get(key);
                    if (obj instanceof ObjectSet) {
                        all.addAll((ObjectSet)obj);
                    } else if (obj != null) {
                        all.put(obj);
                    }
                }
                ++n2;
            }
            obj = all;
        } else {
            Object object = obj = this.bindings != null ? this.bindings.get(c) : null;
        }
        if (obj != null) {
            if (obj instanceof ObjectSet) {
                ObjectSet os = (ObjectSet)obj;
                int j = 0;
                while (j < os.size()) {
                    result = this.addCandidate(os.keyAt(j), lookup, result);
                    ++j;
                }
            } else {
                result = this.addCandidate(obj, lookup, result);
            }
        }
        return ArrayUtil.trim(result);
    }

    private boolean isInsideClassScope(IScope scope) {
        try {
            return scope instanceof ICPPClassScope || scope instanceof ICPPEnumScope && scope.getParent() instanceof ICPPClassScope;
        }
        catch (DOMException e) {
            return false;
        }
    }

    private IBinding[] addCandidate(Object candidate, IScope.ScopeLookupData lookup, IBinding[] result) {
        IBinding binding;
        IASTTranslationUnit tu;
        IASTNode point = lookup.getLookupPoint();
        if (!(lookup.isIgnorePointOfDeclaration() || CPPSemantics.declaredBefore(candidate, point, (tu = point.getTranslationUnit()) != null && tu.getIndex() != null) || this.isInsideClassScope(this) && LookupData.checkWholeClassScope(lookup.getLookupName()))) {
            return result;
        }
        if (candidate instanceof IASTName) {
            IASTName candName = (IASTName)candidate;
            IASTName simpleName = candName.getLastName();
            if (simpleName instanceof ICPPASTTemplateId) {
                simpleName = ((ICPPASTTemplateId)simpleName).getTemplateName();
            }
            if (lookup.isResolve() && candName != point && simpleName != point) {
                candName.resolvePreBinding();
                binding = simpleName.resolvePreBinding();
            } else {
                binding = simpleName.getPreBinding();
            }
        } else {
            binding = (IBinding)candidate;
        }
        if (binding != null) {
            result = ArrayUtil.append(result, binding);
        }
        return result;
    }

    @Override
    public final void populateCache() {
        if (!this.isCached) {
            this.isCached = true;
            CPPSemantics.populateCache(this);
        }
    }

    @Override
    public void removeNestedFromCache(IASTNode container) {
        if (this.bindings != null) {
            this.removeFromMap(this.bindings, container);
        }
    }

    private void removeFromMap(CharArrayObjectMap<Object> map, IASTNode container) {
        int i = 0;
        while (i < map.size()) {
            Object o = map.getAt(i);
            if (o instanceof IASTName) {
                if (container.contains((IASTNode)o)) {
                    char[] key = map.keyAt(i);
                    map.remove(key, 0, key.length);
                    --i;
                }
            } else if (o instanceof ObjectSet) {
                ObjectSet set = (ObjectSet)o;
                this.removeFromSet(set, container);
            }
            ++i;
        }
    }

    private void removeFromSet(ObjectSet<Object> set, IASTNode container) {
        int i = 0;
        while (i < set.size()) {
            Object o = set.keyAt(i);
            if (o instanceof IASTName && container.contains((IASTNode)o)) {
                set.remove(o);
                --i;
            }
            ++i;
        }
    }

    @Override
    public IBinding[] find(String name, IASTTranslationUnit tu) {
        return this.find(name);
    }

    @Override
    public IBinding[] find(String name) {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    @Override
    public void addBinding(IBinding binding) {
        char[] c;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((c = binding.getNameCharArray()).length == 0) {
            return;
        }
        Object o = this.bindings.get(c);
        if (o != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(binding);
            } else {
                ObjectSet<Object> set = new ObjectSet<Object>(2);
                set.put(o);
                set.put(binding);
                this.bindings.put(c, set);
            }
        } else {
            this.bindings.put(c, binding);
        }
    }

    @Override
    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    @Override
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefix));
    }

    @Override
    public IName getScopeName() {
        return null;
    }

    public String toString() {
        IName name = this.getScopeName();
        String n = name != null ? name.toString() : "<unnamed scope>";
        return String.valueOf(this.getKind().toString()) + ' ' + n + ' ' + '(' + super.toString() + ')';
    }

    public static class CPPScopeProblem
    extends ProblemBinding
    implements ICPPScope {
        public CPPScopeProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public CPPScopeProblem(IASTName name, int id) {
            super(name, id);
        }
    }
}

