/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.character;

import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;

public class CharacterMS
extends PageComponent {
    private int backgroundColor = -1;
    private int foregroundColor = -1;
    private Topology topology = null;
    private int[][] image = null;

    public CharacterMS(IPageImage iPageImage, ConnectedComponent connectedComponent, Container container, int[][] nArray) throws ImageException {
        super((short)5, iPageImage);
        this.cc = connectedComponent;
        this.container = container;
        this.backgroundColor = container.getColor();
        this.topology = new Topology(this.cc.thinning());
        if (nArray != null) {
            int n = this.cc.getShape().getWidth();
            int n2 = this.cc.getShape().getHeight();
            int n3 = this.cc.getLeft();
            int n4 = this.cc.getTop();
            this.image = new int[n2][n];
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            byte[][] byArray = this.cc.getShape().getData();
            int n8 = 0;
            while (n8 < n2) {
                int n9 = 0;
                while (n9 < n) {
                    this.image[n8][n9] = nArray[n8 + n4][n9 + n3];
                    if (byArray[n8][n9] != 0) {
                        int n10 = this.image[n8][n9];
                        n5 += n10 >> 16 & 0xFF;
                        n6 += n10 >> 8 & 0xFF;
                        n7 += n10 & 0xFF;
                    }
                    ++n9;
                }
                ++n8;
            }
            this.foregroundColor = (n5 /= this.cc.getCount()) << 16 | (n6 /= this.cc.getCount()) << 8 | (n7 /= this.cc.getCount());
        }
    }

    public CharacterMS(IPageImage iPageImage, ConnectedComponent connectedComponent, Container container, IInt2D iInt2D) throws ImageException {
        this(iPageImage, connectedComponent, container, iInt2D.getData());
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public IInt2D getInt2D() throws ImageException {
        return new Int2D(this.cc.getShape().getWidth(), this.cc.getShape().getHeight(), this.image);
    }

    public IInt2D makeMarginedImage(int n) throws ImageException {
        if (n == 0) {
            return this.getInt2D();
        }
        if (n < 0) {
            throw new ImageException("The margin must be non-negative.");
        }
        Int2D int2D = new Int2D(this.cc.getShape().getWidth() + 2 * n, this.cc.getShape().getHeight() + 2 * n);
        int2D.fill(this.backgroundColor);
        int n2 = 0;
        while (n2 < this.cc.getShape().getHeight()) {
            int n3 = 0;
            while (n3 < this.cc.getShape().getWidth()) {
                int2D.getData()[n2 + n][n3 + n] = this.image[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return int2D;
    }

    public Topology getTopology() {
        return this.topology;
    }
}

