/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IBuildPropertiesRestriction;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IConfigurationNameProvider;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IProjectEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObjectProperties;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.IBuildPropertyChangeListener;
import org.eclipse.cdt.managedbuilder.macros.IProjectBuildMacroSupplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Version;

public class ProjectType
extends BuildObject
implements IProjectType,
IBuildPropertiesRestriction,
IBuildPropertyChangeListener {
    private static final String EMPTY_STRING = "";
    private IProjectType superClass;
    private String superClassId;
    private List<Configuration> configList;
    private Map<String, IConfiguration> configMap;
    private Boolean isAbstract;
    private Boolean isTest;
    private String unusedChildren;
    private String convertToId;
    private IConfigurationElement configurationNameProviderElement = null;
    private IConfigurationNameProvider configurationNameProvider = null;
    private IConfigurationElement environmentVariableSupplierElement = null;
    private IProjectEnvironmentVariableSupplier environmentVariableSupplier = null;
    private IConfigurationElement buildMacroSupplierElement = null;
    private IProjectBuildMacroSupplier buildMacroSupplier = null;
    BuildObjectProperties buildProperties;
    private boolean resolved = false;
    private IConfigurationElement previousMbsVersionConversionElement;
    private IConfigurationElement currentMbsVersionConversionElement;

    public ProjectType(IManagedConfigElement element, String managedBuildRevision) {
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionProjectType(this);
        IManagedConfigElement[] configs = element.getChildren("configuration");
        String[] usedConfigNames = new String[configs.length];
        IConfigurationNameProvider configurationNameProvder = this.getConfigurationNameProvider();
        if (configurationNameProvder != null) {
            int n = 0;
            while (n < configs.length) {
                Configuration config = new Configuration(this, configs[n], managedBuildRevision);
                String newConfigName = configurationNameProvder.getNewConfigurationName(config, usedConfigNames);
                config.setName(newConfigName);
                usedConfigNames[n] = newConfigName;
                ++n;
            }
        } else {
            int n = 0;
            while (n < configs.length) {
                Configuration configuration = new Configuration(this, configs[n], managedBuildRevision);
                ++n;
            }
        }
    }

    public ProjectType(ProjectType superClass, String Id, String name, String managedBuildRevision) {
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setManagedBuildRevision(managedBuildRevision);
        this.setVersion(this.getVersionFromId());
        ManagedBuildManager.addExtensionProjectType(this);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String buildMacroSupplier;
        String environmentVariableSupplier;
        String isTestStr;
        String artType;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(SafeStringInterner.safeIntern((String)element.getAttribute("id")));
        this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        this.setVersion(this.getVersionFromId());
        this.superClassId = SafeStringInterner.safeIntern((String)element.getAttribute("superClass"));
        String props = SafeStringInterner.safeIntern((String)element.getAttribute("buildProperties"));
        if (props != null) {
            this.buildProperties = new BuildObjectProperties(props, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
        }
        if ((artType = SafeStringInterner.safeIntern((String)element.getAttribute("buildArtefactType"))) != null) {
            if (this.buildProperties == null) {
                this.buildProperties = new BuildObjectProperties(this, this);
            }
            try {
                this.buildProperties.setProperty("org.eclipse.cdt.build.core.buildArtefactType", artType, true);
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        this.unusedChildren = SafeStringInterner.safeIntern((String)element.getAttribute("unusedChildren"));
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = Boolean.parseBoolean(isAbs);
        }
        if ((isTestStr = element.getAttribute("isTest")) != null) {
            this.isTest = Boolean.parseBoolean(isTestStr);
        }
        if (element.getAttribute("configurationNameProvider") != null && element instanceof DefaultManagedConfigElement) {
            this.configurationNameProviderElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((environmentVariableSupplier = element.getAttribute("projectEnvironmentSupplier")) != null && element instanceof DefaultManagedConfigElement) {
            this.environmentVariableSupplierElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((buildMacroSupplier = element.getAttribute("projectMacroSupplier")) != null && element instanceof DefaultManagedConfigElement) {
            this.buildMacroSupplierElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        this.convertToId = SafeStringInterner.safeIntern((String)element.getAttribute("convertToId"));
    }

    @Override
    public IConfiguration createConfiguration(IConfiguration parent, String id, String name) {
        Configuration config = new Configuration(this, parent, id, name);
        return config;
    }

    @Override
    public IConfiguration getConfiguration(String id) {
        return this.getConfigurationMap().get(id);
    }

    @Override
    public IConfiguration[] getConfigurations() {
        IConfiguration[] configs = this.getConfigurationList().toArray(new IConfiguration[0]);
        return configs;
    }

    @Override
    public void removeConfiguration(String id) {
        ListIterator<Configuration> iter = this.getConfigurationList().listIterator();
        while (iter.hasNext()) {
            IConfiguration config = (IConfiguration)iter.next();
            if (!config.getId().equals(id)) continue;
            this.getConfigurationList().remove(config);
            this.getConfigurationMap().remove(id);
            break;
        }
    }

    public void addConfiguration(Configuration configuration) {
        if (!configuration.isTemporary()) {
            this.getConfigurationList().add(configuration);
            this.getConfigurationMap().put(configuration.getId(), configuration);
        }
    }

    private List<Configuration> getConfigurationList() {
        if (this.configList == null) {
            this.configList = new ArrayList<Configuration>();
        }
        return this.configList;
    }

    private Map<String, IConfiguration> getConfigurationMap() {
        if (this.configMap == null) {
            this.configMap = new HashMap<String, IConfiguration>();
        }
        return this.configMap;
    }

    @Override
    public String getName() {
        IBuildObjectProperties props;
        IBuildProperty prop;
        String name = this.getNameAttribute();
        if (name.length() == 0 && (prop = (props = this.getBuildProperties()).getProperty("org.eclipse.cdt.build.core.buildArtefactType")) != null) {
            name = prop.getValue().getName();
        }
        return name;
    }

    @Override
    public String getNameAttribute() {
        if (this.name == null) {
            if (this.superClass != null) {
                return this.superClass.getNameAttribute();
            }
            return EMPTY_STRING;
        }
        return this.name;
    }

    @Override
    public IProjectType getSuperClass() {
        return this.superClass;
    }

    @Override
    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    @Override
    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    @Override
    public boolean isTestProjectType() {
        if (this.isTest == null) {
            if (this.superClass != null) {
                return this.superClass.isTestProjectType();
            }
            return false;
        }
        return this.isTest;
    }

    @Override
    public void setIsAbstract(boolean b) {
        this.isAbstract = b;
    }

    public void setIsTest(boolean b) {
        this.isTest = b;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionProjectType(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.outputResolveError("superClass", this.superClassId, "projectType", this.getId());
                }
            }
            if (this.superClass != null) {
                ((ProjectType)this.superClass).resolveReferences();
                IConfiguration[] superConfigs = this.superClass.getConfigurations();
                int i = 0;
                while (i < superConfigs.length) {
                    block9: {
                        String superId = superConfigs[i].getId();
                        IConfiguration[] currentConfigs = this.getConfigurations();
                        int j = 0;
                        while (j < currentConfigs.length) {
                            IConfiguration config = currentConfigs[j];
                            while (config.getParent() != null) {
                                if (!config.getParent().getId().equals(superId)) {
                                    config = config.getParent();
                                    continue;
                                }
                                break block9;
                            }
                            ++j;
                        }
                        this.addConfiguration((Configuration)superConfigs[i]);
                    }
                    ++i;
                }
            }
            List<Configuration> configurationList = this.getConfigurationList();
            for (Configuration current : configurationList) {
                current.resolveReferences();
            }
        }
    }

    @Override
    public boolean isSupported() {
        List<Configuration> configurationList = this.getConfigurationList();
        for (Configuration current : configurationList) {
            if (!current.isSupported()) continue;
            return true;
        }
        return false;
    }

    public IConfigurationElement getConfigurationNameProviderElement() {
        if (this.configurationNameProviderElement == null && this.superClass != null) {
            ProjectType tmpSuperClass = (ProjectType)this.superClass;
            return tmpSuperClass.getConfigurationNameProviderElement();
        }
        return this.configurationNameProviderElement;
    }

    public void setConfigurationNameProviderElement(IConfigurationElement configurationElement) {
        this.configurationNameProviderElement = configurationElement;
    }

    @Override
    public IConfigurationNameProvider getConfigurationNameProvider() {
        if (this.configurationNameProvider != null) {
            return this.configurationNameProvider;
        }
        IConfigurationElement element = this.getConfigurationNameProviderElement();
        if (element != null) {
            try {
                if (element.getAttribute("configurationNameProvider") != null) {
                    this.configurationNameProvider = (IConfigurationNameProvider)element.createExecutableExtension("configurationNameProvider");
                    return this.configurationNameProvider;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public IConfigurationElement getEnvironmentVariableSupplierElement() {
        if (this.environmentVariableSupplierElement == null && this.superClass != null && this.superClass instanceof ProjectType) {
            return ((ProjectType)this.superClass).getEnvironmentVariableSupplierElement();
        }
        return this.environmentVariableSupplierElement;
    }

    @Override
    public IProjectEnvironmentVariableSupplier getEnvironmentVariableSupplier() {
        if (this.environmentVariableSupplier != null) {
            return this.environmentVariableSupplier;
        }
        IConfigurationElement element = this.getEnvironmentVariableSupplierElement();
        if (element != null) {
            try {
                if (element.getAttribute("projectEnvironmentSupplier") != null) {
                    this.environmentVariableSupplier = (IProjectEnvironmentVariableSupplier)element.createExecutableExtension("projectEnvironmentSupplier");
                    return this.environmentVariableSupplier;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public IConfigurationElement getBuildMacroSupplierElement() {
        if (this.buildMacroSupplierElement == null && this.superClass != null && this.superClass instanceof ProjectType) {
            return ((ProjectType)this.superClass).getBuildMacroSupplierElement();
        }
        return this.buildMacroSupplierElement;
    }

    @Override
    public IProjectBuildMacroSupplier getBuildMacroSupplier() {
        if (this.buildMacroSupplier != null) {
            return this.buildMacroSupplier;
        }
        IConfigurationElement element = this.getBuildMacroSupplierElement();
        if (element != null) {
            try {
                if (element.getAttribute("projectMacroSupplier") != null) {
                    this.buildMacroSupplier = (IProjectBuildMacroSupplier)element.createExecutableExtension("projectMacroSupplier");
                    return this.buildMacroSupplier;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getConvertToId() {
        if (this.convertToId == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getConvertToId();
            }
            return EMPTY_STRING;
        }
        return this.convertToId;
    }

    @Override
    public void setConvertToId(String convertToId) {
        if (convertToId == null && this.convertToId == null) {
            return;
        }
        if (convertToId == null || this.convertToId == null || !convertToId.equals(this.convertToId)) {
            this.convertToId = convertToId;
        }
    }

    @Override
    public boolean checkForMigrationSupport() {
        String convertToId = this.getConvertToId();
        if (convertToId == null || convertToId.isEmpty()) {
            return true;
        }
        return this.getConverter(convertToId);
    }

    private boolean getConverter(String convertToId) {
        String fromId = null;
        String toId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter")) {
                        fromId = element.getAttribute("fromId");
                        toId = element.getAttribute("toId");
                        if (fromId.equals(this.getId()) && toId.equals(convertToId)) {
                            String mbsVersion = element.getAttribute("mbsVersion");
                            Version currentMbsVersion = ManagedBuildManager.getBuildInfoVersion();
                            if (currentMbsVersion.compareTo(new Version(mbsVersion)) > 0) {
                                this.previousMbsVersionConversionElement = element;
                            } else {
                                this.currentMbsVersionConversionElement = element;
                            }
                            return true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public IConfigurationElement getPreviousMbsVersionConversionElement() {
        return this.previousMbsVersionConversionElement;
    }

    public IConfigurationElement getCurrentMbsVersionConversionElement() {
        return this.currentMbsVersionConversionElement;
    }

    @Override
    public IBuildObjectProperties getBuildProperties() {
        if (this.buildProperties == null) {
            BuildObjectProperties parentProps = this.findBuildProperties();
            this.buildProperties = parentProps != null ? new BuildObjectProperties(parentProps, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this) : new BuildObjectProperties(this, this);
        }
        return this.buildProperties;
    }

    BuildObjectProperties findBuildProperties() {
        if (this.buildProperties == null) {
            if (this.superClass != null) {
                return ((ProjectType)this.superClass).findBuildProperties();
            }
            return null;
        }
        return this.buildProperties;
    }

    @Override
    public void propertiesChanged() {
        List<Configuration> list = this.getConfigurationList();
        int i = 0;
        while (i < list.size()) {
            list.get(i).propertiesChanged();
            ++i;
        }
    }

    public boolean supportsType(IBuildPropertyType type) {
        return this.supportsType(type.getId());
    }

    public boolean supportsValue(IBuildPropertyType type, IBuildPropertyValue value) {
        return this.supportsValue(type.getId(), value.getId());
    }

    @Override
    public boolean supportsType(String typeId) {
        List<Configuration> list = this.getConfigurationList();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).supportsType(typeId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean supportsValue(String typeId, String valueId) {
        List<Configuration> list = this.getConfigurationList();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).supportsValue(typeId, valueId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String[] getRequiredTypeIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<Configuration> list = this.getConfigurationList();
        int i = 0;
        while (i < list.size()) {
            result.addAll(Arrays.asList(list.get(i).getRequiredTypeIds()));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getSupportedTypeIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<Configuration> list = this.getConfigurationList();
        int i = 0;
        while (i < list.size()) {
            result.addAll(Arrays.asList(list.get(i).getSupportedTypeIds()));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getSupportedValueIds(String typeId) {
        ArrayList<String> result = new ArrayList<String>();
        List<Configuration> list = this.getConfigurationList();
        int i = 0;
        while (i < list.size()) {
            result.addAll(Arrays.asList(list.get(i).getSupportedValueIds(typeId)));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean requiresType(String typeId) {
        List<Configuration> list = this.getConfigurationList();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).requiresType(typeId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public IBuildPropertyValue getBuildArtefactType() {
        IBuildProperty prop;
        BuildObjectProperties props = this.findBuildProperties();
        if (props != null && (prop = props.getProperty("org.eclipse.cdt.build.core.buildArtefactType")) != null) {
            return prop.getValue();
        }
        return null;
    }

    @Override
    public boolean isSystemObject() {
        return this.isTestProjectType() || this.getConvertToId().length() != 0;
    }
}

