/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.math.BigInteger;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class MemoryStats {
    @JsonProperty(value="stats")
    private Stats stats;
    @JsonProperty(value="max_usage")
    private Long maxUsage;
    @JsonProperty(value="usage")
    private Long usage;
    @JsonProperty(value="failcnt")
    private Long failcnt;
    @JsonProperty(value="limit")
    private Long limit;

    public Stats stats() {
        return this.stats;
    }

    public Long maxUsage() {
        return this.maxUsage;
    }

    public Long usage() {
        return this.usage;
    }

    public Long failcnt() {
        return this.failcnt;
    }

    public Long limit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryStats that = (MemoryStats)o;
        return Objects.equals(this.stats, that.stats) && Objects.equals(this.maxUsage, that.maxUsage) && Objects.equals(this.usage, that.usage) && Objects.equals(this.failcnt, that.failcnt) && Objects.equals(this.limit, that.limit);
    }

    public int hashCode() {
        return Objects.hash(this.stats, this.maxUsage, this.usage, this.failcnt, this.limit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stats", (Object)this.stats).add("failcnt", (Object)this.failcnt).add("limit", (Object)this.limit).add("maxUsage", (Object)this.maxUsage).add("usage", (Object)this.usage).toString();
    }

    public static class Stats {
        @JsonProperty(value="total_pgmajfault")
        private Long totalPgmajfault;
        @JsonProperty(value="cache")
        private Long cache;
        @JsonProperty(value="mapped_file")
        private Long mappedFile;
        @JsonProperty(value="total_inactive_file")
        private Long totalInactiveFile;
        @JsonProperty(value="pgpgout")
        private Long pgpgout;
        @JsonProperty(value="rss")
        private Long rss;
        @JsonProperty(value="total_mapped_file")
        private Long totalMappedFile;
        @JsonProperty(value="writeback")
        private Long writeback;
        @JsonProperty(value="unevictable")
        private Long unevictable;
        @JsonProperty(value="pgpgin")
        private Long pgpgin;
        @JsonProperty(value="total_unevictable")
        private Long totalUnevictable;
        @JsonProperty(value="pgmajfault")
        private Long pgmajfault;
        @JsonProperty(value="total_rss")
        private Long totalRss;
        @JsonProperty(value="total_rss_huge")
        private Long totalRssHuge;
        @JsonProperty(value="total_writeback")
        private Long totalWriteback;
        @JsonProperty(value="total_inactive_anon")
        private Long totalInactiveAnon;
        @JsonProperty(value="rss_huge")
        private Long rssHuge;
        @JsonProperty(value="hierarchical_memory_limit")
        private BigInteger hierarchicalMemoryLimit;
        @JsonProperty(value="total_pgfault")
        private Long totalPgfault;
        @JsonProperty(value="total_active_file")
        private Long totalActiveFile;
        @JsonProperty(value="active_anon")
        private Long activeAnon;
        @JsonProperty(value="total_active_anon")
        private Long totalActiveAnon;
        @JsonProperty(value="total_pgpgout")
        private Long totalPgpgout;
        @JsonProperty(value="total_cache")
        private Long totalCache;
        @JsonProperty(value="inactive_anon")
        private Long inactiveAnon;
        @JsonProperty(value="active_file")
        private Long activeFile;
        @JsonProperty(value="pgfault")
        private Long pgfault;
        @JsonProperty(value="inactive_file")
        private Long inactiveFile;
        @JsonProperty(value="total_pgpgin")
        private Long totalPgpgin;

        public Long totalPgmajfault() {
            return this.totalPgmajfault;
        }

        public Long cache() {
            return this.cache;
        }

        public Long mappedFile() {
            return this.mappedFile;
        }

        public Long totalInactiveFile() {
            return this.totalInactiveFile;
        }

        public Long pgpgout() {
            return this.pgpgout;
        }

        public Long rss() {
            return this.rss;
        }

        public Long totalMappedFile() {
            return this.totalMappedFile;
        }

        public Long writeback() {
            return this.writeback;
        }

        public Long unevictable() {
            return this.unevictable;
        }

        public Long pgpgin() {
            return this.pgpgin;
        }

        public Long totalUnevictable() {
            return this.totalUnevictable;
        }

        public Long pgmajfault() {
            return this.pgmajfault;
        }

        public Long totalRss() {
            return this.totalRss;
        }

        public Long totalRssHuge() {
            return this.totalRssHuge;
        }

        public Long totalWriteback() {
            return this.totalWriteback;
        }

        public Long totalInactiveAnon() {
            return this.totalInactiveAnon;
        }

        public Long rssHuge() {
            return this.rssHuge;
        }

        public BigInteger hierarchicalMemoryLimit() {
            return this.hierarchicalMemoryLimit;
        }

        public Long totalPgfault() {
            return this.totalPgfault;
        }

        public Long totalActiveFile() {
            return this.totalActiveFile;
        }

        public Long activeAnon() {
            return this.activeAnon;
        }

        public Long totalActiveAnon() {
            return this.totalActiveAnon;
        }

        public Long totalPgpgout() {
            return this.totalPgpgout;
        }

        public Long totalCache() {
            return this.totalCache;
        }

        public Long inactiveAnon() {
            return this.inactiveAnon;
        }

        public Long activeFile() {
            return this.activeFile;
        }

        public Long pgfault() {
            return this.pgfault;
        }

        public Long inactiveFile() {
            return this.inactiveFile;
        }

        public Long totalPgpgin() {
            return this.totalPgpgin;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats that = (Stats)o;
            return Objects.equals(this.totalPgmajfault, that.totalPgmajfault) && Objects.equals(this.cache, that.cache) && Objects.equals(this.mappedFile, that.mappedFile) && Objects.equals(this.totalInactiveFile, that.totalInactiveFile) && Objects.equals(this.pgpgout, that.pgpgout) && Objects.equals(this.rss, that.rss) && Objects.equals(this.totalMappedFile, that.totalMappedFile) && Objects.equals(this.writeback, that.writeback) && Objects.equals(this.unevictable, that.unevictable) && Objects.equals(this.pgpgin, that.pgpgin) && Objects.equals(this.totalUnevictable, that.totalUnevictable) && Objects.equals(this.pgmajfault, that.pgmajfault) && Objects.equals(this.totalRss, that.totalRss) && Objects.equals(this.totalRssHuge, that.totalRssHuge) && Objects.equals(this.totalWriteback, that.totalWriteback) && Objects.equals(this.totalInactiveAnon, that.totalInactiveAnon) && Objects.equals(this.rssHuge, that.rssHuge) && Objects.equals(this.hierarchicalMemoryLimit, that.hierarchicalMemoryLimit) && Objects.equals(this.totalPgfault, that.totalPgfault) && Objects.equals(this.totalActiveFile, that.totalActiveFile) && Objects.equals(this.activeAnon, that.activeAnon) && Objects.equals(this.totalActiveAnon, that.totalActiveAnon) && Objects.equals(this.totalPgpgout, that.totalPgpgout) && Objects.equals(this.totalCache, that.totalCache) && Objects.equals(this.inactiveAnon, that.inactiveAnon) && Objects.equals(this.activeFile, that.activeFile) && Objects.equals(this.pgfault, that.pgfault) && Objects.equals(this.inactiveFile, that.inactiveFile) && Objects.equals(this.totalPgpgin, that.totalPgpgin);
        }

        public int hashCode() {
            return Objects.hash(this.totalPgmajfault, this.cache, this.mappedFile, this.totalInactiveFile, this.pgpgout, this.rss, this.totalMappedFile, this.writeback, this.unevictable, this.pgpgin, this.totalUnevictable, this.pgmajfault, this.totalRss, this.totalRssHuge, this.totalWriteback, this.totalInactiveAnon, this.rssHuge, this.hierarchicalMemoryLimit, this.totalPgfault, this.totalActiveFile, this.activeAnon, this.totalActiveAnon, this.totalPgpgout, this.totalCache, this.inactiveAnon, this.activeFile, this.pgfault, this.inactiveFile, this.totalPgpgin);
        }
    }
}

