/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.forms;

import org.eclipse.linuxtools.internal.rpm.ui.editor.forms.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.SpecfileTag;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class RpmTagText {
    public RpmTagText(Composite parent, String rpmTag, Specfile specfile) {
        this(parent, rpmTag, specfile, 4);
    }

    public RpmTagText(Composite parent, String rpmTag, Specfile specfile, int flag) {
        Label label = new Label(parent, 4);
        label.setText(rpmTag);
        Text text = new Text(parent, 1 | flag);
        SpecfileDefine define = specfile.getDefine(rpmTag);
        if (define != null) {
            if (define.getTagType().equals((Object)SpecfileTag.TagType.INT)) {
                text.setText(String.valueOf(define.getIntValue()));
            } else {
                text.setText(define.getStringValue());
            }
        }
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(e -> specfile.modifyDefine(rpmTag, text.getText()));
    }

    public RpmTagText(Composite parent, String rpmTag, Specfile specfile, SpecfilePackage rpmPackage, int flag) {
        Label label = new Label(parent, 4);
        label.setText(rpmTag);
        Text text = new Text(parent, 1 | flag);
        SpecfileDefine define = specfile.getDefine(rpmTag, rpmPackage);
        if (define != null) {
            text.setText(define.getStringValue());
        }
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(e -> specfile.modifyDefine(rpmTag, rpmPackage, text.getText()));
    }

    public RpmTagText(Composite parent, SpecfileTag require, Specfile specfile) {
        Label label = new Label(parent, 4);
        label.setText(Messages.RpmTagText_0);
        Text text = new Text(parent, 1);
        text.setText(require.getStringValue());
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(e -> specfile.modifyDefine(require, text.getText()));
    }
}

