/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.contenttype;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.json.core.internal.contenttype.ByteReader;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.sse.core.internal.encoding.NonContentBasedEncodingRules;

public class JSONResourceEncodingDetector
implements IResourceCharsetDetector {
    private EncodingMemento fEncodingMemento;
    private boolean fHeaderParsed;
    private Reader fReader;

    public String getEncoding() throws IOException {
        return this.getEncodingMemento().getDetectedCharsetName();
    }

    public EncodingMemento getEncodingMemento() throws IOException {
        if (this.fEncodingMemento == null) {
            this.fEncodingMemento = new NullMemento();
        }
        return this.fEncodingMemento;
    }

    public String getSpecDefaultEncoding() {
        return null;
    }

    private void resetAll() {
        this.fReader = null;
        this.fHeaderParsed = false;
        this.fEncodingMemento = null;
    }

    public void set(InputStream inputStream) {
        this.resetAll();
        this.fReader = new ByteReader(inputStream);
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void set(Reader reader) {
        this.resetAll();
        this.fReader = reader;
        if (!this.fReader.markSupported()) {
            this.fReader = new BufferedReader(this.fReader);
        }
        try {
            this.fReader.mark(8192);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void set(IStorage iStorage) throws CoreException {
        this.resetAll();
        InputStream inputStream = iStorage.getContents();
        BufferedInputStream resettableStream = new BufferedInputStream(inputStream, 8192);
        ((InputStream)resettableStream).mark(8192);
        this.set(resettableStream);
    }

    class NullMemento
    extends EncodingMemento {
        public NullMemento() {
            String defaultCharset = NonContentBasedEncodingRules.useDefaultNameRules(null);
            this.setJavaCharsetName(defaultCharset);
            this.setAppropriateDefault(defaultCharset);
            this.setDetectedCharsetName(null);
        }
    }
}

