/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.ValueNotFoundException;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.VariableValueNotFoundInfo;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequest;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;

public class UnusedEvaluationRequestSet {
    private final Map<Variable, Set<UnusedEvaluationRequest>> requests;

    private UnusedEvaluationRequestSet(Map<Variable, Set<UnusedEvaluationRequest>> requests) {
        this.requests = requests;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.requests == null ? 0 : this.requests.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedEvaluationRequestSet)) {
            return false;
        }
        UnusedEvaluationRequestSet other = (UnusedEvaluationRequestSet)obj;
        return !(this.requests == null ? other.requests != null : !this.requests.equals(other.requests));
    }

    public UnusedEvaluationRequestSet createReducedSet(Set<Variable> variablesThatLeaveOrEnterScope, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory) {
        UnusedEvaluationRequestSet result = this;
        if (!this.requests.isEmpty() && !variablesThatLeaveOrEnterScope.isEmpty()) {
            boolean changed = false;
            HashMap<Variable, Set<UnusedEvaluationRequest>> remainingRequestsUpdated = new HashMap<Variable, Set<UnusedEvaluationRequest>>();
            for (Map.Entry<Variable, Set<UnusedEvaluationRequest>> e : this.requests.entrySet()) {
                if (!variablesThatLeaveOrEnterScope.contains(e.getKey())) {
                    boolean setChanged = false;
                    UnusedEvaluationRequest[] newSet = new UnusedEvaluationRequest[e.getValue().size()];
                    int newSetIndex = 0;
                    for (UnusedEvaluationRequest request : e.getValue()) {
                        UnusedEvaluationRequest newRequest = request.getRequestWithSlotsRemoved(variablesThatLeaveOrEnterScope, unusedEvaluationRequestFactory);
                        if (newRequest != request) {
                            changed = true;
                            setChanged = true;
                        }
                        if (!newRequest.hasOneOrMoreSlots()) {
                            throw new RuntimeException("Internal error: an UnusedEvaluationRequest whose unknown variable is still in scope claims to have lost all its slots; the slot for the unknown variable should, however, still be there.");
                        }
                        newSet[newSetIndex++] = newRequest;
                    }
                    if (setChanged) {
                        HashSet<UnusedEvaluationRequest> newSetAsSet = new HashSet<UnusedEvaluationRequest>();
                        int i = 0;
                        while (i < newSetIndex) {
                            newSetAsSet.add(newSet[i]);
                            ++i;
                        }
                        remainingRequestsUpdated.put(e.getKey(), newSetAsSet);
                        continue;
                    }
                    remainingRequestsUpdated.put(e.getKey(), e.getValue());
                    continue;
                }
                changed = true;
            }
            result = changed ? new UnusedEvaluationRequestSet(remainingRequestsUpdated) : this;
        }
        return result;
    }

    public UnusedEvaluationResult setVariable(Variable variable, EObject value, OppositeEndFinder oppositeEndFinder, TracebackCache tracebackCache, OCLFactory oclFactory) {
        UnusedEvaluationResult result;
        boolean changed = false;
        HashMap<Variable, Set<UnusedEvaluationRequest>> newRequestSet = new HashMap<Variable, Set<UnusedEvaluationRequest>>();
        for (Map.Entry<Variable, Set<UnusedEvaluationRequest>> e : this.requests.entrySet()) {
            UnusedEvaluationRequest[] newSet = new UnusedEvaluationRequest[e.getValue().size()];
            int newSetIndex = 0;
            boolean setChanged = false;
            for (UnusedEvaluationRequest request : e.getValue()) {
                UnusedEvaluationRequest clonedRequest = request.setInferredVariableValue(variable, value, tracebackCache.getUnusedEvaluationRequestFactory());
                newSet[newSetIndex++] = clonedRequest;
                if (clonedRequest == request) continue;
                changed = true;
                setChanged = true;
            }
            if (!setChanged) {
                newRequestSet.put(e.getKey(), e.getValue());
                continue;
            }
            HashSet<UnusedEvaluationRequest> set = new HashSet<UnusedEvaluationRequest>();
            int i = 0;
            while (i < newSetIndex) {
                set.add(newSet[i]);
                ++i;
            }
            newRequestSet.put(e.getKey(), set);
        }
        Collection triggered = (Collection)newRequestSet.get(variable);
        if (triggered != null) {
            newRequestSet.remove(variable);
            changed = true;
            UnusedEvaluationRequestSet nextSet = new UnusedEvaluationRequestSet(newRequestSet);
            UnusedEvaluationResult preResult = UnusedEvaluationRequestSet.evaluate(triggered, oppositeEndFinder, tracebackCache, oclFactory);
            result = new UnusedEvaluationResult(preResult.hasProvenUnused(), nextSet.merge(preResult.getNewRequestSet()));
        } else {
            result = new UnusedEvaluationResult(false, changed ? new UnusedEvaluationRequestSet(newRequestSet) : this);
        }
        return result;
    }

    public static UnusedEvaluationResult evaluate(Collection<UnusedEvaluationRequest> requestsToEvaluate, OppositeEndFinder oppositeEndFinder, TracebackCache tracebackCache, OCLFactory oclFactory) {
        UnusedEvaluationResult result = null;
        HashMap<Variable, Set<UnusedEvaluationRequest>> newRequestSet = null;
        if (requestsToEvaluate != null) {
            newRequestSet = new HashMap<Variable, Set<UnusedEvaluationRequest>>(2);
            for (UnusedEvaluationRequest request : requestsToEvaluate) {
                Object evaluationResult = tracebackCache.getCachedEvaluationResult(request);
                if (evaluationResult == null) {
                    evaluationResult = request.checkValuePresentForAllRequiredVariables();
                    if (evaluationResult == null) {
                        try {
                            evaluationResult = request.evaluate(oppositeEndFinder, oclFactory);
                        }
                        catch (ValueNotFoundException vnfe) {
                            evaluationResult = vnfe;
                        }
                    }
                    tracebackCache.cacheEvaluationResult(request, evaluationResult);
                }
                if (evaluationResult instanceof VariableValueNotFoundInfo) {
                    Variable unknownVariable = (Variable)((VariableValueNotFoundInfo)evaluationResult).getVariableExp().getReferredVariable();
                    HashSet<UnusedEvaluationRequest> newSet = (HashSet<UnusedEvaluationRequest>)newRequestSet.get(unknownVariable);
                    if (newSet == null) {
                        newSet = new HashSet<UnusedEvaluationRequest>();
                        newRequestSet.put(unknownVariable, newSet);
                    }
                    newSet.add(request);
                    continue;
                }
                if (!((Boolean)evaluationResult).booleanValue()) continue;
                result = new UnusedEvaluationResult(true, null);
                break;
            }
        }
        if (result == null) {
            result = new UnusedEvaluationResult(false, newRequestSet == null || newRequestSet.isEmpty() ? null : new UnusedEvaluationRequestSet(newRequestSet));
        }
        return result;
    }

    public UnusedEvaluationRequestSet merge(UnusedEvaluationRequestSet other) {
        if (other == null || other.requests.isEmpty()) {
            if (this.requests.isEmpty()) {
                return null;
            }
            return this;
        }
        if (this.requests.isEmpty()) {
            return other;
        }
        HashMap<Variable, Set<UnusedEvaluationRequest>> newRequests = new HashMap<Variable, Set<UnusedEvaluationRequest>>(this.requests);
        for (Map.Entry<Variable, Set<UnusedEvaluationRequest>> e : other.requests.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            Set<UnusedEvaluationRequest> set = (Set<UnusedEvaluationRequest>)newRequests.get(e.getKey());
            if (set == null || set.isEmpty()) {
                set = e.getValue();
            } else {
                HashSet<UnusedEvaluationRequest> newSet = new HashSet<UnusedEvaluationRequest>(set.size() + 1);
                newSet.addAll(set);
                newSet.addAll((Collection)e.getValue());
                set = newSet;
            }
            newRequests.put(e.getKey(), set);
        }
        return new UnusedEvaluationRequestSet(newRequests);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("requests by unknown variable: [");
        boolean firstVariable = true;
        for (Map.Entry<Variable, Set<UnusedEvaluationRequest>> e : this.requests.entrySet()) {
            if (!firstVariable) {
                result.append(", ");
            } else {
                firstVariable = false;
            }
            result.append(e.getKey().getName());
            result.append(": [");
            boolean first = true;
            for (UnusedEvaluationRequest request : e.getValue()) {
                if (!first) {
                    result.append(",");
                } else {
                    first = false;
                }
                result.append(request);
            }
            result.append("]");
        }
        result.append("]");
        return result.toString();
    }

    public static class UnusedEvaluationResult {
        private final boolean provedUnused;
        private final UnusedEvaluationRequestSet newRequestSet;

        private UnusedEvaluationResult(boolean provedUnused, UnusedEvaluationRequestSet newRequestSet) {
            this.provedUnused = provedUnused;
            this.newRequestSet = newRequestSet;
        }

        public boolean hasProvenUnused() {
            return this.provedUnused;
        }

        public UnusedEvaluationRequestSet getNewRequestSet() {
            return this.newRequestSet;
        }

        public String toString() {
            return "[unused: " + this.provedUnused + ", newRequestSet: " + this.newRequestSet + "]";
        }
    }
}

