/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.generation.files;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.java.ASTNode;
import org.eclipse.modisco.java.AbstractMethodInvocation;
import org.eclipse.modisco.java.AbstractTypeDeclaration;
import org.eclipse.modisco.java.AbstractVariablesContainer;
import org.eclipse.modisco.java.AnnotationTypeDeclaration;
import org.eclipse.modisco.java.BodyDeclaration;
import org.eclipse.modisco.java.ClassDeclaration;
import org.eclipse.modisco.java.Comment;
import org.eclipse.modisco.java.CompilationUnit;
import org.eclipse.modisco.java.EnumDeclaration;
import org.eclipse.modisco.java.FieldDeclaration;
import org.eclipse.modisco.java.InterfaceDeclaration;
import org.eclipse.modisco.java.Modifier;
import org.eclipse.modisco.java.NamedElement;
import org.eclipse.modisco.java.Package;
import org.eclipse.modisco.java.TypeDeclaration;
import org.eclipse.modisco.java.VariableDeclarationFragment;
import org.eclipse.modisco.java.emf.util.JavaSwitch;
import org.eclipse.modisco.java.generation.utils.IndentingStringBuilder;

public class JavaModel2JavaTextUtils
extends JavaSwitch<Object> {
    private IndentingStringBuilder indentingStringBuilder = null;
    private Map<String, String> file2text = new HashMap<String, String>();
    public static Map<String, Integer> eClassName2coverage = null;

    protected void append(boolean value) {
        this.append(Boolean.toString(value));
    }

    protected void append(String string) {
        this.indentingStringBuilder.append(string);
    }

    protected void appendBodyDeclarations(List<BodyDeclaration> bodyDeclarations) {
        if (!bodyDeclarations.isEmpty()) {
            boolean gotOne = false;
            for (BodyDeclaration jBodyDeclaration : bodyDeclarations) {
                if (jBodyDeclaration.isProxy()) continue;
                if (!gotOne) {
                    gotOne = true;
                    this.pushIndentation();
                    this.appendSoftNewLine();
                } else {
                    this.append("\n");
                }
                this.appendNode((EObject)jBodyDeclaration);
                this.appendSoftNewLine();
            }
            if (gotOne) {
                this.popIndentation();
            }
        }
    }

    protected void appendBrackets(int d) {
        if (d == 1) {
            this.append("[]");
        }
        if (d > 1) {
            int i = 1;
            while (i <= d) {
                this.append("[]");
                ++i;
            }
        }
    }

    protected void appendEndLine() {
        this.indentingStringBuilder.appendEndLine();
    }

    protected void appendJavaKeyword(AbstractTypeDeclaration jAbstractTypeDeclaration) {
        if (jAbstractTypeDeclaration instanceof ClassDeclaration) {
            this.append("class");
        } else if (jAbstractTypeDeclaration instanceof InterfaceDeclaration) {
            this.append("interface");
        } else if (jAbstractTypeDeclaration instanceof EnumDeclaration) {
            this.append("enum");
        } else if (jAbstractTypeDeclaration instanceof AnnotationTypeDeclaration) {
            this.append("@interface");
        } else {
            this.append("Missing javaKeyword " + jAbstractTypeDeclaration.eClass().getName() + "\n");
        }
    }

    protected void appendMethodHeader(AbstractMethodInvocation jAbstractMethodInvocation) {
        this.appendWrappedNodes(null, (List<? extends ASTNode>)jAbstractMethodInvocation.getTypeArguments(), ", ", null);
        this.append(jAbstractMethodInvocation.getMethod().getName());
        this.appendWrappedNodes("(", (List<? extends ASTNode>)jAbstractMethodInvocation.getArguments(), ", ", ")");
    }

    protected void appendModifier(Modifier modifier) {
        if (modifier != null) {
            this.appendNode((EObject)modifier);
        }
    }

    protected boolean appendNode(EObject jNode) {
        if (jNode == null) {
            return false;
        }
        EClass eClass = jNode.eClass();
        int classifierID = eClass.getClassifierID();
        this.doSwitch(classifierID, jNode);
        if (eClassName2coverage != null) {
            String eClassName = eClass.getName();
            eClassName2coverage.put(eClassName, eClassName2coverage.getOrDefault(eClassName, 0) + 1);
        }
        return true;
    }

    protected void appendNodes(List<? extends ASTNode> jNodes) {
        for (ASTNode aSTNode : jNodes) {
            this.appendNode((EObject)aSTNode);
        }
    }

    protected void appendOptionalWrappedNodes(String prefix, List<? extends ASTNode> jNodes, String separator, String suffix) {
        if (jNodes.size() > 0) {
            this.appendWrappedNodes(prefix, jNodes, separator, suffix);
        }
    }

    protected void appendQualifiedName(NamedElement jNamedElement) {
        Package jPackage;
        if (jNamedElement instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration jAbstractTypeDeclaration = (AbstractTypeDeclaration)jNamedElement;
            if (jAbstractTypeDeclaration.getPackage() != null) {
                this.appendQualifiedName((NamedElement)jAbstractTypeDeclaration.getPackage());
                this.append(".");
            }
            if (jAbstractTypeDeclaration.getAbstractTypeDeclaration() != null) {
                this.appendQualifiedName((NamedElement)jAbstractTypeDeclaration.getAbstractTypeDeclaration());
                this.append(".");
            }
        } else if (jNamedElement instanceof BodyDeclaration) {
            BodyDeclaration jBodyDeclaration = (BodyDeclaration)jNamedElement;
            if (jBodyDeclaration.getAbstractTypeDeclaration() != null) {
                this.appendQualifiedName((NamedElement)jBodyDeclaration.getAbstractTypeDeclaration());
                this.append(".");
            }
        } else if (jNamedElement instanceof VariableDeclarationFragment) {
            FieldDeclaration jFieldDeclaration;
            VariableDeclarationFragment jVariableDeclarationFragment = (VariableDeclarationFragment)jNamedElement;
            AbstractVariablesContainer jVariablesContainer = jVariableDeclarationFragment.getVariablesContainer();
            if (jVariablesContainer instanceof FieldDeclaration && (jFieldDeclaration = (FieldDeclaration)jVariablesContainer).getAbstractTypeDeclaration() != null) {
                this.appendQualifiedName((NamedElement)jFieldDeclaration.getAbstractTypeDeclaration());
                this.append(".");
            }
        } else if (jNamedElement instanceof CompilationUnit) {
            CompilationUnit jCompilationUnit = (CompilationUnit)jNamedElement;
            if (jCompilationUnit.getPackage() != null) {
                this.appendQualifiedName((NamedElement)jCompilationUnit.getPackage());
                this.append(".");
            }
        } else if (jNamedElement instanceof Package && (jPackage = (Package)jNamedElement).getPackage() != null) {
            this.appendQualifiedName((NamedElement)jPackage.getPackage());
            this.append(".");
        }
        this.append(jNamedElement.getName());
    }

    protected void appendSoftNewLine() {
        this.indentingStringBuilder.appendSoftNewLine();
    }

    protected void appendSoftSpace() {
        this.indentingStringBuilder.appendSoftSpace();
    }

    protected void appendTypeHeader(TypeDeclaration jTypeDeclaration) {
        this.appendNodes((List<? extends ASTNode>)jTypeDeclaration.getAnnotations());
        this.appendNode((EObject)jTypeDeclaration.getModifier());
        this.appendJavaKeyword((AbstractTypeDeclaration)jTypeDeclaration);
        this.append(" ");
        this.append(jTypeDeclaration.getName());
        this.appendOptionalWrappedNodes("<", (List<? extends ASTNode>)jTypeDeclaration.getTypeParameters(), ", ", ">");
    }

    protected boolean appendWrappedNode(String prefix, ASTNode jNode, String suffix) {
        if (jNode == null) {
            return false;
        }
        this.append(prefix);
        this.appendNode((EObject)jNode);
        this.append(suffix);
        return true;
    }

    protected void appendWrappedNodes(String prefix, List<? extends ASTNode> jNodes, String separator, String suffix) {
        this.append(prefix);
        String nextSeparator = null;
        for (ASTNode aSTNode : jNodes) {
            this.append(nextSeparator);
            this.appendNode((EObject)aSTNode);
            nextSeparator = separator;
        }
        this.append(suffix);
    }

    protected void doChildren(EObject jObject, boolean withIndentation) {
        if (withIndentation) {
            this.pushIndentation();
        }
        for (EObject eChild : jObject.eContents()) {
            this.appendNode((EObject)((ASTNode)eChild));
        }
        if (withIndentation) {
            this.popIndentation();
        }
    }

    public Map<String, String> generate(Iterable<Resource> resources) {
        for (Resource resource : resources) {
            for (EObject eObject : resource.getContents()) {
                this.appendNode(eObject);
            }
        }
        return this.file2text;
    }

    protected String getQualifiedPath(StringBuilder s, NamedElement jNamedElement) {
        CompilationUnit jCompilationUnit;
        if (jNamedElement instanceof Package) {
            Package jPackage = (Package)jNamedElement;
            if (jPackage.getPackage() != null) {
                this.getQualifiedPath(s, (NamedElement)jPackage.getPackage());
                s.append("/");
            }
        } else if (jNamedElement instanceof CompilationUnit && (jCompilationUnit = (CompilationUnit)jNamedElement).getPackage() != null) {
            this.getQualifiedPath(s, (NamedElement)jCompilationUnit.getPackage());
            s.append("/");
        }
        s.append(jNamedElement.getName());
        return s.toString();
    }

    public void popFile(String fileKey) {
        this.indentingStringBuilder.close();
        this.file2text.put(fileKey, this.indentingStringBuilder.toString());
        this.indentingStringBuilder = null;
    }

    protected void popIndentation() {
        this.indentingStringBuilder.popIndentation();
    }

    public void pushFile() {
        assert (this.indentingStringBuilder == null);
        this.indentingStringBuilder = new IndentingStringBuilder();
    }

    protected void pushIndentation() {
        this.indentingStringBuilder.pushIndentation();
    }

    public void wc(ASTNode jNode) {
        for (Comment jComment : jNode.getComments()) {
            if (!jComment.isPrefixOfParent()) continue;
            this.appendNode((EObject)jComment);
        }
    }

    public void wca(ASTNode jNode) {
        for (Comment jComment : jNode.getComments()) {
            if (jComment.isEnclosedByParent() || jComment.isPrefixOfParent()) continue;
            this.appendNode((EObject)jComment);
        }
    }

    public void wci(ASTNode jNode) {
        boolean hasCommentInside = false;
        for (Comment jComment : jNode.getComments()) {
            if (!jComment.isEnclosedByParent()) continue;
            this.appendNode((EObject)jComment);
            hasCommentInside = true;
        }
        if (hasCommentInside) {
            this.append("\n");
        }
    }

    public String toString() {
        return this.indentingStringBuilder.toString();
    }
}

