/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.j2ee.internal.servertarget;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.datamodel.properties.IJ2EEProjectServerTargetDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.util.IModuleConstants;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.ResourceManager;

public class J2EEProjectServerTargetOp extends AbstractDataModelOperation {

    /**
     * @param operationDataModel
     */
    public J2EEProjectServerTargetOp(IDataModel model) {
        super(model);
    }

	@Override
	public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String serverTargetId = model.getStringProperty(IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID);
		IRuntime runtime = ResourceManager.getInstance().getRuntime(serverTargetId);
		IProject project = null;
        String name = model.getStringProperty(IJ2EEProjectServerTargetDataModelProperties.PROJECT_NAME);
        if (name != null && name.length() > 0)
			project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
		if (runtime != null && project != null) {
			try {
				//ServerCore.getProjectProperties(project).setRuntimeTarget(runtime, monitor);
				if (model.getBooleanProperty(IJ2EEProjectServerTargetDataModelProperties.UPDATE_MODULES) 
						&& project.hasNature(IModuleConstants.MODULE_NATURE_ID)) {
					//ServerTargetHelper.setNewServerTargetForEARModules(runtime, project);
					//ServerTargetHelper.setNewServerTargetForEARUtilityJars(runtime, project);
				}
			} catch (CoreException e) {
				J2EEPlugin.logError(e);
			}
		}
		return OK_STATUS;
	}

	@Override
	public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		return null;
	}

	@Override
	public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
		return null;
	}

}
