/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.queue;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.queue.Queue;

public abstract class AbstractArrayQueue<E>
implements Queue<E>,
Cloneable,
Serializable {
    protected transient E[] elements;
    protected transient int head = 0;
    protected transient int tail = 0;
    protected int size = 0;
    private static final long serialVersionUID = 1L;

    protected AbstractArrayQueue(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + initialCapacity);
        }
        this.elements = new Object[initialCapacity];
    }

    @Override
    public void enqueue(E element) {
        this.elements[this.tail] = element;
        if (++this.tail == this.elements.length) {
            this.tail = 0;
        }
        ++this.size;
    }

    @Override
    public E dequeue() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        E element = this.elements[this.head];
        this.elements[this.head] = null;
        if (++this.head == this.elements.length) {
            this.head = 0;
        }
        --this.size;
        return element;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[this.head];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public AbstractArrayQueue<E> clone() {
        try {
            AbstractArrayQueue clone = (AbstractArrayQueue)super.clone();
            Object[] array = (Object[])this.elements.clone();
            clone.elements = array;
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return Arrays.toString(this.copyElements(this.size));
    }

    protected E[] copyElements(int newCapacity) {
        Object[] newElements = new Object[newCapacity];
        if (this.size != 0) {
            int t = this.tail;
            if (t == 0) {
                t = this.elements.length;
            }
            if (this.head < t) {
                System.arraycopy(this.elements, this.head, newElements, 0, this.size);
            } else {
                int fragmentSize = this.elements.length - this.head;
                System.arraycopy(this.elements, this.head, newElements, 0, fragmentSize);
                System.arraycopy(this.elements, 0, newElements, fragmentSize, this.size - fragmentSize);
            }
        }
        return newElements;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        int elementsLength = this.elements.length;
        stream.writeInt(elementsLength);
        if (this.size == 0) {
            return;
        }
        int t = this.tail;
        if (t == 0) {
            t = elementsLength;
        }
        if (this.head < t) {
            int i = this.head;
            while (i < t) {
                stream.writeObject(this.elements[i]);
                ++i;
            }
        } else {
            int i = this.head;
            while (i < elementsLength) {
                stream.writeObject(this.elements[i]);
                ++i;
            }
            i = 0;
            while (i < this.tail) {
                stream.writeObject(this.elements[i]);
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementsLength = stream.readInt();
        Object[] array = new Object[elementsLength];
        int i = 0;
        while (i < this.size) {
            array[i] = stream.readObject();
            ++i;
        }
        this.elements = array;
        this.head = 0;
        this.tail = this.size;
    }
}

