/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.BuildSettingsUtil;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.NotificationManager;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfoContainer;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChainModificationHelper;
import org.eclipse.cdt.managedbuilder.internal.core.ToolListModificationInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public abstract class ResourceInfo
extends BuildObject
implements IResourceInfo {
    private Configuration config;
    private IPath path;
    boolean isDirty;
    boolean needsRebuild;
    private ResourceInfoContainer rcInfo;
    private CResourceData resourceData;

    ResourceInfo(IConfiguration cfg, IManagedConfigElement element, boolean hasBody) {
        this.config = (Configuration)cfg;
        if (hasBody) {
            this.loadFromManifest(element);
        }
    }

    ResourceInfo(IConfiguration cfg, ResourceInfo base, String id) {
        this.config = (Configuration)cfg;
        this.path = ResourceInfo.normalizePath(base.path);
        this.setId(id);
        this.setName(base.getName());
        if (id.equals(base.getId())) {
            this.isDirty = base.isDirty;
            this.needsRebuild = base.needsRebuild;
        } else {
            this.needsRebuild = true;
            this.isDirty = true;
        }
    }

    public boolean isRoot() {
        return this.path.segmentCount() == 0;
    }

    ResourceInfo(IConfiguration cfg, IPath path, String id, String name) {
        this.config = (Configuration)cfg;
        this.path = path = ResourceInfo.normalizePath(path);
        this.setId(id);
        this.setName(name);
    }

    ResourceInfo(IFileInfo base, IPath path, String id, String name) {
        this.config = (Configuration)base.getParent();
        this.setId(id);
        this.setName(name);
        this.path = path = ResourceInfo.normalizePath(path);
        this.needsRebuild = true;
        this.isDirty = true;
    }

    ResourceInfo(FolderInfo base, IPath path, String id, String name) {
        this.config = (Configuration)base.getParent();
        this.setId(id);
        this.setName(name);
        this.path = path = ResourceInfo.normalizePath(path);
        this.needsRebuild = true;
        this.isDirty = true;
    }

    ResourceInfo(IConfiguration cfg, ICStorageElement element, boolean hasBody) {
        this.config = (Configuration)cfg;
        if (hasBody) {
            this.loadFromProject(element);
        }
    }

    private void loadFromManifest(IManagedConfigElement element) {
        this.setId(SafeStringInterner.safeIntern((String)element.getAttribute("id")));
        this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        String tmp = element.getAttribute("resourcePath");
        if (tmp != null) {
            this.path = new Path(tmp);
            if ("resourceConfiguration".equals(element.getName())) {
                this.path = this.path.removeFirstSegments(1);
            }
            this.path = ResourceInfo.normalizePath(this.path);
        } else {
            Status status = new Status(4, "org.eclipse.cdt.managedbuilder.core", "ResourceInfo.loadFromManifest() : resourcePath=NULL", null);
            ManagedBuilderCorePlugin.log((IStatus)status);
        }
        String excludeStr = element.getAttribute("exclude");
        if (excludeStr != null) {
            this.config.setExcluded(this.getPath(), this.isFolderInfo(), Boolean.parseBoolean(excludeStr));
        }
    }

    private void loadFromProject(ICStorageElement element) {
        String excludeStr;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        }
        if (element.getAttribute("resourcePath") != null) {
            String tmp = element.getAttribute("resourcePath");
            if (tmp != null) {
                this.path = new Path(tmp);
                if ("resourceConfiguration".equals(element.getName())) {
                    this.path = this.path.removeFirstSegments(1);
                }
                this.path = ResourceInfo.normalizePath(this.path);
            } else {
                Status status = new Status(4, "org.eclipse.cdt.managedbuilder.core", "ResourceInfo.loadFromProject() : resourcePath=NULL", null);
                ManagedBuilderCorePlugin.log((IStatus)status);
            }
        }
        if (element.getAttribute("exclude") != null && (excludeStr = element.getAttribute("exclude")) != null) {
            this.config.setExcluded(this.getPath(), this.isFolderInfo(), Boolean.parseBoolean(excludeStr));
        }
    }

    @Override
    public IConfiguration getParent() {
        return this.config;
    }

    @Override
    public IPath getPath() {
        return ResourceInfo.normalizePath(this.path);
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean isExcluded() {
        return this.config.isExcluded(this.getPath());
    }

    @Override
    public boolean needsRebuild() {
        return this.needsRebuild;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    @Override
    public void setExclude(boolean excluded) {
        if (this.isExcluded() == excluded) {
            return;
        }
        this.config.setExcluded(this.getPath(), this.isFolderInfo(), excluded);
        this.setDirty(true);
        this.setRebuildState(true);
    }

    @Override
    public boolean canExclude(boolean exclude) {
        return this.config.canExclude(this.getPath(), this.isFolderInfo(), exclude);
    }

    public abstract boolean isFolderInfo();

    @Override
    public void setPath(IPath p) {
        p = ResourceInfo.normalizePath(p);
        if (this.path == null) {
            this.path = p;
        } else if (!p.equals((Object)ResourceInfo.normalizePath(this.path))) {
            ResourceInfoContainer info = this.getRcInfo();
            info.changeCurrentPath(p, true);
            this.path = p;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    private ResourceInfoContainer getRcInfo() {
        if (this.rcInfo == null) {
            this.rcInfo = this.config.getRcInfoContainer(this);
        }
        return this.rcInfo;
    }

    @Override
    public void setRebuildState(boolean rebuild) {
        this.needsRebuild = rebuild;
    }

    void serialize(ICStorageElement element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.path != null) {
            element.setAttribute("resourcePath", this.path.toString());
        }
    }

    void resolveReferences() {
    }

    @Override
    public CResourceData getResourceData() {
        return this.resourceData;
    }

    protected void setResourceData(CResourceData data) {
        this.resourceData = data;
    }

    void removed() {
        this.config = null;
    }

    @Override
    public boolean isValid() {
        return this.config != null;
    }

    private void propagate(IHoldsOptions parent, IOption option, Object oldValue, Object value) {
        if (!(parent instanceof ITool)) {
            return;
        }
        ITool tool = (ITool)parent;
        String sup = option.getId();
        IOption op = option;
        while (op.getSuperClass() != null) {
            op = op.getSuperClass();
            sup = op.getId();
        }
        IResourceInfo[] iResourceInfoArray = this.getChildResourceInfos();
        int n = iResourceInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceInfo ri = iResourceInfoArray[n2];
            ITool[] iToolArray = ri.getTools();
            int n3 = iToolArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool t = iToolArray[n4];
                if (t.getDefaultInputExtension() == tool.getDefaultInputExtension() && (op = t.getOptionBySuperClassId(sup)) != null) {
                    try {
                        Object[] s;
                        if (value instanceof Boolean) {
                            boolean b = (Boolean)oldValue;
                            if (b != op.getBooleanValue() || b == (Boolean)value) break;
                            ri.setOption((IHoldsOptions)t, op, (Boolean)value);
                            break;
                        }
                        if (value instanceof String) {
                            String s2 = (String)oldValue;
                            if (!s2.equals(op.getStringValue()) || s2.equals(value)) break;
                            ri.setOption((IHoldsOptions)t, op, (String)value);
                            break;
                        }
                        if (value instanceof String[]) {
                            Object[] s3 = (String[])oldValue;
                            if (!Arrays.equals(s3, op.getStringListValue()) || Arrays.equals(s3, (String[])value)) break;
                            ri.setOption((IHoldsOptions)t, op, (String[])value);
                            break;
                        }
                        if (!(value instanceof OptionStringValue[]) || !Arrays.equals(s = (OptionStringValue[])oldValue, op.getBasicStringListValueElements()) || Arrays.equals(s, (OptionStringValue[])value)) break;
                        ri.setOption((IHoldsOptions)t, op, (OptionStringValue[])value);
                        break;
                    }
                    catch (BuildException buildException) {
                        // empty catch block
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public IOption setOption(IHoldsOptions parent, IOption option, boolean value) throws BuildException {
        IOption retOpt = option;
        boolean oldVal = option.getBooleanValue();
        if (oldVal != value) {
            retOpt = parent.getOptionToSet(option, false);
            retOpt.setValue(value);
            this.propagate(parent, option, oldVal ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
            NotificationManager.getInstance().optionChanged(this, parent, option, oldVal);
        }
        return retOpt;
    }

    @Override
    public IOption setOption(IHoldsOptions parent, IOption option, String value) throws BuildException {
        IOption retOpt = option;
        String oldValue = option.getStringValue();
        if (oldValue != null && !oldValue.equals(value)) {
            retOpt = parent.getOptionToSet(option, false);
            retOpt.setValue(value);
            this.propagate(parent, option, oldValue, value);
            NotificationManager.getInstance().optionChanged(this, parent, option, oldValue);
        }
        return retOpt;
    }

    @Override
    public IOption setOption(IHoldsOptions parent, IOption option, String[] value) throws BuildException {
        IOption retOpt = option;
        Object[] oldValue = switch (option.getBasicValueType()) {
            case 3 -> option.getBasicStringListValue();
            default -> new String[]{};
        };
        if (!Arrays.equals(value, oldValue)) {
            retOpt = parent.getOptionToSet(option, false);
            retOpt.setValue(value);
            this.propagate(parent, option, oldValue, value);
            NotificationManager.getInstance().optionChanged(this, parent, option, oldValue);
        }
        return retOpt;
    }

    @Override
    public IOption setOption(IHoldsOptions parent, IOption option, OptionStringValue[] value) throws BuildException {
        IOption retOpt = option;
        Object[] oldValue = switch (option.getBasicValueType()) {
            case 3 -> ((Option)option).getBasicStringListValueElements();
            default -> new OptionStringValue[]{};
        };
        if (!Arrays.equals(value, oldValue)) {
            retOpt = parent.getOptionToSet(option, false);
            ((Option)retOpt).setValue(value);
            this.propagate(parent, option, oldValue, value);
            NotificationManager.getInstance().optionChanged(this, parent, option, oldValue);
        }
        return retOpt;
    }

    public void propertiesChanged() {
        ITool[] tools;
        if (this.isExtensionElement()) {
            return;
        }
        ITool[] iToolArray = tools = this.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            ((Tool)tool).propertiesChanged();
            ++n2;
        }
    }

    @Override
    public abstract boolean isExtensionElement();

    public abstract Set<String> contributeErrorParsers(Set<String> var1);

    protected Set<String> contributeErrorParsers(ITool[] tools, Set<String> set) {
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            set = ((Tool)tool).contributeErrorParsers(set);
            ++n2;
        }
        return set;
    }

    public abstract void resetErrorParsers();

    protected void resetErrorParsers(ITool[] tools) {
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            ((Tool)tool).resetErrorParsers();
            ++n2;
        }
    }

    abstract void removeErrorParsers(Set<String> var1);

    protected void removeErrorParsers(ITool[] tools, Set<String> set) {
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            ((Tool)tool).removeErrorParsers(set);
            ++n2;
        }
    }

    public ITool getToolById(String id) {
        ITool[] tools;
        ITool[] iToolArray = tools = this.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (id.equals(tool.getId())) {
                return tool;
            }
            ++n2;
        }
        return null;
    }

    public static IPath normalizePath(IPath path) {
        return path.makeRelative();
    }

    public ResourceInfo getParentResourceInfo() {
        if (this.isRoot()) {
            return null;
        }
        IPath path = this.getPath();
        path = path.removeLastSegments(1);
        return (ResourceInfo)this.getParent().getResourceInfo(path, false);
    }

    public IFolderInfo getParentFolderInfo() {
        ResourceInfo parentRc = this.getParentResourceInfo();
        while (parentRc != null && !parentRc.isFolderInfo()) {
            parentRc = parentRc.getParentResourceInfo();
        }
        return (IFolderInfo)((Object)parentRc);
    }

    abstract void resolveProjectReferences(boolean var1);

    public abstract boolean hasCustomSettings();

    public ToolListModificationInfo getToolListModificationInfo(ITool[] tools) {
        ITool[] curTools = this.getTools();
        return ToolChainModificationHelper.getModificationInfo(this, curTools, tools);
    }

    static ITool[][] getRealPairs(ITool[] tools) {
        ITool[][] pairs = new ITool[tools.length][];
        int i = 0;
        while (i < tools.length) {
            ITool[] pair = new ITool[2];
            pair[0] = ManagedBuildManager.getRealTool(tools[i]);
            if (pair[0] == null) {
                pair[0] = tools[i];
            }
            pair[1] = tools[i];
            pairs[i] = pair;
            ++i;
        }
        return pairs;
    }

    abstract void applyToolsInternal(ITool[] var1, ToolListModificationInfo var2);

    void doApply(ToolListModificationInfo info) {
        ITool[] resulting = info.getResultingTools();
        ITool[] removed = info.getRemovedTools();
        BuildSettingsUtil.disconnectDepentents(this.getParent(), removed);
        this.applyToolsInternal(resulting, info);
        this.performPostModificationAdjustments(info);
    }

    void performPostModificationAdjustments(ToolListModificationInfo info) {
        this.propertiesChanged();
    }

    public IResourceInfo[] getDirectChildResourceInfos() {
        ResourceInfoContainer cr = this.getRcInfo();
        return cr.getDirectChildResourceInfos();
    }

    public IResourceInfo[] getChildResourceInfos() {
        ResourceInfoContainer cr = this.getRcInfo();
        return cr.getResourceInfos();
    }

    public List<IResourceInfo> getChildResourceInfoList(boolean includeCurrent) {
        return this.getRcInfo().getRcInfoList(12, includeCurrent);
    }
}

