/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IImportContainer;
import org.eclipse.dltk.core.IImportDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathUtils;
import org.eclipse.php.internal.ui.util.CodeInjector;
import org.eclipse.php.internal.ui.wizards.PHPFileCreationWizard;
import org.eclipse.php.internal.ui.wizards.types.Messages;
import org.eclipse.php.internal.ui.wizards.types.NewPHPTypePage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.text.XMLStructuredDocumentRegion;

public abstract class NewPHPTypeWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection fSelection;
    protected ArrayList<String> requiredNamesExcludeList = new ArrayList();
    protected ArrayList<String> requiredToAdd = new ArrayList();
    protected NewPHPTypePage page;
    protected ISourceModule existingPHPFile = null;
    protected String compilationResult;
    protected IScriptProject currentProject;

    public NewPHPTypeWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = selection;
    }

    protected boolean createNewFile(String containerName, String fileName, String contents) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            this.createNewFolder((IPath)new Path(containerName));
        }
        IFile file = root.getFile(new Path(containerName).append(fileName));
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    new PHPFileCreationWizard.FileCreator(){

                        @Override
                        protected void normalizeFile(IFile file) {
                            super.normalizeFile(file);
                            IContentFormatter formatter = PHPUiPlugin.getDefault().getActiveFormatter();
                            try {
                                IStructuredModel structuredModel = null;
                                structuredModel = StructuredModelManager.getModelManager().getModelForEdit(file);
                                if (structuredModel == null) {
                                    return;
                                }
                                try {
                                    IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
                                    Region region = new Region(0, structuredDocument.getLength());
                                    formatter.format((IDocument)structuredDocument, (IRegion)region);
                                    structuredModel.save();
                                }
                                finally {
                                    if (structuredModel != null) {
                                        structuredModel.releaseFromEdit();
                                    }
                                }
                                NewPHPTypeWizard.this.currentProject.getProject().build(10, null);
                            }
                            catch (IOException | CoreException e) {
                                Logger.logException(e);
                            }
                        }
                    }.createFile(this, file, monitor, contents);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
            return true;
        }
        catch (InterruptedException e) {
            Logger.logException(e);
            return false;
        }
        catch (InvocationTargetException e) {
            Logger.logException(e);
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
    }

    protected String getProjectName(String sourcePath) {
        int idx;
        while ((idx = Math.max(sourcePath.lastIndexOf(92), sourcePath.lastIndexOf(47))) > 1) {
            sourcePath = sourcePath.substring(0, idx);
        }
        return sourcePath;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public void showWarningsDialog(String[] warnings) {
        StringBuilder buffer = new StringBuilder();
        String elementType = "";
        switch (this.page.fTypeKind) {
            case 1: {
                elementType = Messages.NewPHPTypeWizard_class;
                break;
            }
            case 2: {
                elementType = Messages.NewPHPTypeWizard_interface;
                break;
            }
            case 3: {
                elementType = Messages.NewPHPTypeWizard_trait;
            }
        }
        buffer.append(elementType + Messages.NewPHPTypeWizard_creationWasSuccessful);
        String[] stringArray = warnings;
        int n = warnings.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            buffer.append(element + "\n");
            ++n2;
        }
        MessageDialog dialog = new MessageDialog(this.getShell(), "PHP Code Generator Warnings", null, buffer.toString(), 2, new String[]{"OK"}, 0);
        dialog.open();
    }

    protected int findPHPBlockOffset() {
        ITextRegion[] subRegions;
        int injectOffset = -1;
        IPHPScriptRegion scriptRegion = null;
        ITextRegion[] iTextRegionArray = subRegions = this.getStructuredDocumentsRegions();
        int n = subRegions.length;
        int n2 = 0;
        while (n2 < n) {
            ITextRegion currentRegion = iTextRegionArray[n2];
            if (currentRegion != null && currentRegion instanceof IPHPScriptRegion && (scriptRegion = (IPHPScriptRegion)currentRegion).getType().equals("PHP_CONTENT")) {
                injectOffset = scriptRegion.getEnd();
                return injectOffset;
            }
            ++n2;
        }
        return injectOffset;
    }

    protected ITextRegion[] getStructuredDocumentsRegions() {
        IResource resource = this.existingPHPFile.getResource();
        IStructuredModel existingModelForRead = null;
        try {
            IStructuredDocumentRegion[] subRegions;
            IFile file = (IFile)resource;
            existingModelForRead = ModelManagerImpl.getInstance().getExistingModelForRead(file);
            if (existingModelForRead == null) {
                existingModelForRead = ModelManagerImpl.getInstance().createUnManagedStructuredModelFor(file);
            }
            IStructuredDocument structuredDocument = existingModelForRead.getStructuredDocument();
            IStructuredDocumentRegion[] iStructuredDocumentRegionArray = subRegions = structuredDocument.getStructuredDocumentRegions();
            int n = subRegions.length;
            int n2 = 0;
            while (n2 < n) {
                IStructuredDocumentRegion currentRegion = iStructuredDocumentRegionArray[n2];
                if (currentRegion instanceof XMLStructuredDocumentRegion) {
                    ITextRegion[] iTextRegionArray = currentRegion.getRegions().toArray();
                    return iTextRegionArray;
                }
                try {
                    ++n2;
                }
                catch (IOException | CoreException e) {
                    PHPUiPlugin.log(e);
                    ITextRegion[] iTextRegionArray = new ITextRegion[]{};
                    return iTextRegionArray;
                }
            }
        }
        finally {
            if (existingModelForRead != null) {
                existingModelForRead.releaseFromRead();
            }
        }
        return new ITextRegion[0];
    }

    protected boolean createNewPHPFile(String containerName, String fileName, String contents) {
        if (!this.createNewFile(containerName, fileName, contents)) {
            return false;
        }
        Path p = new Path(containerName + File.separatorChar + fileName);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)p);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForEdit(file);
        }
        catch (Exception e) {
            Logger.logException(e);
            return false;
        }
        IStructuredDocument document = model.getStructuredDocument();
        model.releaseFromEdit();
        CodeInjector injector = new CodeInjector();
        injector.formatDocument(document, 0, document.getLength());
        try {
            model.save();
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return true;
    }

    protected void injectCodeIntoExistingFile() {
        if (this.page.isInFirstPHPBlock()) {
            int injectOffset = this.findPHPBlockOffset();
            int phpBlockEndOffset = -1;
            if (injectOffset == -1) {
                injectOffset = 0;
                CodeInjector phpBlockInjector = new CodeInjector(this.existingPHPFile, injectOffset);
                phpBlockInjector.inject("<?php", false, true);
                injectOffset = this.findPHPBlockOffset();
                if (injectOffset != -1) {
                    phpBlockEndOffset = injectOffset;
                }
            } else {
                phpBlockEndOffset = injectOffset;
            }
            CodeInjector generatedCodeInjector = new CodeInjector(this.existingPHPFile, phpBlockEndOffset);
            generatedCodeInjector.setOffset(phpBlockEndOffset);
            generatedCodeInjector.inject("\n" + this.compilationResult, true, true);
        } else {
            CodeInjector injector = new CodeInjector(this.existingPHPFile);
            injector.inject("\n" + this.compilationResult, true, true);
        }
    }

    protected void extractReqruiresInclude(IType superClassData) {
        String superclassFile;
        if (LanguageModelInitializer.isLanguageModelElement((IModelElement)superClassData)) {
            return;
        }
        if (this.page.isInExistingPHPFile() && this.existingPHPFile.equals(superClassData.getSourceModule())) {
            return;
        }
        IPath superClassRelativeFilePath = IncludePathUtils.getRelativeLocationFromIncludePath(this.currentProject, (IModelElement)superClassData);
        if (!superClassRelativeFilePath.isEmpty() && !this.requiredNamesExcludeList.contains(superclassFile = superClassRelativeFilePath.toString())) {
            this.requiredNamesExcludeList.add(superclassFile);
            this.requiredToAdd.add(superclassFile);
        }
    }

    protected void addImport(List<String> imports, IType type, List<String> existingImports) {
        IModelElement parent = type.getParent();
        if (parent instanceof IType) {
            IType parentType = (IType)parent;
            try {
                if (PHPFlags.isNamespace((int)parentType.getFlags())) {
                    if (parent.getElementName().equals(this.page.getRealNamespace())) {
                        return;
                    }
                    String use = parent.getElementName() + "\\" + type.getElementName();
                    if (!existingImports.contains(use)) {
                        imports.add(use);
                    }
                }
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    protected List<String> getExistingImports() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.existingPHPFile != null && this.existingPHPFile.exists()) {
            try {
                IModelElement[] rootElements;
                IModelElement[] iModelElementArray = rootElements = this.existingPHPFile.getChildren();
                int n = rootElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement element = iModelElementArray[n2];
                    if (!this.addImport(result, element) && element instanceof IType) {
                        IModelElement[] elementChildren;
                        IModelElement[] iModelElementArray2 = elementChildren = ((IType)element).getChildren();
                        int n3 = elementChildren.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement child = iModelElementArray2[n4];
                            this.addImport(result, child);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
        return result;
    }

    protected String[] getRequires() {
        if (this.page.isCheckboxCreationChecked("require_once")) {
            String[] requires = new String[this.requiredToAdd.size()];
            this.requiredToAdd.toArray(requires);
            return requires;
        }
        return new String[0];
    }

    private boolean addImport(List<String> result, IModelElement element) throws ModelException {
        if (element instanceof IImportContainer) {
            IImportDeclaration[] imports;
            IImportContainer importContainer = (IImportContainer)element;
            IImportDeclaration[] iImportDeclarationArray = imports = importContainer.getImports();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IImportDeclaration iImportDeclaration = iImportDeclarationArray[n2];
                result.add(iImportDeclaration.getElementName());
                ++n2;
            }
            return true;
        }
        return false;
    }

    public IFolder createNewFolder(IPath newFolderPath) {
        IFolder newFolder = null;
        IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        boolean createVirtualFolder = false;
        IRunnableWithProgress op = monitor -> {
            CreateFolderOperation op1 = new CreateFolderOperation(newFolderHandle, null, false, null, IDEWorkbenchMessages.WizardNewFolderCreationPage_title);
            try {
                op1.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
            }
            catch (ExecutionException e) {
                this.getContainer().getShell().getDisplay().syncExec(() -> {
                    if (e.getCause() instanceof CoreException) {
                        ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                    } else {
                        IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFolder()", (Throwable)e.getCause());
                        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)e.getCause().getMessage()));
                    }
                });
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFolder()", (Throwable)e.getTargetException());
            MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)e.getTargetException().getMessage()), (int)0x10000000);
            return null;
        }
        return newFolder;
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFolder(folderPath);
    }

    class PostFinishValidator {
        private ArrayList<String> warnings = new ArrayList();

        PostFinishValidator() {
        }

        public void addWarning(String warning) {
            this.warnings.add(warning);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        public String[] getWarnings() {
            String[] result = new String[this.warnings.size()];
            this.warnings.toArray(result);
            return result;
        }

        public void packAndValidate() {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            NewPHPTypeWizard.this.currentProject = DLTKCore.create((IProject)workspaceRoot.getProject(NewPHPTypeWizard.this.getProjectName(NewPHPTypeWizard.this.page.getSourceText())));
        }
    }
}

