/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.server.core.builtin.IPHPWebModule;
import org.eclipse.php.internal.server.core.builtin.Messages;
import org.eclipse.php.internal.server.core.builtin.PHPServer;
import org.eclipse.php.internal.server.core.builtin.PHPServerConfiguration;
import org.eclipse.php.internal.server.core.builtin.PHPServerHelper;
import org.eclipse.php.internal.server.core.builtin.ProgressUtil;
import org.eclipse.php.internal.server.core.builtin.Trace;
import org.eclipse.php.internal.server.core.builtin.WebModule;
import org.eclipse.php.internal.server.core.builtin.xml.Factory;
import org.eclipse.php.internal.server.core.builtin.xml.PathMapping;
import org.eclipse.php.internal.server.core.builtin.xml.Port;
import org.eclipse.php.internal.server.core.builtin.xml.Server;
import org.eclipse.php.internal.server.core.builtin.xml.ServerInstance;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerPort;

public class DefaultPHPServerConfiguration
extends PHPServerConfiguration {
    private static final String DEFAULT_SERVER_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Server>\n\t<Port name=\"HTTP/1.1\" protocol=\"HTTP\">%PORT%</Port>\n</Server>";
    private static final String PORT_VAR = "%PORT%";
    protected String fPhpIniFile;
    protected Server server;
    protected ServerInstance serverInstance;
    protected Factory serverFactory;
    protected boolean isServerDirty;

    public DefaultPHPServerConfiguration(IFolder path) {
        super(path);
    }

    @Override
    public List<ServerPort> getServerPorts() {
        ArrayList<ServerPort> ports = new ArrayList<ServerPort>();
        try {
            int size = this.server.getPortCount();
            int i = 0;
            while (i < size) {
                Port port = this.server.getPort(i);
                String name = port.getName();
                String protocol = port.getProtocol();
                int portValue = port.getPort();
                ports.add(new ServerPort(Integer.toString(i), name, portValue, protocol));
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting server ports", e);
        }
        return ports;
    }

    @Override
    public void modifyServerPort(String id, int port) {
        int connNum = Integer.parseInt(id);
        Port p = this.serverInstance.getPort(connNum);
        if (p != null) {
            p.setPort(port);
            this.isServerDirty = true;
            this.firePropertyChangeEvent("modifyPort", id, port);
        }
    }

    @Override
    public IStatus localizeConfiguration(IPath baseDir, IPath deployDir, PHPServer server, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public ServerPort getMainPort() {
        for (ServerPort port : this.getServerPorts()) {
            if (!port.getProtocol().toLowerCase().equals("http") || port.getId().indexOf(47) >= 0) continue;
            return port;
        }
        return null;
    }

    @Override
    public void save(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.savingTask, 1200);
            byte[] data = this.serverFactory.getContents();
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            IFile file = folder.getFile("server.xml");
            if (file.exists()) {
                if (this.isServerDirty) {
                    file.setContents((InputStream)in, true, true, ProgressUtil.getSubMonitorFor(monitor, 200));
                } else {
                    monitor.worked(200);
                }
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            this.isServerDirty = false;
            if (this.fPhpIniFile == null) {
                this.fPhpIniFile = "";
            }
            in = new ByteArrayInputStream(this.fPhpIniFile.getBytes());
            file = folder.getFile("php.ini");
            if (file.exists()) {
                monitor.worked(200);
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not save PHP 7.0 Built-in Server configuration to " + folder.toString(), e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    @Override
    public void load(IPath path, PHPexeItem phpExeItem, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.loadingTask, 7);
            this.serverFactory = new Factory();
            this.serverFactory.setPackageName("org.eclipse.php.internal.server.core.builtin.xml");
            this.server = (Server)this.serverFactory.loadDocument(DEFAULT_SERVER_XML.replaceAll(PORT_VAR, String.valueOf(ThreadLocalRandom.current().nextInt(8000, 9000))));
            this.serverInstance = new ServerInstance(this.server);
            monitor.worked(1);
            File file = phpExeItem.getINILocation();
            this.fPhpIniFile = file != null && file.exists() ? PHPServerHelper.getFileContents(new FileInputStream(file)) : null;
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Could not load PHP ini from " + path.toOSString() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)path.toOSString()), (Throwable)e));
        }
    }

    @Override
    public void load(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.loadingTask, 1200);
            IFile file = folder.getFile("server.xml");
            InputStream in = file.getContents();
            this.serverFactory = new Factory();
            this.serverFactory.setPackageName("org.eclipse.php.internal.server.core.builtin.xml");
            this.server = (Server)this.serverFactory.loadDocument(in);
            this.serverInstance = new ServerInstance(this.server);
            monitor.worked(200);
            file = folder.getFile("php.ini");
            if (file.exists()) {
                in = file.getContents();
                this.fPhpIniFile = PHPServerHelper.getFileContents(in);
            } else {
                this.fPhpIniFile = null;
            }
            monitor.worked(200);
            if (monitor.isCanceled()) {
                throw new Exception("Cancelled");
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Could not load PHP ini from " + String.valueOf(folder.getFullPath()) + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), (Throwable)e));
        }
    }

    @Override
    public IPath getServerWorkDirectory(IPath basePath) {
        return null;
    }

    @Override
    public IPath getContextWorkDirectory(IPath basePath, IModule module) {
        return null;
    }

    @Override
    public List<WebModule> getWebModules() {
        return null;
    }

    @Override
    public void addWebModule(int index, IPHPWebModule module) {
    }

    @Override
    public void removeWebModule(int index) {
    }

    @Override
    public PathMapper.Mapping[] getPathMappings(String moduleName) {
        PathMapping[] pathMappings = this.serverInstance.getPathMapping();
        ArrayList<PathMapper.Mapping> list = new ArrayList<PathMapper.Mapping>();
        PathMapping[] pathMappingArray = pathMappings;
        int n = pathMappings.length;
        int n2 = 0;
        while (n2 < n) {
            PathMapping pathMapping = pathMappingArray[n2];
            if (moduleName.equals(pathMapping.getModule())) {
                VirtualPath local = new VirtualPath(pathMapping.getLocalPath());
                VirtualPath remote = new VirtualPath(pathMapping.getRemotePath());
                PathMapper.Mapping mapping = new PathMapper.Mapping(local, remote, PathEntry.Type.WORKSPACE, PathMapper.Mapping.MappingSource.ENVIRONMENT);
                list.add(mapping);
            }
            ++n2;
        }
        return list.toArray(new PathMapper.Mapping[list.size()]);
    }

    @Override
    public void setPathMapping(String moduleName, PathMapper.Mapping[] mappings) {
        this.isServerDirty = true;
        PathMapping[] pathMappings = this.serverInstance.getPathMapping();
        int i = 0;
        while (i < pathMappings.length) {
            PathMapping mapping = pathMappings[i];
            if (mapping.getModule().equals(moduleName)) {
                this.serverInstance.removePathMapping(i);
            }
            ++i;
        }
        i = 0;
        while (i < mappings.length) {
            PathMapping pathMapping = this.serverInstance.createPathMapping();
            pathMapping.setLocalPath(mappings[i].localPath.toString());
            pathMapping.setRemotePath(mappings[i].remotePath.toString());
            pathMapping.setModule(moduleName);
            ++i;
        }
    }

    @Override
    public PathMapper.Mapping[] getPathMappings() {
        PathMapping[] pathMappings = this.serverInstance.getPathMapping();
        ArrayList<PathMapper.Mapping> list = new ArrayList<PathMapper.Mapping>();
        PathMapping[] pathMappingArray = pathMappings;
        int n = pathMappings.length;
        int n2 = 0;
        while (n2 < n) {
            PathMapping pathMapping = pathMappingArray[n2];
            VirtualPath local = new VirtualPath(pathMapping.getLocalPath());
            VirtualPath remote = new VirtualPath(pathMapping.getRemotePath());
            PathMapper.Mapping mapping = new PathMapper.Mapping(local, remote, PathEntry.Type.WORKSPACE, PathMapper.Mapping.MappingSource.ENVIRONMENT);
            list.add(mapping);
            ++n2;
        }
        return list.toArray(new PathMapper.Mapping[list.size()]);
    }
}

