/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.ejb.SessionType;
import org.eclipse.jst.j2ee.ejb.TransactionType;
import org.eclipse.jst.j2ee.ejb.annotation.internal.messages.IEJBAnnotationConstants;
import org.eclipse.jst.j2ee.ejb.annotation.ui.internal.wizards.IBeanWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddSessionBeanWizardPage
extends DataModelWizardPage
implements IBeanWizardPage {
    private Text ejbNameText;
    private Text jndiNameText;
    private Text displayNameText;
    private Combo statelessButton;
    private Combo transactionButton;

    public AddSessionBeanWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(IEJBAnnotationConstants.ADD_EJB_WIZARD_PAGE_DESC);
        this.setTitle(IEJBAnnotationConstants.ADD_EJB_WIZARD_PAGE_TITLE);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IEjbCommonDataModel.EJB_NAME", "IEjbCommonDataModel.JNDI_NAME", "IEjbCommonDataModel.DISPLAY_NAME", "IEjbCommonDataModel.DESCRIPTION"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        Composite fields = new Composite(composite, 0);
        fields.setLayout((Layout)new GridLayout(2, false));
        fields.setLayoutData((Object)new GridData(1808));
        this.createNameDescription(fields);
        this.createStatelessGroup(fields);
        this.createTransactionGroup(fields);
        this.displayNameText.setFocus();
        IStatus projectStatus = this.validateProjectName();
        if (!projectStatus.isOK()) {
            this.setErrorMessage(projectStatus.getMessage());
            composite.setEnabled(false);
        }
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected IStatus validateProjectName() {
        if (this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME") == null || this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME").trim().length() == 0) {
            return WTPCommonPlugin.createErrorStatus((String)IEJBAnnotationConstants.NO_EJB_PROJECTS);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected void createNameDescription(Composite composite) {
        Label ejbNameLabel = new Label(composite, 16384);
        ejbNameLabel.setText(IEJBAnnotationConstants.EJB_NAME_LABEL);
        ejbNameLabel.setLayoutData((Object)new GridData(32));
        this.ejbNameText = new Text(composite, 2052);
        this.ejbNameText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.ejbNameText, "IEjbCommonDataModel.EJB_NAME", null);
        Label jndiNameLabel = new Label(composite, 16384);
        jndiNameLabel.setText(IEJBAnnotationConstants.JNDI_NAME_LABEL);
        jndiNameLabel.setLayoutData((Object)new GridData(32));
        this.jndiNameText = new Text(composite, 2052);
        this.jndiNameText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.jndiNameText, "IEjbCommonDataModel.JNDI_NAME", null);
        Label displayNameLabel = new Label(composite, 16384);
        displayNameLabel.setText(IEJBAnnotationConstants.DISPLAY_NAME_LABEL);
        displayNameLabel.setLayoutData((Object)new GridData(32));
        this.displayNameText = new Text(composite, 2052);
        this.displayNameText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.displayNameText, "IEjbCommonDataModel.DISPLAY_NAME", null);
        Label descLabel = new Label(composite, 16384);
        descLabel.setText(IEJBAnnotationConstants.DESCRIPTION_LABEL);
        descLabel.setLayoutData((Object)new GridData(32));
        Text descText = new Text(composite, 2052);
        descText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(descText, "IEjbCommonDataModel.DESCRIPTION", null);
    }

    protected void createStatelessGroup(Composite composite) {
        Label statelessLabel = new Label(composite, 16384);
        statelessLabel.setText(IEJBAnnotationConstants.STATELESS_LABEL);
        statelessLabel.setLayoutData((Object)new GridData(32));
        this.statelessButton = new Combo(composite, 12);
        this.statelessButton.setItems(new String[]{SessionType.STATELESS_LITERAL.getName(), SessionType.STATEFUL_LITERAL.getName()});
        this.statelessButton.setText(SessionType.STATELESS_LITERAL.getName());
        this.statelessButton.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.statelessButton, "SessionBeanDataModel.STATELESS", null);
        this.statelessButton.select(0);
    }

    protected void createTransactionGroup(Composite composite) {
        Label txLabel = new Label(composite, 16384);
        txLabel.setText(IEJBAnnotationConstants.TRANSACTION_LABEL);
        txLabel.setLayoutData((Object)new GridData(32));
        this.transactionButton = new Combo(composite, 12);
        this.transactionButton.setItems(new String[]{TransactionType.CONTAINER_LITERAL.getName(), TransactionType.BEAN_LITERAL.getName()});
        this.transactionButton.setText(TransactionType.CONTAINER_LITERAL.getName());
        this.transactionButton.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.transactionButton, "IEjbCommonDataModel.TRANSACTIONTYPE", null);
        this.transactionButton.select(0);
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    public boolean canFinish() {
        return false;
    }

    public String getDisplayName() {
        return this.displayNameText.getText();
    }

    @Override
    public String getEjbName() {
        return this.model.getStringProperty("IEjbCommonDataModel.EJB_NAME");
    }
}

