/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.merge.java.PrefixHandler;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.common.EMFPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JControlModel
extends PrefixHandler {
    protected static final Class<?>[] NO_PARAMETER_TYPES = new Class[0];
    static Map<String, Class<?>> classNameToClassMap = new HashMap();
    protected FacadeHelper facadeHelper;
    protected List<DictionaryPattern> dictionaryPatterns;
    protected List<PullRule> pullRules;
    protected List<PushRule> pushRules;
    protected List<SweepRule> sweepRules;
    protected List<SortRule> sortRules;
    protected List<MatchRule> matchRules;
    protected Pattern blockPattern;
    protected Pattern noImportPattern;
    protected String redirect;
    protected boolean indentIsSet = false;
    protected String indent;
    protected boolean standardBraceStyleIsSet = false;
    protected boolean standardBraceStyle;

    public static Class<?> classForClassName(String classPrefix, String className) {
        Class<?> result;
        if (classPrefix != null) {
            className = String.valueOf(classPrefix) + className;
        }
        if ((result = classNameToClassMap.get(className)) == null) {
            try {
                result = Class.forName(className);
                classNameToClassMap.put(className, result);
            }
            catch (ClassNotFoundException exception) {
                if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                    CodeGenPlugin.INSTANCE.log(exception);
                }
                classNameToClassMap.put(className, JControlModel.class);
            }
        }
        return result == JControlModel.class ? null : result;
    }

    protected void setFacadeHelper(FacadeHelper facadeHelper) {
        if (this.facadeHelper != null) {
            this.facadeHelper.setControlModel(null);
            if (this.dictionaryPatterns != null) {
                this.dictionaryPatterns.clear();
            }
            if (this.pullRules != null) {
                this.pullRules.clear();
            }
            if (this.pushRules != null) {
                this.pushRules.clear();
            }
            if (this.sweepRules != null) {
                this.sweepRules.clear();
            }
            if (this.sortRules != null) {
                this.sortRules.clear();
            }
            if (this.matchRules != null) {
                this.matchRules.clear();
            }
            this.blockPattern = null;
            this.noImportPattern = null;
            this.redirect = null;
        }
        this.facadeHelper = facadeHelper;
        if (facadeHelper != null) {
            this.setClassPrefix(facadeHelper.getClassPrefix());
            facadeHelper.setControlModel(this);
        }
    }

    public FacadeHelper getFacadeHelper() {
        return this.facadeHelper;
    }

    public boolean convertToStandardBraceStyle() {
        return this.standardBraceStyle;
    }

    public void setConvertToStandardBraceStyle(boolean standardBraceStyle) {
        this.standardBraceStyleIsSet = true;
        this.standardBraceStyle = standardBraceStyle;
    }

    public String getLeadingTabReplacement() {
        return this.indent;
    }

    public void setLeadingTabReplacement(String indent) {
        this.indentIsSet = true;
        this.indent = indent;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public Pattern getBlockPattern() {
        return this.blockPattern;
    }

    public Pattern getNoImportPattern() {
        return this.noImportPattern;
    }

    public List<DictionaryPattern> getDictionaryPatterns() {
        if (this.dictionaryPatterns == null) {
            this.dictionaryPatterns = new ArrayList<DictionaryPattern>();
        }
        return this.dictionaryPatterns;
    }

    public List<PullRule> getPullRules() {
        if (this.pullRules == null) {
            this.pullRules = new ArrayList<PullRule>();
        }
        return this.pullRules;
    }

    public List<PushRule> getPushRules() {
        if (this.pushRules == null) {
            this.pushRules = new ArrayList<PushRule>();
        }
        return this.pushRules;
    }

    public List<SweepRule> getSweepRules() {
        if (this.sweepRules == null) {
            this.sweepRules = new ArrayList<SweepRule>();
        }
        return this.sweepRules;
    }

    public List<SortRule> getSortRules() {
        if (this.sortRules == null) {
            this.sortRules = new ArrayList<SortRule>();
        }
        return this.sortRules;
    }

    public List<MatchRule> getMatchRules() {
        if (this.matchRules == null) {
            this.matchRules = new ArrayList<MatchRule>();
        }
        return this.matchRules;
    }

    public boolean canMerge() {
        FacadeHelper facadeHelper = this.getFacadeHelper();
        return facadeHelper != null && facadeHelper.canMerge();
    }

    public void initialize(FacadeHelper facadeHelper, String uri) {
        this.setFacadeHelper(facadeHelper);
        this.initialize(uri);
    }

    protected void initialize(String uri) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(uri));
            this.initialize(document.getDocumentElement());
        }
        catch (Exception exception) {
            CodeGenPlugin.INSTANCE.log(exception);
        }
    }

    protected void initialize(Element element) {
        if (element.getLocalName().equals("options")) {
            if (!this.standardBraceStyleIsSet && "standard".equals(element.getAttributeNS(null, "braceStyle"))) {
                this.standardBraceStyle = true;
            }
            if (!this.indentIsSet && element.hasAttributeNS(null, "indent")) {
                this.indent = element.getAttributeNS(null, "indent");
            }
            if (element.hasAttributeNS(null, "redirect")) {
                this.redirect = element.getAttributeNS(null, "redirect");
            }
            if (element.hasAttributeNS(null, "block")) {
                this.blockPattern = Pattern.compile(element.getAttributeNS(null, "block"), 40);
            }
            if (element.hasAttributeNS(null, "noImport")) {
                this.noImportPattern = Pattern.compile(element.getAttributeNS(null, "noImport"), 40);
            }
            String classPrefix = this.getClassPrefix();
            Node child = element.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    Element elementChild = (Element)child;
                    if (elementChild.getLocalName().equals("dictionaryPattern")) {
                        this.getDictionaryPatterns().add(this.createDictionaryPattern(classPrefix, elementChild));
                    } else if (elementChild.getLocalName().equals("pull")) {
                        this.getPullRules().add(this.createPullRule(classPrefix, elementChild));
                    } else if (elementChild.getLocalName().equals("push")) {
                        this.getPushRules().add(this.createPushRule(classPrefix, elementChild));
                    } else if (elementChild.getLocalName().equals("sweep")) {
                        this.getSweepRules().add(this.createSweepRule(classPrefix, elementChild));
                    } else if (elementChild.getLocalName().equals("sort")) {
                        this.getSortRules().add(this.createSortRule(classPrefix, elementChild));
                    } else if (elementChild.getLocalName().equals("match")) {
                        this.getMatchRules().add(this.createMatchRule(classPrefix, elementChild));
                    }
                }
                child = child.getNextSibling();
            }
        }
    }

    protected DictionaryPattern createDictionaryPattern(String classPrefix, Element elementChild) {
        return new DictionaryPattern(classPrefix, elementChild);
    }

    protected PullRule createPullRule(String classPrefix, Element elementChild) {
        return new PullRule(classPrefix, elementChild);
    }

    protected PushRule createPushRule(String classPrefix, Element elementChild) {
        return new PushRule(classPrefix, elementChild);
    }

    protected SweepRule createSweepRule(String classPrefix, Element elementChild) {
        return new SweepRule(classPrefix, elementChild);
    }

    protected SortRule createSortRule(String classPrefix, Element elementChild) {
        return new SortRule(classPrefix, elementChild);
    }

    protected MatchRule createMatchRule(String classPrefix, Element elementChild) {
        return new MatchRule(classPrefix, elementChild);
    }

    public static class DictionaryPattern
    extends PrefixHandler {
        protected static Class<?>[] stringParameterType = new Class[]{String.class};
        protected String name;
        protected Feature selectorFeature;
        protected Pattern pattern;

        public DictionaryPattern(String classPrefix) {
            super(classPrefix);
        }

        public DictionaryPattern(String classPrefix, Element element) {
            this(classPrefix);
            this.initialize(element);
        }

        public void initialize(Element element) {
            this.name = element.getAttribute("name");
            this.selectorFeature = this.createFeature(this.getClassPrefix(), element.getAttribute("select"), NO_PARAMETER_TYPES);
            this.pattern = Pattern.compile(element.getAttribute("match"), 40);
        }

        protected Feature createFeature(String classPrefix, String path, Class<?>[] parameterTypes) {
            return new Feature(this.getClassPrefix(), path, parameterTypes);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Feature getSelectorFeature() {
            return this.selectorFeature;
        }

        public void setSelectorFeature(Feature selectorFeature) {
            this.selectorFeature = selectorFeature;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setPattern(Pattern pattern) {
            this.pattern = pattern;
        }
    }

    public static class Feature
    extends PrefixHandler {
        protected Class<?> featureClass;
        protected Method featureMethod;

        public Feature(String classPrefix) {
            super(classPrefix);
        }

        public Feature(String classPrefix, String path, Class<?>[] parameterTypes) {
            super(classPrefix);
            this.initialize(path, parameterTypes);
        }

        public Class<?> getFeatureClass() {
            return this.featureClass;
        }

        public Method getFeatureMethod() {
            return this.featureMethod;
        }

        public void initialize(String path, Class<?>[] parameterTypes) {
            int index = path.indexOf(47);
            String className = path.substring(0, index);
            String methodName = path.substring(index + 1);
            try {
                this.featureClass = JControlModel.classForClassName(this.classPrefix, className);
                if (this.featureClass != null) {
                    this.featureMethod = this.featureClass.getMethod(methodName, parameterTypes);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static class MatchRule
    extends PrefixHandler {
        protected String name;
        protected Pattern markup;
        protected Feature getFeature;
        protected Pattern signature;
        protected boolean stopMatching = false;

        public MatchRule(String classPrefix) {
            super(classPrefix);
        }

        public MatchRule(String classPrefix, Element element) {
            this(classPrefix);
            this.initialize(element);
        }

        public void initialize(Element element) {
            if (element.hasAttribute("markup")) {
                this.markup = Pattern.compile(element.getAttribute("markup"), 40);
            }
            if (element.hasAttribute("get")) {
                this.getFeature = this.createFeature(this.getClassPrefix(), element.getAttribute("get"), NO_PARAMETER_TYPES);
                if (element.hasAttribute("signature")) {
                    this.signature = Pattern.compile(element.getAttribute("signature"), 40);
                }
            }
            if (element.hasAttribute("stopMatching")) {
                this.stopMatching = Boolean.parseBoolean(element.getAttribute("stopMatching"));
            }
        }

        protected Feature createFeature(String classPrefix, String path, Class<?>[] parameterTypes) {
            return new Feature(this.getClassPrefix(), path, parameterTypes);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Feature getGetFeature() {
            return this.getFeature;
        }

        public void setGetFeature(Feature getFeature) {
            this.getFeature = getFeature;
        }

        public Pattern getMarkup() {
            return this.markup;
        }

        public void setMarkup(Pattern markup) {
            this.markup = markup;
        }

        public Pattern getSignature() {
            return this.signature;
        }

        public void setSignature(Pattern signature) {
            this.signature = signature;
        }

        public boolean isStopMatching() {
            return this.stopMatching;
        }

        public void setStopMatching(boolean stopMatching) {
            this.stopMatching = stopMatching;
        }
    }

    public static class PullRule
    extends PrefixHandler {
        protected static Class<?>[] noParameterTypes = new Class[0];
        protected String name;
        protected Pattern sourceMarkup;
        protected Pattern sourceParentMarkup;
        protected Feature sourceGetFeature;
        protected Pattern sourceTransfer;
        protected Pattern targetMarkup;
        protected Pattern targetParentMarkup;
        protected Feature targetPutFeature;
        protected Feature equalityFeature;

        public PullRule(String classPrefix) {
            super(classPrefix);
        }

        public PullRule(String classPrefix, Element element) {
            this(classPrefix);
            this.initialize(element);
        }

        public void initialize(Element element) {
            Method featureMethod;
            String classPrefix = this.getClassPrefix();
            this.sourceGetFeature = this.createFeature(classPrefix, element.getAttribute("sourceGet"), noParameterTypes);
            if (this.sourceGetFeature != null && (featureMethod = this.sourceGetFeature.getFeatureMethod()) != null) {
                Class<?> sourceReturnType = featureMethod.getReturnType();
                this.targetPutFeature = this.createFeature(classPrefix, element.getAttribute("targetPut"), new Class[]{sourceReturnType});
                if (this.targetPutFeature.getFeatureMethod() == null && sourceReturnType.isArray()) {
                    this.targetPutFeature = this.createFeature(classPrefix, element.getAttribute("targetPut"), new Class[]{sourceReturnType.getComponentType()});
                }
            }
            if (element.hasAttribute("sourceMarkup")) {
                this.sourceMarkup = Pattern.compile(element.getAttribute("sourceMarkup"), 40);
            }
            if (element.hasAttribute("sourceParentMarkup")) {
                this.sourceParentMarkup = Pattern.compile(element.getAttribute("sourceParentMarkup"), 40);
            }
            if (element.hasAttribute("targetMarkup")) {
                this.targetMarkup = Pattern.compile(element.getAttribute("targetMarkup"), 40);
            }
            if (element.hasAttribute("targetParentMarkup")) {
                this.targetParentMarkup = Pattern.compile(element.getAttribute("targetParentMarkup"), 40);
            }
            if (element.hasAttribute("sourceTransfer")) {
                this.sourceTransfer = Pattern.compile(element.getAttribute("sourceTransfer"), 40);
            }
            if (element.hasAttribute("equals")) {
                this.equalityFeature = this.createFeature(classPrefix, element.getAttribute("equals"), noParameterTypes);
            }
        }

        protected Feature createFeature(String classPrefix, String path, Class<?>[] parameterTypes) {
            return new Feature(this.getClassPrefix(), path, parameterTypes);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Feature getSourceGetFeature() {
            return this.sourceGetFeature;
        }

        public void setSourceGetFeature(Feature sourceGetFeature) {
            this.sourceGetFeature = sourceGetFeature;
        }

        public Feature getEqualityFeature() {
            return this.equalityFeature;
        }

        public void setEqualityFeature(Feature equalityFeature) {
            this.equalityFeature = equalityFeature;
        }

        public Feature getTargetPutFeature() {
            return this.targetPutFeature;
        }

        public void setTargetPutFeature(Feature targetPutFeature) {
            this.targetPutFeature = targetPutFeature;
        }

        public Pattern getSourceTransfer() {
            return this.sourceTransfer;
        }

        public void setSourceTransfer(Pattern sourceTransfer) {
            this.sourceTransfer = sourceTransfer;
        }

        public Pattern getSourceMarkup() {
            return this.sourceMarkup;
        }

        public void setSourceMarkup(Pattern sourceMarkup) {
            this.sourceMarkup = sourceMarkup;
        }

        public Pattern getTargetMarkup() {
            return this.targetMarkup;
        }

        public void setTargetMarkup(Pattern targetMarkup) {
            this.targetMarkup = targetMarkup;
        }

        public Pattern getSourceParentMarkup() {
            return this.sourceParentMarkup;
        }

        public void setSourceParentMarkup(Pattern sourceParentMarkup) {
            this.sourceParentMarkup = sourceParentMarkup;
        }

        public Pattern getTargetParentMarkup() {
            return this.targetParentMarkup;
        }

        public void setTargetParentMarkup(Pattern targetParentMarkup) {
            this.targetParentMarkup = targetParentMarkup;
        }
    }

    public static class PushRule
    extends PrefixHandler {
        protected String name;
        protected Class<?> selector;
        protected Pattern markup;
        protected Pattern targetParentMarkup;

        public PushRule(String classPrefix) {
            super(classPrefix);
        }

        public PushRule(String classPrefix, Element element) {
            this(classPrefix);
            this.initialize(element);
        }

        public void initialize(Element element) {
            if (element.hasAttribute("select")) {
                this.selector = JControlModel.classForClassName(this.getClassPrefix(), element.getAttribute("select"));
            }
            if (element.hasAttribute("markup")) {
                this.markup = Pattern.compile(element.getAttribute("markup"), 40);
            }
            if (element.hasAttribute("targetParentMarkup")) {
                this.targetParentMarkup = Pattern.compile(element.getAttribute("targetParentMarkup"), 40);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getSelector() {
            return this.selector;
        }

        public void setSelector(Class<?> selector) {
            this.selector = selector;
        }

        public Pattern getMarkup() {
            return this.markup;
        }

        public void setMarkup(Pattern markup) {
            this.markup = markup;
        }

        public Pattern getTargetParentMarkup() {
            return this.targetParentMarkup;
        }

        public void setTargetParentMarkup(Pattern targetParentMarkup) {
            this.targetParentMarkup = targetParentMarkup;
        }
    }

    public static class SortRule
    extends PrefixHandler {
        protected String name;
        protected Class<?> selector;
        protected Pattern markup;

        public SortRule(String classPrefix) {
            super(classPrefix);
        }

        public SortRule(String classPrefix, Element element) {
            this(classPrefix);
            this.initialize(element);
        }

        public void initialize(Element element) {
            if (element.hasAttribute("select")) {
                this.selector = JControlModel.classForClassName(this.getClassPrefix(), element.getAttribute("select"));
            }
            if (element.hasAttribute("markup")) {
                this.markup = Pattern.compile(element.getAttribute("markup"), 40);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getSelector() {
            return this.selector;
        }

        public void setSelector(Class<?> selector) {
            this.selector = selector;
        }

        public Pattern getMarkup() {
            return this.markup;
        }

        public void setMarkup(Pattern markup) {
            this.markup = markup;
        }
    }

    public static class SweepRule
    extends PrefixHandler {
        protected String name;
        protected Class<?> selector;
        protected Pattern markup;
        protected Pattern parentMarkup;
        protected Action action = Action.REMOVE;
        protected String newName;

        public SweepRule(String classPrefix) {
            super(classPrefix);
        }

        public SweepRule(String classPrefix, Element element) {
            this(classPrefix);
            this.initialize(element);
        }

        public void initialize(Element element) {
            if (element.hasAttribute("select")) {
                this.selector = JControlModel.classForClassName(this.getClassPrefix(), element.getAttribute("select"));
            }
            if (element.hasAttribute("markup")) {
                this.markup = Pattern.compile(element.getAttribute("markup"), 40);
            }
            if (element.hasAttribute("parentMarkup")) {
                this.parentMarkup = Pattern.compile(element.getAttribute("parentMarkup"), 40);
            }
            if (element.hasAttribute("action")) {
                this.action = Action.valueOf(element.getAttribute("action").toUpperCase());
                if (this.action == Action.RENAME && element.hasAttribute("newName")) {
                    this.newName = element.getAttribute("newName");
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getSelector() {
            return this.selector;
        }

        public void setSelector(Class<?> selector) {
            this.selector = selector;
        }

        public Pattern getMarkup() {
            return this.markup;
        }

        public void setMarkup(Pattern markup) {
            this.markup = markup;
        }

        public Pattern getParentMarkup() {
            return this.parentMarkup;
        }

        public void setParentMarkup(Pattern parentMarkup) {
            this.parentMarkup = parentMarkup;
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public static enum Action {
            REMOVE,
            RENAME,
            COMMENT;

        }
    }
}

