/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.callhierarchy;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeHierarchyAction;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeProjectAction;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeWorkingSetAction;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchScopeWorkspaceAction;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.internal.ui.callhierarchy.SelectWorkingSetAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;

public abstract class SearchScopeActionGroup
extends ActionGroup {
    private static final String TAG_SEARCH_SCOPE_TYPE = "search_scope_type";
    private static final String TAG_SELECTED_WORKING_SET = "working_set";
    private static final String TAG_WORKING_SET_COUNT = "working_set_count";
    private static final String DIALOGSTORE_SCOPE_TYPE = "SearchScopeActionGroup.search_scope_type";
    private static final String DIALOGSTORE_SELECTED_WORKING_SET = "SearchScopeActionGroup.working_set";
    static final int SEARCH_SCOPE_TYPE_WORKSPACE = 1;
    static final int SEARCH_SCOPE_TYPE_PROJECT = 2;
    static final int SEARCH_SCOPE_TYPE_HIERARCHY = 3;
    static final int SEARCH_SCOPE_TYPE_WORKING_SET = 4;
    private SearchScopeAction fSelectedAction = null;
    private String[] fSelectedWorkingSetNames = null;
    private CallHierarchyViewPart fView;
    private IDialogSettings fDialogSettings;
    private SearchScopeHierarchyAction fSearchScopeHierarchyAction;
    private SearchScopeProjectAction fSearchScopeProjectAction;
    private SearchScopeWorkspaceAction fSearchScopeWorkspaceAction;
    private SelectWorkingSetAction fSelectWorkingSetAction;

    public SearchScopeActionGroup(CallHierarchyViewPart view, IDialogSettings dialogSettings) {
        this.fView = view;
        this.fDialogSettings = dialogSettings;
        this.createActions();
    }

    public IDLTKSearchScope getSearchScope() {
        if (this.fSelectedAction != null) {
            return this.fSelectedAction.getSearchScope();
        }
        return null;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fillContextMenu(actionBars.getMenuManager());
    }

    protected abstract IDLTKLanguageToolkit getLangaugeToolkit();

    protected void setActiveWorkingSets(IWorkingSet[] sets) {
        if (sets != null) {
            this.fSelectedWorkingSetNames = this.getWorkingSetNames(sets);
            this.fSelectedAction = new SearchScopeWorkingSetAction(this, sets, this.getScopeDescription(sets));
        } else {
            this.fSelectedWorkingSetNames = null;
            this.fSelectedAction = null;
        }
    }

    private String[] getWorkingSetNames(IWorkingSet[] sets) {
        String[] result = new String[sets.length];
        int i = 0;
        while (i < sets.length) {
            result[i] = sets[i].getName();
            ++i;
        }
        return result;
    }

    protected IWorkingSet[] getActiveWorkingSets() {
        if (this.fSelectedWorkingSetNames != null) {
            return this.getWorkingSets(this.fSelectedWorkingSetNames);
        }
        return null;
    }

    private IWorkingSet[] getWorkingSets(String[] workingSetNames) {
        if (workingSetNames == null) {
            return null;
        }
        HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>(2);
        int j = 0;
        while (j < workingSetNames.length) {
            IWorkingSet workingSet = this.getWorkingSetManager().getWorkingSet(workingSetNames[j]);
            if (workingSet != null) {
                workingSets.add(workingSet);
            }
            ++j;
        }
        return workingSets.toArray(new IWorkingSet[workingSets.size()]);
    }

    protected void setSelected(SearchScopeAction newSelection, boolean ignoreUnchecked) {
        if (!ignoreUnchecked || newSelection.isChecked()) {
            this.fSelectedWorkingSetNames = newSelection instanceof SearchScopeWorkingSetAction ? this.getWorkingSetNames(((SearchScopeWorkingSetAction)newSelection).getWorkingSets()) : null;
            this.fSelectedAction = newSelection != null ? newSelection : this.fSearchScopeWorkspaceAction;
            this.fDialogSettings.put(DIALOGSTORE_SCOPE_TYPE, this.getSearchScopeType());
            this.fDialogSettings.put(DIALOGSTORE_SELECTED_WORKING_SET, this.fSelectedWorkingSetNames);
        }
    }

    protected CallHierarchyViewPart getView() {
        return this.fView;
    }

    protected IWorkingSetManager getWorkingSetManager() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        return workingSetManager;
    }

    protected void fillSearchActions(IMenuManager javaSearchMM) {
        Action[] actions = this.getActions();
        int i = 0;
        while (i < actions.length) {
            Action action = actions[i];
            if (action.isEnabled()) {
                javaSearchMM.add((IAction)action);
            }
            ++i;
        }
        javaSearchMM.setVisible(!javaSearchMM.isEmpty());
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.search"));
        MenuManager javaSearchMM = new MenuManager(CallHierarchyMessages.SearchScopeActionGroup_searchScope, "group.search");
        javaSearchMM.setRemoveAllWhenShown(true);
        javaSearchMM.addMenuListener(manager -> this.fillSearchActions(manager));
        this.fillSearchActions((IMenuManager)javaSearchMM);
        menu.appendToGroup("group.search", (IContributionItem)javaSearchMM);
    }

    private Action[] getActions() {
        ArrayList<SearchScopeWorkingSetAction> actions = new ArrayList<SearchScopeWorkingSetAction>(SearchUtil.LRU_WORKINGSET_LIST_SIZE + 4);
        this.addAction(actions, this.fSearchScopeWorkspaceAction);
        this.addAction(actions, this.fSearchScopeProjectAction);
        this.addAction(actions, this.fSearchScopeHierarchyAction);
        this.addAction(actions, this.fSelectWorkingSetAction);
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            IWorkingSet[] workingSets = (IWorkingSet[])iter.next();
            String description = SearchUtil.toString(workingSets);
            SearchScopeWorkingSetAction workingSetAction = new SearchScopeWorkingSetAction(this, workingSets, description);
            if (this.isSelectedWorkingSet(workingSets)) {
                workingSetAction.setChecked(true);
            }
            actions.add(workingSetAction);
        }
        Action[] result = actions.toArray(new Action[actions.size()]);
        this.ensureExactlyOneCheckedAction(result);
        return result;
    }

    private void ensureExactlyOneCheckedAction(Action[] result) {
        int checked = this.getCheckedActionCount(result);
        if (checked != 1) {
            if (checked > 1) {
                int i = 0;
                while (i < result.length) {
                    Action action = result[i];
                    action.setChecked(false);
                    ++i;
                }
            }
            this.fSearchScopeWorkspaceAction.setChecked(true);
        }
    }

    private int getCheckedActionCount(Action[] result) {
        int checked = 0;
        int i = 0;
        while (i < result.length) {
            Action action = result[i];
            if (action.isChecked()) {
                ++checked;
            }
            ++i;
        }
        return checked;
    }

    private void addAction(List actions, Action action) {
        if (action == this.fSelectedAction) {
            action.setChecked(true);
        } else {
            action.setChecked(false);
        }
        actions.add(action);
    }

    private void createActions() {
        int searchScopeType;
        this.fSearchScopeWorkspaceAction = new SearchScopeWorkspaceAction(this);
        this.fSelectWorkingSetAction = new SelectWorkingSetAction(this);
        this.fSearchScopeHierarchyAction = new SearchScopeHierarchyAction(this);
        this.fSearchScopeProjectAction = new SearchScopeProjectAction(this);
        try {
            searchScopeType = this.fDialogSettings.getInt(DIALOGSTORE_SCOPE_TYPE);
        }
        catch (NumberFormatException e) {
            searchScopeType = 1;
        }
        String[] workingSetNames = this.fDialogSettings.getArray(DIALOGSTORE_SELECTED_WORKING_SET);
        this.setSelected(this.getSearchScopeAction(searchScopeType, workingSetNames), false);
    }

    public void saveState(IMemento memento) {
        int type = this.getSearchScopeType();
        memento.putInteger(TAG_SEARCH_SCOPE_TYPE, type);
        if (type == 4) {
            memento.putInteger(TAG_WORKING_SET_COUNT, this.fSelectedWorkingSetNames.length);
            int i = 0;
            while (i < this.fSelectedWorkingSetNames.length) {
                String workingSetName = this.fSelectedWorkingSetNames[i];
                memento.putString(TAG_SELECTED_WORKING_SET + i, workingSetName);
                ++i;
            }
        }
    }

    public void restoreState(IMemento memento) {
        String[] workingSetNames = null;
        Integer scopeType = memento.getInteger(TAG_SEARCH_SCOPE_TYPE);
        if (scopeType != null) {
            Integer workingSetCount;
            if (scopeType == 4 && (workingSetCount = memento.getInteger(TAG_WORKING_SET_COUNT)) != null) {
                workingSetNames = new String[workingSetCount.intValue()];
                int i = 0;
                while (i < workingSetCount) {
                    workingSetNames[i] = memento.getString(TAG_SELECTED_WORKING_SET + i);
                    ++i;
                }
            }
            this.setSelected(this.getSearchScopeAction(scopeType, workingSetNames), false);
        }
    }

    private SearchScopeAction getSearchScopeAction(int searchScopeType, String[] workingSetNames) {
        switch (searchScopeType) {
            case 1: {
                return this.fSearchScopeWorkspaceAction;
            }
            case 2: {
                return this.fSearchScopeProjectAction;
            }
            case 3: {
                return this.fSearchScopeHierarchyAction;
            }
            case 4: {
                IWorkingSet[] workingSets = this.getWorkingSets(workingSetNames);
                if (workingSets != null && workingSets.length > 0) {
                    return new SearchScopeWorkingSetAction(this, workingSets, this.getScopeDescription(workingSets));
                }
                return null;
            }
        }
        return null;
    }

    private int getSearchScopeType() {
        if (this.fSelectedAction != null) {
            return this.fSelectedAction.getSearchScopeType();
        }
        return 0;
    }

    private String getScopeDescription(IWorkingSet[] workingSets) {
        return MessageFormat.format(CallHierarchyMessages.WorkingSetScope, SearchUtil.toString(workingSets));
    }

    private boolean isSelectedWorkingSet(IWorkingSet[] workingSets) {
        if (this.fSelectedWorkingSetNames != null && this.fSelectedWorkingSetNames.length == workingSets.length) {
            HashSet<String> workingSetNames = new HashSet<String>(workingSets.length);
            int i = 0;
            while (i < workingSets.length) {
                workingSetNames.add(workingSets[i].getName());
                ++i;
            }
            i = 0;
            while (i < this.fSelectedWorkingSetNames.length) {
                if (!workingSetNames.contains(this.fSelectedWorkingSetNames[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String getFullDescription() {
        if (this.fSelectedAction != null) {
            return this.fSelectedAction.getFullDescription();
        }
        return null;
    }
}

