/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.internal.core.ModelStatus;

public class ModelException
extends CoreException {
    private static final long serialVersionUID = 1L;
    CoreException nestedCoreException;

    public ModelException(Throwable e, int code) {
        this(new ModelStatus(code, e));
    }

    public ModelException(IModelStatus status) {
        super((IStatus)status);
    }

    public ModelException(CoreException exception) {
        super(exception.getStatus());
        this.nestedCoreException = exception;
    }

    public Throwable getException() {
        if (this.nestedCoreException == null) {
            return this.getStatus().getException();
        }
        return this.nestedCoreException;
    }

    public IModelStatus getModelStatus() {
        IStatus status = this.getStatus();
        if (status instanceof IModelStatus) {
            return (IModelStatus)status;
        }
        return new ModelStatus(this.nestedCoreException);
    }

    public boolean isDoesNotExist() {
        IModelStatus modelStatus = this.getModelStatus();
        return modelStatus != null && modelStatus.isDoesNotExist();
    }

    public static ModelException propagate(CoreException exception) throws ModelException {
        if (exception instanceof ModelException) {
            throw (ModelException)exception;
        }
        throw new ModelException(exception);
    }
}

