/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.services.configurator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.services.configurator.IServicesConfigurator;
import org.eclipse.acceleo.query.services.configurator.IServicesConfiguratorDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;

public class ServicesConfiguratorRegistryListener
implements IRegistryEventListener {
    public static final String CLASS = "class";
    public static final String SERVICES_CONFIGURATOR_EXTENSION_POINT = "org.eclipse.acceleo.query.ide.servicesConfigurator";
    public static final String SERVICES_CONFIGURATOR_TAG_EXTENSION = "servicesConfigurators";
    public static final String SERVICES_CONFIGURATOR_ATTRIBUTE_CLASS = "class";
    public static final String SERVICES_CONFIGURATOR_ATTRIBUTE_LANGUAGE = "language";
    private final Map<String, IServicesConfiguratorDescriptor> descriptors = new HashMap<String, IServicesConfiguratorDescriptor>();

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (SERVICES_CONFIGURATOR_EXTENSION_POINT.equals(extension.getUniqueIdentifier())) {
                this.parseServicesConfiguratorExtension(extension);
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(SERVICES_CONFIGURATOR_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseServicesConfiguratorExtension(extension);
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IServicesConfiguratorDescriptor descriptor;
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (SERVICES_CONFIGURATOR_TAG_EXTENSION.equals(element.getName()) && (descriptor = this.descriptors.remove(element.getAttribute("class"))) != null) {
                    AQLUtils.unregisterServicesConfigurator((IServicesConfiguratorDescriptor)descriptor);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    private void parseServicesConfiguratorExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (SERVICES_CONFIGURATOR_TAG_EXTENSION.equals(element.getName())) {
                ExtensionServicesConfiguratorDescriptor descriptor = new ExtensionServicesConfiguratorDescriptor(element);
                this.descriptors.put(element.getAttribute("class"), descriptor);
                AQLUtils.registerServicesConfigurator((IServicesConfiguratorDescriptor)descriptor);
            }
            ++n2;
        }
    }

    public static class ExtensionServicesConfiguratorDescriptor
    implements IServicesConfiguratorDescriptor {
        private final IConfigurationElement element;
        private String language;
        private IServicesConfigurator configurator;

        public ExtensionServicesConfiguratorDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        public IServicesConfigurator getServicesConfigurator() {
            if (this.configurator == null) {
                try {
                    this.configurator = (IServicesConfigurator)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    QueryPlugin.log((Exception)((Object)e), false);
                }
            }
            return this.configurator;
        }

        public String getLanguage() {
            if (this.language == null) {
                this.language = this.element.getAttribute(ServicesConfiguratorRegistryListener.SERVICES_CONFIGURATOR_ATTRIBUTE_LANGUAGE);
            }
            return this.language;
        }
    }
}

