/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class Comment
extends ASTNode {
    public static final int TYPE_SINGLE_LINE = 0;
    public static final int TYPE_MULTILINE = 1;
    public static final int TYPE_PHPDOC = 2;
    private final int commentType;
    private List<Scalar> taskTags;

    public Comment(int start, int end, int type) {
        super(start, end);
        this.commentType = type;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            visitor.endvisit((ASTNode)this);
        }
    }

    public static String getCommentType(int type) {
        switch (type) {
            case 0: {
                return "singleLine";
            }
            case 1: {
                return "multiLine";
            }
            case 2: {
                return "phpDoc";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getCommentType() {
        return this.commentType;
    }

    public List<Scalar> getTaskTags() {
        return this.taskTags;
    }

    public void setTaskTags(List<Scalar> taskTags) {
        this.taskTags = taskTags;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString(this);
    }
}

