/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;

public class DomainModelWorkspaceSynchronizerDelegate
implements WorkspaceSynchronizer.Delegate {
    private DiagramBehavior diagramBehavior;

    public DomainModelWorkspaceSynchronizerDelegate(DiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    public void dispose() {
        this.diagramBehavior = null;
    }

    public boolean handleResourceChanged(Resource resource) {
        IFile file = WorkspaceSynchronizer.getUnderlyingFile((Resource)resource);
        if (file == null) {
            this.diagramBehavior.getUpdateBehavior().setResourceChanged(true);
            return true;
        }
        if (file.getLocalTimeStamp() != resource.getTimeStamp()) {
            this.diagramBehavior.getUpdateBehavior().setResourceChanged(true);
            return true;
        }
        return true;
    }

    public boolean handleResourceDeleted(Resource resource) {
        return false;
    }

    public boolean handleResourceMoved(Resource resource, URI newURI) {
        resource.setURI(newURI);
        IDiagramEditorInput editorInput = this.diagramBehavior.getDiagramContainer().getDiagramEditorInput();
        if (editorInput != null) {
            editorInput.updateUri(newURI);
        }
        this.diagramBehavior.refreshContent();
        return true;
    }
}

