/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IDriverMgmtConstants;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.OverrideTemplateDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverPropertySourceProvider;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class EditDriverDialog
extends TitleAreaDialog
implements IContextProvider {
    public static final String MEMENTO_ROOT = "Drivers Edit Driver_Dialog_Root";
    public static final String MEMENTO_DIALOG_SIZE_HEIGHT = "Dialog_Size_Height";
    public static final String MEMENTO_DIALOG_SIZE_WIDTH = "Dialog_Size_Width";
    private static String previouslyBrowsedDirectory = "";
    private PageBook book = null;
    private IPropertySet mPropertySet = null;
    private IPropertySet mInitialPropertySet = null;
    private TemplateDescriptor descriptor = null;
    private List list;
    private Text mDriverNameText;
    private Text mDriverTypeText;
    private Button mAddJar;
    private Button mEditJar;
    private Button mRemoveJar;
    private Button mClearAll;
    private Button mOKButton;
    private String mDriverName;
    private String mJarList;
    private String mDriverTypeID;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());
    private ChangeListener psetChangedListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent arg0) {
            EditDriverDialog.this.isValid();
        }
    };

    public EditDriverDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x860);
    }

    public EditDriverDialog(Shell parentShell, String driverTypeID) {
        this(parentShell);
        this.mDriverTypeID = driverTypeID;
        this.descriptor = TemplateDescriptor.getDriverTemplateDescriptor((String)this.mDriverTypeID);
    }

    public EditDriverDialog(Shell parentShell, IPropertySet pset) {
        this(parentShell);
        this.setPropertySet(pset);
        if (this.mPropertySet.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType") != null) {
            String driverType;
            this.mDriverTypeID = driverType = this.mPropertySet.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
            this.descriptor = TemplateDescriptor.getDriverTemplateDescriptor((String)this.mDriverTypeID);
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        PropertySheetPage page = new PropertySheetPage();
        page.createControl((Composite)book);
        return page;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_EDIT_DRIVER_DIALOG", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        contents.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EditDriverDialog.this.saveState();
            }
        });
        Composite composite = new Composite(contents, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.driverNameText"));
        this.mDriverNameText = new Text(composite, 2048);
        this.mDriverNameText.setLayoutData((Object)new GridData(768));
        this.mDriverNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditDriverDialog.this.mDriverName = EditDriverDialog.this.mDriverNameText.getText();
                EditDriverDialog.this.validateName();
            }
        });
        label = new Label(composite, 0);
        label.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.driverTypeText"));
        this.mDriverTypeText = new Text(composite, 2056);
        this.mDriverTypeText.setLayoutData((Object)new GridData(768));
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = -5;
        gridData.horizontalSpan = 2;
        composite_1.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_1.setLayout((Layout)gridLayout_1);
        Label label2 = new Label(composite_1, 0);
        label2.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.driverFileList"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData);
        this.list = new List(composite_1, 2816);
        GridData gridData_1 = new GridData(1808);
        gridData_1.verticalSpan = 4;
        gridData_1.horizontalSpan = 2;
        this.list.setLayoutData((Object)gridData_1);
        this.list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = EditDriverDialog.this.list.getSelectionCount() > 0;
                EditDriverDialog.this.mEditJar.setEnabled(enabled);
                EditDriverDialog.this.mRemoveJar.setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mAddJar = new Button(composite_1, 0);
        this.mAddJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDriverDialog.this.handleLocationBrowseButtonPressed();
                EditDriverDialog.this.updateJarList();
            }
        });
        this.mAddJar.setLayoutData((Object)new GridData(256));
        this.mAddJar.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.addJar"));
        this.mEditJar = new Button(composite_1, 0);
        this.mEditJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditDriverDialog.this.list.getSelectionCount() > 0) {
                    String selectedItem = EditDriverDialog.this.list.getItem(EditDriverDialog.this.list.getSelectionIndex());
                    EditDriverDialog.this.handleLocationEditButtonPressed(selectedItem);
                    EditDriverDialog.this.updateJarList();
                }
            }
        });
        this.mEditJar.setLayoutData((Object)new GridData(256));
        this.mEditJar.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.editJar"));
        this.mRemoveJar = new Button(composite_1, 0);
        this.mRemoveJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditDriverDialog.this.list.getSelectionCount() > 0) {
                    String[] selected = EditDriverDialog.this.list.getSelection();
                    int i = 0;
                    while (i < selected.length) {
                        EditDriverDialog.this.list.remove(selected[i]);
                        ++i;
                    }
                    EditDriverDialog.this.updateJarList();
                }
            }
        });
        this.mRemoveJar.setLayoutData((Object)new GridData(256));
        this.mRemoveJar.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.removeJar"));
        this.mClearAll = new Button(composite_1, 0);
        this.mClearAll.setLayoutData((Object)new GridData(258));
        this.mClearAll.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.button.clearAllJars"));
        this.mClearAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDriverDialog.this.list.removeAll();
                EditDriverDialog.this.updateJarList();
            }
        });
        if (this.hasVisibleProperties()) {
            Composite composite_2 = new Composite(composite, 0);
            gridData = new GridData(1808);
            gridData.horizontalIndent = -5;
            gridData.horizontalSpan = 2;
            composite_2.setLayoutData((Object)gridData);
            GridLayout gridLayout_2 = new GridLayout();
            gridLayout_2.numColumns = 1;
            composite_2.setLayout((Layout)gridLayout_2);
            label2 = new Label(composite_2, 0);
            label2.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.label.properties"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label2.setLayoutData((Object)gridData);
            this.book = new PageBook(composite_2, 2048);
            this.book.setLayoutData((Object)new GridData(1808));
            PropertySheetPage page = new PropertySheetPage();
            page.createControl((Composite)this.book);
            DriverPropertySourceProvider mpsp = null;
            mpsp = this.mPropertySet != null ? new DriverPropertySourceProvider(this.mPropertySet, this.descriptor) : new DriverPropertySourceProvider();
            mpsp.addChangeListener(this.psetChangedListener);
            page.setPropertySourceProvider((IPropertySourceProvider)mpsp);
            this.book.showPage(page.getControl());
            page.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.mPropertySet));
        }
        this.setTitle(DriverMgmtMessages.getString((String)"EditDriverDialog.title"));
        this.setMessage(DriverMgmtMessages.getString((String)"EditDriverDialog.message"));
        boolean enabled = this.list.getSelectionCount() > 0;
        this.mEditJar.setEnabled(enabled);
        this.mRemoveJar.setEnabled(enabled);
        this.updateFromPropertySet();
        this.isValid(true);
        return area;
    }

    private void updatePropertyDescriptors() {
        PropertySheetPage page = new PropertySheetPage();
        page.createControl((Composite)this.book);
        DriverPropertySourceProvider mpsp = null;
        mpsp = this.mPropertySet != null ? new DriverPropertySourceProvider(this.mPropertySet, this.descriptor) : new DriverPropertySourceProvider();
        page.setPropertySourceProvider((IPropertySourceProvider)mpsp);
        this.book.showPage(page.getControl());
        page.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.mPropertySet));
    }

    private void validateName() {
        boolean isOk = false;
        String testName = this.mDriverName;
        DriverInstance obj = DriverManager.getInstance().getDriverInstanceByName(testName);
        if (obj == null || obj != null && testName.equals(this.mPropertySet.getName())) {
            isOk = true;
            this.setErrorMessage(null);
        } else {
            String errorMessage = DriverMgmtMessages.getString((String)"NewDriverDialog.driverExistsWithName");
            this.setErrorMessage(errorMessage);
        }
        if (this.mOKButton != null) {
            this.mOKButton.setEnabled(isOk);
        }
    }

    private void updateJarList() {
        this.mJarList = this.createList(this.list.getItems());
        this.mPropertySet.getBaseProperties().setProperty("jarList", this.mJarList);
        this.isValid();
        this.updatePropertyDescriptors();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.mOKButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        IDialogSettings dSection;
        super.configureShell(newShell);
        int width = 500;
        int height = 700;
        newShell.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.windowTitle"));
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null && (dSection = dset.getSection(MEMENTO_ROOT)) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT).trim().length() > 0) {
            height = dSection.getInt(MEMENTO_DIALOG_SIZE_HEIGHT);
            width = dSection.getInt(MEMENTO_DIALOG_SIZE_WIDTH);
        }
        newShell.setSize(width, height);
        this.centerDialog(newShell);
    }

    private void centerDialog(Shell newShell) {
        Composite parent = newShell.getParent();
        Rectangle parentSize = parent.getBounds();
        Rectangle newShellSize = newShell.getBounds();
        int x = (parentSize.width - newShellSize.width) / 2 + parentSize.x;
        int y = (parentSize.height - newShellSize.height) / 2 + parentSize.y;
        newShell.setLocation(new Point(x, y));
    }

    private void handleLocationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.title.filebrowse"));
        String dirName = previouslyBrowsedDirectory;
        if (dirName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            } else {
                dialog.setFilterPath(new Path(System.getProperty("user.home")).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = new Path(selectedDirectory).removeLastSegments(1).toOSString();
            this.list.add(selectedDirectory);
        }
    }

    private void handleLocationEditButtonPressed(String editLocation) {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(DriverMgmtMessages.getString((String)"EditDriverDialog.title.filebrowse"));
        String dirName = editLocation;
        dialog.setFileName(dirName);
        if (dirName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            } else {
                dialog.setFilterPath(dirName);
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = new Path(selectedDirectory).removeLastSegments(1).toOSString();
            this.list.remove(editLocation);
            this.list.add(selectedDirectory);
            if (this.list.getItemCount() > 1 && MessageDialog.openQuestion((Shell)this.getShell(), (String)DriverMgmtMessages.getString((String)"EditDriverDialog.msg.updateAllJarsToSamePath.title"), (String)DriverMgmtMessages.getString((String)"EditDriverDialog.msg.updateAllJarsToSamePath.message"))) {
                int location;
                String[] items = this.list.getItems();
                String separator = "\\";
                if (selectedDirectory.indexOf("/") > -1) {
                    separator = "/";
                }
                if ((location = selectedDirectory.lastIndexOf(separator)) > -1 && location < selectedDirectory.length() - 1) {
                    String path = selectedDirectory.substring(0, location);
                    int i = 0;
                    while (i < items.length) {
                        String directory = items[i];
                        if (!directory.equals(selectedDirectory)) {
                            String sep2 = "\\";
                            if (directory.indexOf("/") > -1) {
                                sep2 = "/";
                            }
                            int location2 = directory.lastIndexOf(sep2);
                            String filename = directory;
                            if (location2 > -1 && location2 < directory.length() - 1) {
                                filename = directory.substring(location2 + 1, directory.length());
                            }
                            String newdirectory = String.valueOf(path) + separator + filename;
                            this.list.remove(directory);
                            this.list.add(newdirectory);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    protected void okPressed() {
        Properties props;
        block6: {
            String propIdPrefix = DriverMgmtMessages.getString((String)"EditDriverDialog.text.id_prefix");
            String propId = String.valueOf(propIdPrefix) + this.mDriverName;
            if (this.mPropertySet == null) {
                this.mPropertySet = new PropertySetImpl(propId, this.mDriverName);
            }
            this.mPropertySet.setName(this.mDriverName);
            props = new Properties();
            props.setProperty("jarList", this.mJarList);
            IConfigurationElement[] templateprops = this.descriptor.getProperties();
            if (templateprops == null || templateprops.length <= 0) break block6;
            int i = 0;
            while (i < templateprops.length) {
                block8: {
                    String value;
                    String id;
                    block7: {
                        IConfigurationElement prop = templateprops[i];
                        id = prop.getAttribute("id");
                        value = this.mPropertySet.getBaseProperties().getProperty(id);
                        if (value != null) break block7;
                        value = prop.getAttribute("value");
                        OverrideTemplateDescriptor[] otds = OverrideTemplateDescriptor.getByDriverTemplate((String)this.descriptor.getId());
                        if (otds == null || otds.length <= 0) break block7;
                        boolean removetemp = otds[0].getPropertyRemoveFlagFromID(id);
                        if (removetemp) break block8;
                        String valuetemp = otds[0].getPropertyValueFromId(id);
                        if (valuetemp != null && valuetemp.length() > 0) {
                            value = valuetemp;
                        }
                    }
                    props.setProperty(id, value);
                }
                ++i;
            }
        }
        props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", this.descriptor.getId());
        this.mPropertySet.setBaseProperties(props);
        this.psetChangedListener = null;
        super.okPressed();
    }

    private IPropertySet createTestPSet() {
        Properties props;
        PropertySetImpl testPropertySet;
        block6: {
            String propIdPrefix = DriverMgmtMessages.getString((String)"EditDriverDialog.text.id_test_prefix");
            String propId = String.valueOf(propIdPrefix) + this.mDriverName;
            testPropertySet = new PropertySetImpl(propId, this.mDriverName);
            testPropertySet.setName(this.mDriverName);
            props = new Properties();
            props.setProperty("jarList", this.mJarList);
            IConfigurationElement[] templateprops = this.descriptor.getProperties();
            if (templateprops == null || templateprops.length <= 0) break block6;
            int i = 0;
            while (i < templateprops.length) {
                block8: {
                    String value;
                    String id;
                    block7: {
                        IConfigurationElement prop = templateprops[i];
                        id = prop.getAttribute("id");
                        value = null;
                        if (this.mPropertySet.getBaseProperties() != null) {
                            value = this.mPropertySet.getBaseProperties().getProperty(id);
                        }
                        if (value != null) break block7;
                        value = prop.getAttribute("value");
                        OverrideTemplateDescriptor[] otds = OverrideTemplateDescriptor.getByDriverTemplate((String)this.descriptor.getId());
                        if (otds == null || otds.length <= 0) break block7;
                        boolean removetemp = otds[0].getPropertyRemoveFlagFromID(id);
                        if (removetemp) break block8;
                        String valuetemp = otds[0].getPropertyValueFromId(id);
                        if (valuetemp != null && valuetemp.length() > 0) {
                            value = valuetemp;
                        }
                    }
                    props.setProperty(id, value);
                }
                ++i;
            }
        }
        props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", this.descriptor.getId());
        testPropertySet.setBaseProperties(props);
        return testPropertySet;
    }

    public IPropertySet getPropertySet() {
        return this.mPropertySet;
    }

    public IPropertySet getInitialPropertySet() {
        return this.mInitialPropertySet;
    }

    public CategoryDescriptor getCategoryDescriptor() {
        if (this.descriptor != null) {
            CategoryDescriptor category = CategoryDescriptor.getCategoryDescriptor((String)this.descriptor.getParentCategory());
            return category;
        }
        return null;
    }

    private void updateFromPropertySet() {
        if (this.descriptor != null) {
            this.mDriverTypeText.setText(this.descriptor.getName());
            if (this.descriptor.getJarList() != null && this.descriptor.getJarList().length() > 0) {
                String[] jarListArray = this.parseString(this.descriptor.getJarList());
                this.list.removeAll();
                int i = 0;
                while (i < jarListArray.length) {
                    this.list.add(jarListArray[i]);
                    ++i;
                }
            }
        }
        if (this.mPropertySet != null) {
            String jarList;
            this.mDriverNameText.setText(this.mPropertySet.getName());
            this.mDriverName = this.mPropertySet.getName();
            this.mJarList = jarList = this.mPropertySet.getBaseProperties().getProperty("jarList");
            String[] jarListArray = this.parseString(jarList);
            this.list.removeAll();
            int i = 0;
            while (i < jarListArray.length) {
                this.list.add(jarListArray[i]);
                ++i;
            }
        }
        this.isValid();
    }

    public void setPropertySet(IPropertySet propset) {
        this.mPropertySet = propset;
        this.mInitialPropertySet = this.DuplicatePropertySet(propset);
    }

    private String createList(String[] items) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                buffer.append(items[i]);
                if (i + 1 < items.length) {
                    buffer.append(IDriverMgmtConstants.PATH_DELIMITER);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private String[] parseString(String str_list) {
        String token = IDriverMgmtConstants.PATH_DELIMITER;
        if (str_list.indexOf(token) == -1 && str_list.indexOf(44) > -1) {
            token = ",";
        }
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    private boolean hasVisibleProperties() {
        return this.descriptor == null ? false : this.descriptor.hasVisibleProperties();
    }

    private void isValid() {
        this.isValid(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void isValid(boolean inflag) {
        IPropertySet testSet = null;
        testSet = inflag ? this.mPropertySet : this.createTestPSet();
        if (testSet == null) return;
        DriverValidator testValidator = new DriverValidator(this.descriptor, testSet);
        boolean flag = testValidator.isValid();
        if (!flag) {
            try {
                this.setErrorMessage(testValidator.getMessage());
                return;
            }
            catch (SWTException e) {
                if (e.code == 24) return;
                throw e;
            }
        }
        try {
            this.setErrorMessage(null);
            return;
        }
        catch (SWTException e) {
            if (e.code == 24) return;
            throw e;
        }
    }

    private void saveState() {
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null) {
            IDialogSettings dSection = dset.getSection(MEMENTO_ROOT);
            if (dSection == null) {
                dSection = dset.addNewSection(MEMENTO_ROOT);
            }
            if (dSection != null) {
                Point size = this.getShell().getSize();
                dSection.put(MEMENTO_DIALOG_SIZE_HEIGHT, size.y);
                dSection.put(MEMENTO_DIALOG_SIZE_WIDTH, size.x);
            }
        }
    }

    protected void cancelPressed() {
        this.mPropertySet = this.mInitialPropertySet;
        this.psetChangedListener = null;
        super.cancelPressed();
    }

    private IPropertySet DuplicatePropertySet(IPropertySet pset) {
        PropertySetImpl newPset = new PropertySetImpl(pset.getName(), pset.getID());
        if (pset.getBaseProperties().size() > 0) {
            Properties newProps = new Properties();
            newPset.setBaseProperties(newProps);
            newPset.getBaseProperties().putAll((Map<?, ?>)pset.getBaseProperties());
        }
        return newPset;
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

