/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.innate;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.glassfish.jersey.innate.virtual.LoomishExecutors;
import org.glassfish.jersey.innate.virtual.ThreadFactoryBuilder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class VirtualThreadSupport {
    private static final LoomishExecutors NON_VIRTUAL = new NonLoomishExecutors(Executors.defaultThreadFactory());

    private VirtualThreadSupport() {
        throw new IllegalStateException();
    }

    public static boolean isVirtualThread() {
        return false;
    }

    public static LoomishExecutors allowVirtual(boolean allow) {
        return NON_VIRTUAL;
    }

    public static LoomishExecutors allowVirtual(boolean allow, ThreadFactory threadFactory) {
        return new NonLoomishExecutors(threadFactory);
    }

    public static LoomishExecutors allowVirtual(boolean allow, final ThreadFactoryBuilder threadFactoryBuilder) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private long index;
            {
                this.index = threadFactoryBuilder.start();
            }

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadFactoryBuilder.prefix() + this.index++);
            }
        };
        return new NonLoomishExecutors(threadFactory);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class NonLoomishExecutors
    implements LoomishExecutors {
        private final ThreadFactory threadFactory;

        private NonLoomishExecutors(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public ExecutorService newCachedThreadPool() {
            return Executors.newCachedThreadPool();
        }

        @Override
        public ExecutorService newFixedThreadPool(int nThreads) {
            return Executors.newFixedThreadPool(nThreads);
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }
    }
}

