/*******************************************************************************
 * Copyright (c) 2004, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.html.core.internal.contentmodel;



import java.util.Arrays;

import org.eclipse.wst.html.core.internal.provisional.HTML40Namespace;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;

/**
 * TITLE.
 */
final class HedTITLE extends HedPcdata {

	/**
	 */
	public HedTITLE(ElementCollection collection) {
		super(HTML40Namespace.ElementName.TITLE, collection);
		layoutType = LAYOUT_HIDDEN;
	}

	/**
	 * TITLE.
	 * %i18n;
	 */
	protected void createAttributeDeclarations() {
		if (attributes != null)
			return; // already created.
		if (attributeCollection == null)
			return; // fatal

		attributes = new CMNamedNodeMapImpl();

		// %i18n;
		attributeCollection.getI18n(attributes);
	}

	/**
	 * Exclusion.
	 * <code>TITLE</code> has the exclusion.
	 * It is <code>%head.misc;</code>.
	 * %head.misc; is <code>SCRIPT|STYLE|META|LINK|OBJECT</code>.
	 */
	public CMContent getExclusion() {
		if (exclusion != null)
			return exclusion; // already created.
		if (elementCollection == null)
			return null;

		// (SCRIPT|STYLE|META|LINK|OBJECT)
		exclusion = new CMGroupImpl(CMGroup.CHOICE, 1, 1);

		String[] names = {HTML40Namespace.ElementName.SCRIPT, HTML40Namespace.ElementName.STYLE, HTML40Namespace.ElementName.META, HTML40Namespace.ElementName.LINK, HTML40Namespace.ElementName.OBJECT};
		elementCollection.getDeclarations(exclusion, Arrays.asList(names).iterator());
		return exclusion;
	}
}
