/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AttributeGroup;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.core.ast.visitor.Visitor;

public class EnumDeclaration
extends TypeDeclaration {
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(EnumDeclaration.class, "name", Identifier.class, true, false);
    public static final ChildPropertyDescriptor TYPE_PROPERTY = new ChildPropertyDescriptor(EnumDeclaration.class, "type", Identifier.class, false, false);
    public static final ChildListPropertyDescriptor INTERFACES_PROPERTY = new ChildListPropertyDescriptor(EnumDeclaration.class, "interfaces", Identifier.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(EnumDeclaration.class, "body", Block.class, true, true);
    public static final ChildListPropertyDescriptor ATTRIBUTES_PROPERTY = new ChildListPropertyDescriptor(EnumDeclaration.class, "attributes", AttributeGroup.class, true);
    private Identifier type;
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(4);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(INTERFACES_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        propertyList.add(ATTRIBUTES_PROPERTY);
        propertyList.add(TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Override
    protected ChildPropertyDescriptor getBodyProperty() {
        return BODY_PROPERTY;
    }

    @Override
    protected ChildListPropertyDescriptor getInterfacesProperty() {
        return INTERFACES_PROPERTY;
    }

    @Override
    protected ChildPropertyDescriptor getNameProperty() {
        return NAME_PROPERTY;
    }

    @Override
    protected ChildListPropertyDescriptor getAttributesProperty() {
        return ATTRIBUTES_PROPERTY;
    }

    public EnumDeclaration(int start, int end, AST ast, Identifier interfaceName, Identifier type, List<Identifier> interfaces, Block body, List<AttributeGroup> attributes) {
        super(start, end, ast, interfaceName, interfaces.toArray(new Identifier[interfaces.size()]), body);
        this.setEnumType(type);
        if (attributes != null) {
            this.attributes().addAll(attributes);
        }
    }

    public EnumDeclaration(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (AttributeGroup object : this.attributes()) {
            object.accept(visitor);
        }
        this.getName().accept(visitor);
        if (this.getEnumType() != null) {
            this.getEnumType().accept(visitor);
        }
        List<Identifier> interfaes = this.interfaces();
        for (Identifier node : interfaes) {
            ASTNode inter = node;
            inter.accept(visitor);
        }
        this.getBody().accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (AttributeGroup object : this.attributes()) {
            object.traverseTopDown(visitor);
        }
        this.getName().traverseTopDown(visitor);
        if (this.getEnumType() != null) {
            this.getEnumType().traverseTopDown(visitor);
        }
        List<Identifier> interfaes = this.interfaces();
        for (Identifier node : interfaes) {
            ASTNode inter = node;
            inter.traverseTopDown(visitor);
        }
        this.getBody().traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (AttributeGroup object : this.attributes()) {
            object.traverseBottomUp(visitor);
        }
        this.getName().traverseBottomUp(visitor);
        if (this.getEnumType() != null) {
            this.getEnumType().traverseBottomUp(visitor);
        }
        List<Identifier> interfaes = this.interfaces();
        for (Identifier node : interfaes) {
            ASTNode inter = node;
            inter.traverseBottomUp(visitor);
        }
        this.getBody().traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<EnumDeclaration");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.toStringAttributes(buffer, "\t" + tab);
        buffer.append(tab).append("\t").append("<EnumName>\n");
        this.getName().toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("\t").append("</EnumName>\n");
        if (this.getEnumType() != null) {
            buffer.append(tab).append("\t").append("<EnumType>\n");
            this.getEnumType().toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("</EnumType>\n");
        }
        buffer.append(tab).append("\t").append("<Interfaces>\n");
        List<Identifier> interfaes = this.interfaces();
        for (Identifier node : interfaes) {
            ASTNode inter = node;
            inter.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("\t").append("</Interfaces>\n");
        this.getBody().toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</EnumDeclaration>");
    }

    @Override
    public int getType() {
        return 89;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    public Identifier getEnumType() {
        return this.type;
    }

    public void setEnumType(Identifier id) {
        Identifier oldChild = this.type;
        this.preReplaceChild(oldChild, id, TYPE_PROPERTY);
        this.type = id;
        this.postReplaceChild(oldChild, id, TYPE_PROPERTY);
    }

    @Override
    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == TYPE_PROPERTY) {
            if (get) {
                return this.getEnumType();
            }
            this.setEnumType((Identifier)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    ASTNode clone0(AST target) {
        Identifier name = ASTNode.copySubtree(target, this.getName());
        Identifier type = ASTNode.copySubtree(target, this.getEnumType());
        Block body = ASTNode.copySubtree(target, this.getBody());
        List<Identifier> interfaces = ASTNode.copySubtrees(target, this.interfaces());
        List<AttributeGroup> attributes = ASTNode.copySubtrees(target, this.attributes());
        return new EnumDeclaration(this.getStart(), this.getEnd(), target, name, type, interfaces, body, attributes);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

