/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin;

import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.common.lob.CDOClobWriter;
import org.eclipse.emf.cdo.common.lob.CDOLobUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.FilterPermission;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.admin.CDORepositoryConfigurationManager;
import org.eclipse.emf.cdo.server.internal.admin.InternalCDORepositoryConfigurationManager;
import org.eclipse.emf.cdo.server.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.server.internal.admin.catalog.CatalogFactory;
import org.eclipse.emf.cdo.server.internal.admin.catalog.RepositoryCatalog;
import org.eclipse.emf.cdo.server.internal.admin.catalog.RepositoryConfiguration;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.spi.server.AuthenticationUtil;
import org.eclipse.emf.cdo.spi.server.IAppExtension;
import org.eclipse.emf.cdo.spi.server.IAppExtension2;
import org.eclipse.emf.cdo.spi.server.IAuthenticationProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.IAuthenticator2;
import org.w3c.dom.Document;

public class DefaultCDORepositoryConfigurationManager
extends Lifecycle
implements InternalCDORepositoryConfigurationManager,
IManagedContainer.ContainerAware {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DefaultCDORepositoryConfigurationManager.class);
    private IManagedContainer container = IPluginContainer.INSTANCE;
    private InternalRepository adminRepository;
    private String catalogPath = "/catalog";
    private RepositoryCatalog catalog;
    private ISecurityManager securityManager;
    private final IListener repositoryListener = new LifecycleEventAdapter(){

        protected void onActivated(ILifecycle lifecycle) {
            DefaultCDORepositoryConfigurationManager.this.initializeCatalog();
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            Exception exception = DefaultCDORepositoryConfigurationManager.this.deactivate();
            if (exception != null) {
                OM.LOG.error((Throwable)exception);
            }
        }
    };

    public IManagedContainer getManagedContainer() {
        return this.container;
    }

    public void setManagedContainer(IManagedContainer container) {
        this.container = container;
    }

    @Override
    public void setAdminRepository(InternalRepository adminRepository) {
        this.adminRepository = adminRepository;
        if (this.isActive()) {
            this.initializeCatalog();
        }
    }

    public void setCatalogPath(String catalogPath) {
        this.catalogPath = StringUtil.isEmpty((String)catalogPath) ? "/catalog" : catalogPath;
    }

    @Override
    public IRepository addRepository(String name, Document configurationXML) {
        this.checkActive();
        IManagedContainer container = this.requireContainer();
        if (this.getRepository(container, name) != null) {
            throw new IllegalArgumentException("Repository already exists: " + name);
        }
        try {
            RepositoryConfiguration configuration = this.createConfiguration(name, configurationXML);
            return this.startRepository(configuration);
        }
        catch (RuntimeException e) {
            OM.LOG.error((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            OM.LOG.error((Throwable)e);
            throw WrappedException.wrap((Exception)e);
        }
    }

    @Override
    public void removeRepository(IRepository repository) {
        this.checkActive();
        this.deleteConfiguration(repository.getName());
    }

    @Override
    public boolean canRemoveRepository(IRepository repository) {
        this.checkActive();
        return this.isInCatalog(repository.getName());
    }

    @Override
    public Map<String, IRepository> getRepositories() {
        this.checkActive();
        HashMap<String, IRepository> result = new HashMap<String, IRepository>();
        if (this.catalog != null) {
            for (RepositoryConfiguration configuration : this.catalog.getRepositories()) {
                IRepository repository = this.getRepository(this.getManagedContainer(), configuration.getName());
                if (repository == null) continue;
                result.put(repository.getName(), repository);
            }
        }
        return result;
    }

    @Override
    public void authenticateAdministrator() {
        IAuthenticator2 auth;
        InternalSessionManager sessionManager;
        String userID;
        this.requireSecurityManager();
        IAuthenticationProtocol authProtocol = AuthenticationUtil.getAuthenticationProtocol();
        if (authProtocol != null && (userID = (sessionManager = this.adminRepository.getSessionManager()).authenticateUser(authProtocol)) != null && (auth = (IAuthenticator2)ObjectUtil.tryCast((Object)sessionManager.getAuthenticator(), IAuthenticator2.class)) != null && !auth.isAdministrator(userID)) {
            throw new SecurityException("Must be a server administrator to add or delete repositories.");
        }
    }

    protected void doActivate() throws Exception {
        if (TRACER.isEnabled()) {
            TRACER.format("Starting dynamically managed repositories.", new Object[0]);
        }
        this.initializeCatalog();
    }

    protected void doBeforeDeactivate() throws Exception {
        if (TRACER.isEnabled()) {
            TRACER.format("Stopping dynamically managed repositories.", new Object[0]);
        }
        for (IRepository repository : this.getRepositories().values()) {
            try {
                LifecycleUtil.deactivate((Object)repository);
            }
            catch (Exception e) {
                OM.LOG.error((Throwable)e);
            }
        }
    }

    protected void doDeactivate() throws Exception {
        this.catalog = null;
    }

    protected IManagedContainer requireContainer() {
        IManagedContainer result = this.getManagedContainer();
        if (result == null) {
            throw new IllegalStateException("No container.");
        }
        return result;
    }

    protected IRepository startRepository(RepositoryConfiguration configuration) throws Exception {
        RepositoryConfigurator configurator = new RepositoryConfigurator(this.requireContainer());
        IRepository[] result = configurator.configure(configuration.getConfigXML().getContents());
        if (result.length == 1) {
            this.startExtensions(result[0], configuration);
        }
        return result.length == 0 ? null : result[0];
    }

    protected final ISecurityManager requireSecurityManager() {
        if (this.securityManager == null) {
            throw new IllegalStateException("The administrative repository does not have a security manager.");
        }
        return this.securityManager;
    }

    protected <T> T modify(CatalogOperation<T> operation) {
        return this.modify(operation, false);
    }

    protected <T> T modify(final CatalogOperation<T> operation, boolean waitUntilReadable) {
        this.checkActive();
        final Object[] result = new Object[1];
        this.requireSecurityManager().modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                try {
                    RepositoryCatalog localCatalog = (RepositoryCatalog)realm.cdoView().getObject((EObject)DefaultCDORepositoryConfigurationManager.this.catalog);
                    result[0] = operation.execute(localCatalog);
                }
                catch (Exception e) {
                    throw WrappedException.wrap((Exception)e);
                }
            }
        }, waitUntilReadable);
        Object resultAsT = result[0];
        return (T)resultAsT;
    }

    private IRepository getRepository(IManagedContainer container, String name) {
        Object[] objectArray = container.getElements("org.eclipse.emf.cdo.server.repositories");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository repository;
            Object element = objectArray[n2];
            if (element instanceof IRepository && (repository = (IRepository)element).getName().equals(name)) {
                return repository;
            }
            ++n2;
        }
        return null;
    }

    private void startExtensions(IRepository repository, RepositoryConfiguration configuration) {
        IConfigurationElement[] elements;
        final ArrayList<IAppExtension2> extensions = new ArrayList<IAppExtension2>(3);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server", "appExtensions");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("appExtension".equals(element.getName())) {
                try {
                    IAppExtension extension = (IAppExtension)element.createExecutableExtension("class");
                    if (extension instanceof IAppExtension2) {
                        IAppExtension2 extension2 = (IAppExtension2)extension;
                        extension2.startDynamic(configuration.getConfigXML().getContents());
                        extensions.add(extension2);
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++n2;
        }
        if (!extensions.isEmpty()) {
            repository.addListener((IListener)new LifecycleEventAdapter(){

                protected void onDeactivated(ILifecycle lifecycle) {
                    for (IAppExtension extension : extensions) {
                        try {
                            extension.stop();
                        }
                        catch (Exception e) {
                            OM.LOG.error((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private RepositoryConfiguration createConfiguration(final String repositoryName, final Document configuration) throws Exception {
        this.modify(new CatalogOperation<RepositoryConfiguration>(){

            @Override
            public RepositoryConfiguration execute(RepositoryCatalog catalog) throws Exception {
                RepositoryConfiguration result = CatalogFactory.eINSTANCE.createRepositoryConfiguration();
                result.setName(repositoryName);
                CDOClobWriter writer = CDOLobUtil.createClobWriter();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                StreamResult streamResult = new StreamResult((Writer)writer);
                DOMSource source = new DOMSource(configuration);
                transformer.transform(source, streamResult);
                writer.close();
                result.setConfigXML(writer.getClob());
                catalog.getRepositories().add((Object)result);
                return result;
            }
        }, true);
        return this.catalog.getRepository(repositoryName);
    }

    private void deleteConfiguration(final String repositoryName) {
        this.modify(new CatalogOperation<Void>(){

            @Override
            public Void execute(RepositoryCatalog catalog) throws Exception {
                RepositoryConfiguration configuration = catalog.getRepository(repositoryName);
                if (configuration != null) {
                    EcoreUtil.remove((EObject)configuration);
                }
                return null;
            }
        });
    }

    private boolean isInCatalog(String repositoryName) {
        return this.catalog.getRepository(repositoryName) != null;
    }

    private void initializeCatalog() {
        if (this.catalog != null) {
            return;
        }
        if (this.adminRepository == null) {
            return;
        }
        this.adminRepository.addListener(this.repositoryListener);
        if (!LifecycleUtil.isActive((Object)this.adminRepository)) {
            return;
        }
        this.securityManager = SecurityManagerUtil.getSecurityManager((IRepository)this.adminRepository);
        if (this.securityManager == null) {
            this.getManagedContainer().addListener((IListener)new ContainerEventAdapter<Object>(){

                protected void onAdded(IContainer<Object> container, Object element) {
                    ISecurityManager securityManager;
                    if (element instanceof ISecurityManager && (securityManager = (ISecurityManager)element).getRepository() == DefaultCDORepositoryConfigurationManager.this.adminRepository) {
                        try {
                            DefaultCDORepositoryConfigurationManager.this.initializeCatalog();
                        }
                        finally {
                            container.removeListener((IListener)this);
                        }
                    }
                }
            });
            this.securityManager = SecurityManagerUtil.getSecurityManager((IRepository)this.adminRepository);
            if (this.securityManager == null) {
                return;
            }
        }
        this.requireSecurityManager().modify(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                boolean firstTime;
                CDOTransaction initialTransaction = (CDOTransaction)realm.cdoView();
                boolean bl = firstTime = !initialTransaction.hasResource(DefaultCDORepositoryConfigurationManager.this.catalogPath);
                if (firstTime) {
                    CDOResource resource = initialTransaction.createResource(DefaultCDORepositoryConfigurationManager.this.catalogPath);
                    DefaultCDORepositoryConfigurationManager.this.catalog = DefaultCDORepositoryConfigurationManager.this.createCatalog(resource, realm);
                    OM.LOG.info("Repository catalog created in " + DefaultCDORepositoryConfigurationManager.this.catalogPath);
                } else {
                    CDOResource resource = initialTransaction.getResource(DefaultCDORepositoryConfigurationManager.this.catalogPath);
                    DefaultCDORepositoryConfigurationManager.this.catalog = (RepositoryCatalog)resource.getContents().get(0);
                    OM.LOG.info("Repository catalog loaded from " + DefaultCDORepositoryConfigurationManager.this.catalogPath);
                }
            }
        });
        this.requireSecurityManager().read(new ISecurityManager.RealmOperation(){

            public void execute(Realm realm) {
                DefaultCDORepositoryConfigurationManager.this.catalog = (RepositoryCatalog)realm.cdoView().getObject((EObject)DefaultCDORepositoryConfigurationManager.this.catalog);
            }
        });
        if (this.catalog != null) {
            OM.LOG.info("Starting managed repositories.");
            for (RepositoryConfiguration configuration : this.catalog.getRepositories()) {
                try {
                    this.startRepository(configuration);
                }
                catch (Exception e) {
                    OM.LOG.error((Throwable)e);
                }
            }
            OM.LOG.info("Managed repositories started.");
        }
    }

    private RepositoryCatalog createCatalog(CDOResource resource, Realm realm) {
        RepositoryCatalog result = CatalogFactory.eINSTANCE.createRepositoryCatalog();
        resource.getContents().add((Object)result);
        Role serverAdmin = realm.addRole("Server Administration");
        FilterPermission catalogAccess = SecurityFactory.eINSTANCE.createFilterPermission(Access.READ, new PermissionFilter[]{SecurityFactory.eINSTANCE.createResourceFilter(resource.getPath())});
        serverAdmin.getPermissions().add((Object)catalogAccess);
        realm.getUser("Administrator").getRoles().add((Object)serverAdmin);
        return result;
    }

    protected static interface CatalogOperation<T> {
        public T execute(RepositoryCatalog var1) throws Exception;
    }

    public static class Factory
    extends CDORepositoryConfigurationManager.Factory {
        public static final String TYPE = "default";

        public Factory() {
            super(TYPE);
        }

        @Override
        public CDORepositoryConfigurationManager create(String description) throws ProductCreationException {
            DefaultCDORepositoryConfigurationManager result = new DefaultCDORepositoryConfigurationManager();
            result.setCatalogPath(description);
            return result;
        }
    }
}

