/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.search.mixin;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.ITclMixinElement;

public class TclMixinModel {
    public static final String NAMESPACE_PRERIX = "@";
    public static final String PACKAGE_PRERIX = "&";
    private static TclMixinModel instance;
    private final Map<IScriptProject, MixinModel> instances = new HashMap<IScriptProject, MixinModel>();

    public static synchronized TclMixinModel getInstance() {
        if (instance == null) {
            instance = new TclMixinModel();
        }
        return instance;
    }

    private TclMixinModel() {
    }

    private void bindObjectInitialization(MixinModel model) {
        model.addObjectInitializeListener(new MixinModel.IMixinObjectInitializeListener(){

            public void initialize(IMixinElement element, Object object, ISourceModule module) {
                if (object != null && object instanceof ITclMixinElement) {
                    ((ITclMixinElement)object).initialize(element, module, TclMixinModel.this);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MixinModel getMixin(IScriptProject project) {
        Map<IScriptProject, MixinModel> map = this.instances;
        synchronized (map) {
            MixinModel mixinModel = this.instances.get(project);
            if (mixinModel == null) {
                mixinModel = new MixinModel(DLTKLanguageManager.getLanguageToolkit((String)"org.eclipse.dltk.tcl.core.nature"), project);
                this.instances.put(project, mixinModel);
                this.bindObjectInitialization(mixinModel);
            }
            return mixinModel;
        }
    }
}

