/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui.corebuild;

import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CoreBuildTab
extends AbstractLaunchConfigurationTab {
    public static final String TAB_ID = "org.eclipse.cdt.cdi.launch.buildSettingsTab";
    private Composite container;
    private IProject activeProject;
    private ILaunchConfigurationTab activeTab;

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.container.setLayout((Layout)layout);
        this.setControl((Control)this.container);
        this.defaultTab();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.activeTab != null) {
            this.activeTab.setDefaults(configuration);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        IProject project = this.getProject(configuration);
        if (project == null) {
            this.defaultTab();
        } else if (!project.equals((Object)this.activeProject)) {
            this.activeProject = project;
            this.activeTab = this.getTab(project);
            if (this.activeTab == null) {
                this.defaultTab();
            } else {
                Control[] controlArray = this.container.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.dispose();
                    ++n2;
                }
                this.activeTab.createControl(this.container);
                this.activeTab.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            }
        }
        if (this.activeTab != null) {
            this.activeTab.setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
            this.activeTab.initializeFrom(configuration);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.activeTab != null) {
            this.activeTab.performApply(configuration);
        }
    }

    public String getName() {
        return LaunchMessages.CoreBuildTab_Build;
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_CORE_BUILD_TAB);
    }

    private IProject getProject(ILaunchConfiguration configuration) {
        try {
            IResource[] iResourceArray = configuration.getMappedResources();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IProject) {
                    return (IProject)resource;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e.getStatus());
        }
        return null;
    }

    private void defaultTab() {
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        Composite comp = new Composite(this.container, 0);
        comp.setLayout((Layout)new GridLayout());
        Label label = new Label(comp, 0);
        label.setText(LaunchMessages.CoreBuildTab_NoOptions);
        this.activeTab = null;
    }

    private ILaunchConfigurationTab getTab(IProject project) {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.cdt.launch", "coreBuildTab");
            String[] natures = project.getDescription().getNatureIds();
            IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String nature = element.getAttribute("nature");
                if (nature != null) {
                    String[] stringArray = natures;
                    int n3 = natures.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String n5 = stringArray[n4];
                        if (n5.equals(nature)) {
                            return (ILaunchConfigurationTab)element.createExecutableExtension("tabClass");
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LaunchUIPlugin.log(e.getStatus());
        }
        return null;
    }

    public String getId() {
        return TAB_ID;
    }
}

