/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.core.runtime.CoreException;

public class ExecStaticAssert
implements ICPPExecution {
    public static final ICPPEvaluation FAILED = new EvalFixed(ProblemType.STATIC_ASSERT_FAILED, IASTExpression.ValueCategory.PRVALUE, IntegralValue.STATIC_ASSERT_FAILED_ERROR);
    public static final ExecStaticAssert FAILED_INSTANCE = new ExecStaticAssert(null);
    private final ICPPEvaluation fCondition;

    public ExecStaticAssert(ICPPEvaluation condition) {
        this.fCondition = condition;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation condition;
        ICPPEvaluation iCPPEvaluation = condition = this.fCondition == null ? null : this.fCondition.instantiate(context, maxDepth);
        if (condition == this.fCondition) {
            return this;
        }
        return new ExecStaticAssert(condition);
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.fCondition == null || !EvalUtil.conditionExprSatisfied(this.fCondition, record, context)) {
            return FAILED_INSTANCE;
        }
        return null;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 20;
        buffer.putShort(firstBytes);
        buffer.marshalEvaluation(this.fCondition, includeValue);
    }

    public static ICPPExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        ICPPEvaluation condition = buffer.unmarshalEvaluation();
        return new ExecStaticAssert(condition);
    }
}

