/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.DefaultMethodInterceptor;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.core.eval.InvocationEvaluatorInterceptor;
import org.eclipse.wb.internal.core.eval.evaluators.AnonymousEvaluationError;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.AstReflectionUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class InvocationEvaluator
implements IExpressionEvaluator {
    public static final String SUPER_MI_KEY = "SUPER_MI_KEY";
    private static TypeCache<TypeCache.SimpleKey> PROXY_CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.WEAK);

    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if (expression instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)expression;
            return this.evaluate(context, invocation);
        }
        if (expression instanceof SuperMethodInvocation) {
            SuperMethodInvocation invocation = (SuperMethodInvocation)expression;
            return this.evaluate(context, invocation);
        }
        if (expression instanceof ClassInstanceCreation) {
            ClassInstanceCreation creation = (ClassInstanceCreation)expression;
            return this.evaluate(context, creation, typeBinding, typeQualifiedName);
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private Object evaluate(EvaluationContext context, MethodInvocation invocation) throws Exception {
        MethodDeclaration localMethod;
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(invocation);
        Assert.isNotNull((Object)methodBinding);
        Expression invocationExpression = invocation.getExpression();
        if (AstNodeUtils.isStatic(methodBinding)) {
            ITypeBinding targetTypeBinding = methodBinding.getDeclaringClass();
            Assert.isNotNull2((Object)targetTypeBinding, (String)"{0} {1}", (Object[])new Object[]{invocation, methodBinding});
            return InvocationEvaluator.invokeMethod(context, null, targetTypeBinding, invocation, methodBinding);
        }
        if (invocationExpression == null && (localMethod = AstNodeUtils.getLocalMethodDeclaration(invocation)) != null) {
            return this.evaluateLocalMethodInvocation(context, localMethod, invocation);
        }
        Object expressionValue = AstEvaluationEngine.evaluate(context, invocationExpression);
        Assert.isTrueException((expressionValue != null ? 1 : 0) != 0, (int)312, (Object[])new Object[]{context.getSource((ASTNode)invocation)});
        return InvocationEvaluator.invokeMethod(context, expressionValue, null, invocation, methodBinding);
    }

    private Object evaluateLocalMethodInvocation(EvaluationContext context, MethodDeclaration methodDeclaration, MethodInvocation invocation) throws Exception {
        List<Statement> statements;
        Javadoc javadoc = methodDeclaration.getJavadoc();
        if (javadoc != null) {
            for (TagElement tag : DomGenerics.tags(javadoc)) {
                List<ASTNode> fragments;
                if (!StringUtils.equals((CharSequence)tag.getTagName(), (CharSequence)"@wbp.eval.method.return") || (fragments = DomGenerics.fragments(tag)).isEmpty() || !(fragments.get(0) instanceof TextElement)) continue;
                TextElement textElement = (TextElement)tag.fragments().get(0);
                String returnSource = textElement.getText().trim();
                return this.evaluateInvocationSourceExpression(context, methodDeclaration, invocation, returnSource);
            }
        }
        if (methodDeclaration.parameters().isEmpty() && (statements = DomGenerics.statements(methodDeclaration)).size() == 1 && statements.get(0) instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
            try {
                return AstEvaluationEngine.evaluate(context, returnStatement.getExpression());
            }
            catch (Throwable e) {
                throw new DesignerException(306, e, new String[]{context.getSource((ASTNode)invocation)});
            }
        }
        throw new DesignerException(306, new String[]{context.getSource((ASTNode)invocation)});
    }

    private Object evaluateInvocationSourceExpression(EvaluationContext context, MethodDeclaration methodDeclaration, MethodInvocation invocation, String expressionSource) throws Exception {
        int index = -1;
        List<SingleVariableDeclaration> parameters = DomGenerics.parameters(methodDeclaration);
        for (SingleVariableDeclaration parameter : parameters) {
            if (!parameter.getName().getIdentifier().equals(expressionSource)) continue;
            index = parameters.indexOf(parameter);
            break;
        }
        Assert.isTrue((index != -1 ? 1 : 0) != 0, (String)"Can not evaluate %s for %s invocation of %s", (Object[])new Object[]{expressionSource, invocation, methodDeclaration});
        return AstEvaluationEngine.evaluate(context, DomGenerics.arguments(invocation).get(index));
    }

    private Object evaluate(EvaluationContext context, SuperMethodInvocation invocation) throws Exception {
        Object thisValue = AstEvaluationEngine.evaluate(context, null);
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(invocation);
        Assert.isNotNull((Object)methodBinding);
        Method method = InvocationEvaluator.getReflectionMethod(thisValue.getClass(), methodBinding);
        Object[] argumentValues = InvocationEvaluator.getArgumentValues(context, DomGenerics.arguments(invocation), true);
        try {
            invocation.getRoot().setProperty(SUPER_MI_KEY, (Object)Boolean.TRUE);
            return ReflectionUtils.invokeMethod((Method)method, (Object)thisValue, (Object[])argumentValues);
        }
        catch (Throwable e) {
            throw new DesignerException(309, e, new String[]{context.getSource((ASTNode)invocation), method.toString(), InvocationEvaluator.getArguments_toString(argumentValues), AstEvaluationEngine.getUserStackTrace(e)});
        }
    }

    private Object evaluate(EvaluationContext context, ClassInstanceCreation creation, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        IMethodBinding methodBinding = AstNodeUtils.getCreationBinding(creation);
        Assert.isNotNull((Object)methodBinding);
        if (typeBinding.isMember() && !AstNodeUtils.isStatic(typeBinding)) {
            return null;
        }
        List<Expression> argumentExpressions = DomGenerics.arguments(creation);
        Object[] argumentValues = InvocationEvaluator.getArgumentValues(context, argumentExpressions, true);
        argumentValues = InvocationEvaluator.updateForVarArgs(context, methodBinding, argumentValues);
        if (typeBinding.isAnonymous()) {
            return InvocationEvaluator.createAnonymousObject(context, creation, typeBinding, methodBinding, argumentValues);
        }
        Class<?> clazz = InvocationEvaluator.getTypeBindingClass(context, typeBinding);
        Constructor<?> constructor = InvocationEvaluator.getReflectionConstructor(clazz, methodBinding);
        try {
            Object result = InvocationEvaluator.tryInterceptors(context, creation, typeBinding, clazz, constructor, argumentValues);
            if (result != AstEvaluationEngine.UNKNOWN) {
                return result;
            }
            InvocationEvaluator.fixThisExpressionArguments(constructor, argumentExpressions, argumentValues);
            return ReflectionUtils.newInstance(constructor, (Object[])argumentValues);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getCause();
            }
            InvocationEvaluator.throwAlternativeException(e);
            throw InvocationEvaluator.createConstructorProblemException(context, creation, argumentValues, constructor, e);
        }
    }

    private static Object createAnonymousObject(EvaluationContext context, ClassInstanceCreation creation, ITypeBinding typeBinding, IMethodBinding methodBinding, Object[] argumentValues) throws Exception {
        ITypeBinding typeBindingConcrete = typeBinding;
        while (typeBindingConcrete.isAnonymous() || AstNodeUtils.isAbstract(typeBindingConcrete)) {
            typeBindingConcrete = typeBindingConcrete.getSuperclass();
        }
        for (InvocationEvaluatorInterceptor interceptor : InvocationEvaluator.getInterceptors()) {
            Object result = interceptor.evaluateAnonymous(context, creation, typeBinding, typeBindingConcrete, methodBinding, argumentValues);
            if (result == AstEvaluationEngine.UNKNOWN) continue;
            return result;
        }
        if (InvocationEvaluator.isAnonymousEventListener(typeBinding)) {
            return AstEvaluationEngine.createAnonymousInstance(context, methodBinding, argumentValues);
        }
        throw new AnonymousEvaluationError();
    }

    private static boolean isAnonymousEventListener(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return false;
        }
        String name = typeBinding.getName();
        if (name.endsWith("Listener") || name.endsWith("Handler")) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding intf = iTypeBindingArray[n2];
            if (InvocationEvaluator.isAnonymousEventListener(intf)) {
                return true;
            }
            ++n2;
        }
        return InvocationEvaluator.isAnonymousEventListener(typeBinding.getSuperclass());
    }

    public static Object createAnonymousInstance(EvaluationContext context, IMethodBinding methodBinding, Object[] argumentValues) throws Exception {
        ITypeBinding typeBinding = methodBinding.getDeclaringClass();
        Class<?> creationClass = InvocationEvaluator.getTypeBindingClass(context, typeBinding.getSuperclass());
        Type[] creationInterfaces = InvocationEvaluator.getClasses(context, typeBinding.getInterfaces());
        Class<?>[] argumentTypes = InvocationEvaluator.getClasses(context, methodBinding.getParameterTypes());
        ClassLoader proxyClassLoader = context.getClassLoader();
        TypeCache.SimpleKey proxyKey = new TypeCache.SimpleKey(creationClass, (Class[])creationInterfaces);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().subclass(creationClass).implement(creationInterfaces).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)SuperMethodCall.INSTANCE).method((ElementMatcher)ElementMatchers.isAbstract()).intercept((Implementation)DefaultMethodInterceptor.INSTANCE);
        return PROXY_CACHE.findOrInsert(proxyClassLoader, (Object)proxyKey, () -> InvocationEvaluator.lambda$0((DynamicType.Builder)builder, proxyClassLoader)).getConstructor(argumentTypes).newInstance(argumentValues);
    }

    private static void throwAlternativeException(Throwable e) {
        List<InvocationEvaluatorInterceptor> interceptors = InvocationEvaluator.getInterceptors();
        for (InvocationEvaluatorInterceptor interceptor : interceptors) {
            Throwable result = interceptor.rewriteException(e);
            if (!(result instanceof Error)) continue;
            throw (Error)result;
        }
    }

    private static Object tryInterceptors(EvaluationContext context, ClassInstanceCreation creation, ITypeBinding typeBinding, Class<?> clazz, Constructor<?> explicitConstructor, Object[] argumentValues) throws Exception {
        for (InvocationEvaluatorInterceptor interceptor : InvocationEvaluator.getInterceptors()) {
            Object result = interceptor.evaluate(context, creation, typeBinding, clazz, explicitConstructor, argumentValues);
            if (result == AstEvaluationEngine.UNKNOWN) continue;
            return result;
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static void fixThisExpressionArguments(Constructor<?> constructor, List<Expression> argumentExpressions, Object[] argumentValues) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Assert.isTrue((parameterTypes.length == argumentValues.length ? 1 : 0) != 0, (String)"Incompatible count of parameters %s and arguments %s", (Object[])new Object[]{parameterTypes.length, argumentValues.length});
        int i = 0;
        while (i < parameterTypes.length) {
            if (i >= argumentExpressions.size()) break;
            if (argumentExpressions.get(i) instanceof ThisExpression) {
                Class<?> parameterType = parameterTypes[i];
                Object argument = argumentValues[i];
                if (argument != null && !parameterType.isAssignableFrom(argument.getClass())) {
                    argumentValues[i] = null;
                }
            }
            ++i;
        }
    }

    private static Object invokeMethod(EvaluationContext context, Object targetValue, ITypeBinding targetTypeBinding, MethodInvocation invocation, IMethodBinding methodBinding) throws Exception {
        Class<?> clazz = targetTypeBinding != null ? InvocationEvaluator.getTypeBindingClass(context, targetTypeBinding) : targetValue.getClass();
        Object[] argumentValues = InvocationEvaluator.getArgumentValues(context, DomGenerics.arguments(invocation), false);
        argumentValues = InvocationEvaluator.updateForVarArgs(context, methodBinding, argumentValues);
        Method method = InvocationEvaluator.getReflectionMethod(clazz, methodBinding);
        Object result = InvocationEvaluator.tryInterceptors(context, invocation, methodBinding, clazz, method, argumentValues);
        if (result != AstEvaluationEngine.UNKNOWN) {
            return result;
        }
        try {
            return ReflectionUtils.invokeMethod((Method)method, (Object)targetValue, (Object[])argumentValues);
        }
        catch (Throwable e) {
            throw new DesignerException(308, e, new String[]{context.getSource((ASTNode)invocation), method.toString(), InvocationEvaluator.getArguments_toString(argumentValues)});
        }
    }

    private static Object tryInterceptors(EvaluationContext context, MethodInvocation invocation, IMethodBinding methodBinding, Class<?> clazz, Method method, Object[] argumentValues) {
        for (InvocationEvaluatorInterceptor interceptor : InvocationEvaluator.getInterceptors()) {
            Object result = interceptor.evaluate(context, invocation, methodBinding, clazz, method, argumentValues);
            if (result == AstEvaluationEngine.UNKNOWN) continue;
            return result;
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static Class<?> getTypeBindingClass(EvaluationContext context, ITypeBinding typeBinding) throws Exception {
        ClassLoader classLoader = context.getClassLoader();
        return AstReflectionUtils.getClass(classLoader, typeBinding);
    }

    private static Class<?>[] getClasses(EvaluationContext context, ITypeBinding[] typeBindings) throws Exception {
        Class[] classes = new Class[typeBindings.length];
        int i = 0;
        while (i < typeBindings.length) {
            ITypeBinding typeBinding = typeBindings[i];
            classes[i] = InvocationEvaluator.getTypeBindingClass(context, typeBinding);
            ++i;
        }
        return classes;
    }

    private static Method getReflectionMethod(Class<?> clazz, IMethodBinding binding) throws Exception {
        Method method;
        String signature = AstNodeUtils.getMethodSignature(binding);
        for (InvocationEvaluatorInterceptor interceptor : InvocationEvaluator.getInterceptors()) {
            method = interceptor.resolveMethod(clazz, signature);
            if (method == null) continue;
            return method;
        }
        method = AstReflectionUtils.getMethod(clazz, binding);
        Assert.isNotNull2((Object)method, (String)"Method {0} not found in {1}", (Object[])new Object[]{signature, clazz});
        return method;
    }

    private static Constructor<?> getReflectionConstructor(Class<?> clazz, IMethodBinding binding) throws Exception {
        IMethodBinding genericBinding;
        String signature = AstNodeUtils.getMethodSignature(binding);
        Constructor constructor = ReflectionUtils.getConstructorBySignature(clazz, (String)signature);
        if (constructor == null && (genericBinding = binding.getMethodDeclaration()) != binding) {
            String genericSignature = AstNodeUtils.getMethodSignature(genericBinding);
            constructor = ReflectionUtils.getConstructorByGenericSignature(clazz, (String)genericSignature);
        }
        Assert.isNotNull2((Object)constructor, (String)"No constructor {0} in {1}.", (Object[])new Object[]{signature, clazz});
        return constructor;
    }

    private static Object[] getArgumentValues(EvaluationContext context, List<Expression> arguments, boolean forConstructor) throws Exception {
        int argumentCount = arguments.size();
        Object[] argumentValues = new Object[argumentCount];
        int i = 0;
        while (i < argumentCount) {
            Expression argument = arguments.get(i);
            try {
                argumentValues[i] = AstEvaluationEngine.evaluate(context, argument);
            }
            catch (Error e) {
                if (forConstructor && AnonymousEvaluationError.is(e)) {
                    argumentValues[i] = null;
                }
                throw e;
            }
            ++i;
        }
        return argumentValues;
    }

    private static Object[] updateForVarArgs(EvaluationContext context, IMethodBinding methodBinding, Object[] values) throws Exception {
        ClassLoader classLoader = context.getClassLoader();
        return AstReflectionUtils.updateForVarArgs(classLoader, methodBinding, values);
    }

    private static DesignerException createConstructorProblemException(EvaluationContext context, ClassInstanceCreation creation, Object[] argumentValues, Constructor<?> constructor, Throwable e) throws DesignerException {
        return new DesignerException(307, e, new String[]{context.getSource((ASTNode)creation), ReflectionUtils.getShortConstructorString(constructor), InvocationEvaluator.getArguments_toString(argumentValues), AstEvaluationEngine.getUserStackTrace(e)});
    }

    public static String getArguments_toString(Object[] arguments) {
        return (String)ExecutionUtils.runObjectIgnore(() -> ArrayUtils.toString((Object)arguments), (Object)"<Exception during arguments.toString()>");
    }

    private static List<InvocationEvaluatorInterceptor> getInterceptors() {
        return ExternalFactoriesHelper.getElementsInstances(InvocationEvaluatorInterceptor.class, (String)"org.eclipse.wb.core.invocationEvaluatorInterceptors", (String)"interceptor");
    }

    private static /* synthetic */ Class lambda$0(DynamicType.Builder builder, ClassLoader classLoader) throws Exception {
        return builder.make().load(classLoader).getLoaded();
    }
}

