/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.steps;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.steps.AbstractPeerStep;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;

public class ResumeProcessStep
extends AbstractPeerStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null || channel.getState() != 1) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing or closed channel"));
        }
        IProcesses.ProcessContext processContext = (IProcesses.ProcessContext)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_context", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (processContext == null) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing process context"));
        }
    }

    public void execute(final IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, final ICallback callback) {
        if (Protocol.isDispatchThread()) {
            this.internalExecute(context, data, fullQualifiedId, monitor, callback);
        } else {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ResumeProcessStep.this.internalExecute(context, data, fullQualifiedId, monitor, callback);
                }
            });
        }
    }

    protected void internalExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, final IProgressMonitor monitor, final ICallback callback) {
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        IProcesses.ProcessContext processContext = (IProcesses.ProcessContext)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_context", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        IRunControl runControl = (IRunControl)channel.getRemoteService(IRunControl.class);
        String svcProcessesName = (String)StepperAttributeUtil.getProperty((String)"services.processes.name", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if ("ProcessesV1".equals(svcProcessesName)) {
            callback.done((Object)this, Status.OK_STATUS);
        } else if (runControl != null) {
            boolean stopAtEntry = StepperAttributeUtil.getBooleanProperty((String)"org.eclipse.tcf.te.tcf.processes.core.process_stop_at_entry", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
            if (!stopAtEntry) {
                runControl.getContext(processContext.getID(), new IRunControl.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                        ProgressHelper.worked((IProgressMonitor)monitor, (int)5);
                        if (!ProgressHelper.isCancelOrError((Object)((Object)ResumeProcessStep.this), (IStatus)StatusHelper.getStatus((Throwable)error), (IProgressMonitor)monitor, (ICallback)callback)) {
                            context.resume(0, 1, new IRunControl.DoneCommand(){

                                public void doneCommand(IToken token, Exception error) {
                                    callback.done((Object)ResumeProcessStep.this, StatusHelper.getStatus((Throwable)error));
                                }
                            });
                        }
                    }
                });
            } else {
                callback.done((Object)this, Status.OK_STATUS);
            }
        } else {
            callback.done((Object)this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing run control service"));
        }
    }
}

