/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.util.TCFTask;

public final class TCFVirtualOutputStream
extends OutputStream {
    private static final int MAX_QUEUE = 32;
    private final IChannel channel;
    private final IStreams streams;
    private final String id;
    private final boolean send_eos;
    private final Runnable on_close;
    private final byte[] buf = new byte[1];
    private final HashSet<IToken> queue = new HashSet();
    private final LinkedList<Exception> errors = new LinkedList();
    private final HashSet<Runnable> wait_list = new HashSet();
    private boolean closed;

    public TCFVirtualOutputStream(IChannel channel, String id, boolean send_eos, Runnable on_close) throws IOException {
        this.channel = channel;
        this.streams = channel.getRemoteService(IStreams.class);
        if (this.streams == null) {
            throw new IOException("Streams service not available");
        }
        this.id = id;
        this.send_eos = send_eos;
        this.on_close = on_close;
    }

    @Override
    public synchronized void write(final byte[] b, final int off, final int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        new TCFTask<Object>(){

            @Override
            public void run() {
                if (TCFVirtualOutputStream.this.queue.size() > 32) {
                    TCFVirtualOutputStream.this.wait_list.add(this);
                    return;
                }
                if (TCFVirtualOutputStream.this.errors.size() > 0) {
                    this.error((Throwable)TCFVirtualOutputStream.this.errors.removeFirst());
                    return;
                }
                TCFVirtualOutputStream.this.queue.add(TCFVirtualOutputStream.this.streams.write(TCFVirtualOutputStream.this.id, b, off, len, new IStreams.DoneWrite(){

                    @Override
                    public void doneWrite(IToken token, Exception error) {
                        if (error != null) {
                            TCFVirtualOutputStream.this.errors.add(error);
                        }
                        TCFVirtualOutputStream.this.queue.remove(token);
                        if (TCFVirtualOutputStream.this.wait_list.size() > 0) {
                            Runnable[] list = TCFVirtualOutputStream.this.wait_list.toArray(new Runnable[TCFVirtualOutputStream.this.wait_list.size()]);
                            TCFVirtualOutputStream.this.wait_list.clear();
                            Runnable[] runnableArray = list;
                            int n = list.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Runnable r = runnableArray[n2];
                                r.run();
                                ++n2;
                            }
                        }
                    }
                }));
                this.done(this);
            }
        }.getIO();
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.buf[0] = (byte)b;
        this.write(this.buf, 0, 1);
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        new TCFTask<Object>(){

            @Override
            public void run() {
                if (TCFVirtualOutputStream.this.queue.size() > 0) {
                    TCFVirtualOutputStream.this.wait_list.add(this);
                } else if (TCFVirtualOutputStream.this.errors.size() > 0) {
                    this.error((Throwable)TCFVirtualOutputStream.this.errors.removeFirst());
                } else {
                    this.done(this);
                }
            }
        }.getIO();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.send_eos) {
            new TCFTask<Object>(){

                @Override
                public void run() {
                    TCFVirtualOutputStream.this.streams.eos(TCFVirtualOutputStream.this.id, new IStreams.DoneEOS(){

                        @Override
                        public void doneEOS(IToken token, Exception error) {
                            if (error != null && TCFVirtualOutputStream.this.channel.getState() != 2) {
                                this.error(error);
                            } else {
                                this.done(this);
                            }
                        }
                    });
                }
            }.getIO();
        }
        new TCFTask<Object>(){

            @Override
            public void run() {
                TCFVirtualOutputStream.this.streams.disconnect(TCFVirtualOutputStream.this.id, new IStreams.DoneDisconnect(){

                    @Override
                    public void doneDisconnect(IToken token, Exception error) {
                        if (error != null && TCFVirtualOutputStream.this.channel.getState() != 2) {
                            this.error(error);
                        } else {
                            if (TCFVirtualOutputStream.this.on_close != null) {
                                TCFVirtualOutputStream.this.on_close.run();
                            }
                            this.done(this);
                        }
                    }
                });
            }
        }.getIO();
    }
}

