/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.console;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.internal.console.Activator;
import org.eclipse.remote.internal.console.ConsoleMessages;
import org.eclipse.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TerminalConsoleSettingsDialog
extends Dialog {
    private static final String CONNECTION_TYPE = "connectionType";
    private static final String CONNECTION_NAME = "connectionName";
    private static final String ENCODING = "encoding";
    private RemoteConnectionWidget remoteConnWidget;
    private Combo encodingCombo;
    private String selectedEncoding;

    public TerminalConsoleSettingsDialog(IShellProvider parentShell) {
        this(parentShell.getShell());
    }

    public TerminalConsoleSettingsDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        IRemoteServicesManager manager = Activator.getService(IRemoteServicesManager.class);
        List connTypes = manager.getConnectionTypesSupporting(new Class[]{IRemoteCommandShellService.class, IRemoteProcessService.class});
        this.remoteConnWidget = new RemoteConnectionWidget(composite, 0, null, 0, connTypes);
        IDialogSettings settings = this.getDialogSettings();
        String initialId = settings.get(CONNECTION_TYPE);
        String initialName = settings.get(CONNECTION_NAME);
        if (initialId != null && initialName != null) {
            this.remoteConnWidget.setConnection(initialId, initialName);
        }
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.remoteConnWidget.setLayoutData((Object)gd);
        this.remoteConnWidget.addSelectionListener((SelectionListener)new ValidationSelectionListener());
        Label encodingLabel = new Label(composite, 0);
        encodingLabel.setLayoutData((Object)new GridData());
        encodingLabel.setText(ConsoleMessages.ENCODING);
        this.encodingCombo = new Combo(composite, 8);
        this.encodingCombo.setLayoutData((Object)new GridData(768));
        int i = 0;
        String initialEncoding = settings.get(ENCODING);
        if (initialEncoding == null) {
            initialEncoding = Charset.defaultCharset().name();
        }
        for (String encoding : this.getEncodings()) {
            this.encodingCombo.add(encoding);
            if (encoding.equals(initialEncoding)) {
                this.selectedEncoding = encoding;
                this.encodingCombo.select(i);
            }
            ++i;
        }
        this.encodingCombo.addSelectionListener((SelectionListener)new ValidationSelectionListener());
        return composite;
    }

    private List<String> getEncodings() {
        ArrayList<String> encodings = new ArrayList<String>(2);
        encodings.add("ISO-8859-1");
        encodings.add("UTF-8");
        String hostEncoding = Charset.defaultCharset().name();
        if (!encodings.contains(hostEncoding)) {
            encodings.add(hostEncoding);
        }
        return encodings;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validateDialog();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ConsoleMessages.SELECT_CONNECTION);
    }

    private void validateDialog() {
        IRemoteConnection connection = this.remoteConnWidget.getConnection();
        this.selectedEncoding = this.encodingCombo.getItem(this.encodingCombo.getSelectionIndex());
        if (connection != null && this.selectedEncoding != null) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnWidget.getConnection();
    }

    public String getEncoding() {
        return this.selectedEncoding;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings result = Activator.getDefault().getDialogSettings().getSection(TerminalConsoleSettingsDialog.class.getName());
        if (result == null) {
            result = Activator.getDefault().getDialogSettings().addNewSection(TerminalConsoleSettingsDialog.class.getName());
        }
        return result;
    }

    public int open() {
        int rc = super.open();
        if (rc == 0) {
            IDialogSettings settings = this.getDialogSettings();
            IRemoteConnection connection = this.getRemoteConnection();
            settings.put(CONNECTION_TYPE, connection.getConnectionType().getId());
            settings.put(CONNECTION_NAME, connection.getName());
            settings.put(ENCODING, this.getEncoding());
        }
        return rc;
    }

    class ValidationSelectionListener
    implements SelectionListener {
        ValidationSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TerminalConsoleSettingsDialog.this.validateDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TerminalConsoleSettingsDialog.this.validateDialog();
        }
    }
}

