/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.sourcemap;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceIdMap;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePosition;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMap;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMapBuilder;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.TextSectionMapping;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class PositionMapBuilderImpl
implements SourcePositionMapBuilder {
    private final Side userSide = new Side(TextSectionMapping.Direction.DIRECT);
    private final Side vmSide = new Side(TextSectionMapping.Direction.REVERSE);
    private volatile TokenImpl currentToken = new TokenImpl();
    private final SourcePositionMap mapImpl = new SourcePositionMap(){

        @Override
        public SourcePosition translatePosition(VmResourceId id, int line, int column, SourcePositionMap.TranslateDirection direction) {
            if (direction == SourcePositionMap.TranslateDirection.USER_TO_VM) {
                return PositionMapBuilderImpl.this.userSide.transformImpl(id, line, column);
            }
            return PositionMapBuilderImpl.this.vmSide.transformImpl(id, line, column);
        }

        @Override
        public SourcePositionMap.Token getCurrentToken() {
            return PositionMapBuilderImpl.this.currentToken;
        }
    };

    @Override
    public SourcePositionMap getSourcePositionMap() {
        return this.mapImpl;
    }

    @Override
    public SourcePositionMapBuilder.MappingHandle addMapping(SourcePositionMapBuilder.ResourceSection originalSection, SourcePositionMapBuilder.ResourceSection vmSection, TextSectionMapping fromOriginalToVmSectionMapping) throws SourcePositionMapBuilder.CannotAddException {
        RangeAdder originalSideAdder = this.userSide.checkCanAddRange(originalSection);
        RangeAdder vmSideAdder = this.vmSide.checkCanAddRange(vmSection);
        final RangeDeleter originalDeleter = originalSideAdder.commit(fromOriginalToVmSectionMapping, vmSection.getResourceId());
        final RangeDeleter vmDeleter = vmSideAdder.commit(fromOriginalToVmSectionMapping, originalSection.getResourceId());
        this.updateToken();
        return new SourcePositionMapBuilder.MappingHandle(){

            @Override
            public void delete() {
                originalDeleter.delete();
                vmDeleter.delete();
                PositionMapBuilderImpl.this.updateToken();
            }
        };
    }

    private void updateToken() {
        this.currentToken.updated = true;
        this.currentToken = new TokenImpl();
    }

    private static class Range {
        final TextSectionMapping.TextPoint start;
        final TextSectionMapping.TextPoint end;

        static Range create(SourcePositionMapBuilder.ResourceSection resourceSection) {
            return new Range(resourceSection.getStart(), resourceSection.getEnd());
        }

        Range(TextSectionMapping.TextPoint start, TextSectionMapping.TextPoint end) {
            this.start = start;
            this.end = end;
        }

        boolean isEmpty() {
            return this.start.equals(this.end);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Range)) {
                return false;
            }
            Range other = (Range)obj;
            return this.start.equals(other.start);
        }

        public int hashCode() {
            return this.start.hashCode();
        }

        public String toString() {
            return "[" + this.start + " - " + this.end + "]";
        }
    }

    private static interface RangeAdder {
        public RangeDeleter commit(TextSectionMapping var1, VmResourceId var2);
    }

    private static interface RangeDeleter {
        public void delete();
    }

    private static class RangeGroup {
        int emptyRangesAtStart = 0;
        RangeMapping nonEmptyRangeMapping = null;

        private RangeGroup() {
        }
    }

    private static class RangeMapping {
        final Range sourceRange;
        final VmResourceId targetResourceId;
        final TextSectionMapping mapTable;

        RangeMapping(Range sourceRange, VmResourceId targetResourceId, TextSectionMapping mapTable) {
            this.sourceRange = sourceRange;
            this.targetResourceId = targetResourceId;
            this.mapTable = mapTable;
        }
    }

    private static class ResourceData {
        private final NavigableMap<TextSectionMapping.TextPoint, RangeGroup> rangeMap = new TreeMap<TextSectionMapping.TextPoint, RangeGroup>();

        private ResourceData() {
        }

        SourcePosition transform(TextSectionMapping.TextPoint point, TextSectionMapping.Direction direction) {
            RangeGroup structure = this.findRange(point);
            if (structure == null) {
                return null;
            }
            TextSectionMapping.TextPoint resPoint = structure.nonEmptyRangeMapping.mapTable.transform(point, direction);
            return new SourcePosition(structure.nonEmptyRangeMapping.targetResourceId, resPoint.getLine(), resPoint.getColumn());
        }

        void checkCanAddRange(Range range) throws SourcePositionMapBuilder.CannotAddException {
            Map.Entry<TextSectionMapping.TextPoint, RangeGroup> previousEntry = this.rangeMap.lowerEntry(range.end);
            if (previousEntry != null) {
                TextSectionMapping.TextPoint previousRangeStart = previousEntry.getKey();
                RangeGroup previousRangeGroup = previousEntry.getValue();
                TextSectionMapping.TextPoint previousRangeEnd = previousRangeGroup.nonEmptyRangeMapping == null ? previousRangeStart : previousRangeGroup.nonEmptyRangeMapping.sourceRange.end;
                if (previousRangeEnd.compareTo(range.start) > 0) {
                    throw new SourcePositionMapBuilder.CannotAddException("Ranges overlaps: " + range + " with " + new Range(previousRangeStart, previousRangeEnd));
                }
            }
        }

        void addRange(Range range, TextSectionMapping mapTable, VmResourceId destinationResource) {
            RangeGroup structure = (RangeGroup)BasicUtil.getSafe(this.rangeMap, (Object)range.start);
            if (structure == null) {
                structure = new RangeGroup();
                this.rangeMap.put(range.start, structure);
            }
            if (range.isEmpty()) {
                ++structure.emptyRangesAtStart;
            } else {
                if (structure.nonEmptyRangeMapping != null) {
                    throw new RuntimeException();
                }
                structure.nonEmptyRangeMapping = new RangeMapping(range, destinationResource, mapTable);
            }
        }

        boolean isEmpty() {
            return this.rangeMap.isEmpty();
        }

        public void removeRange(Range range) {
            RangeGroup rangeGroup = (RangeGroup)this.rangeMap.get(range.start);
            if (range.isEmpty()) {
                if (rangeGroup.emptyRangesAtStart <= 0) {
                    throw new IllegalStateException();
                }
                --rangeGroup.emptyRangesAtStart;
            } else {
                if (rangeGroup.nonEmptyRangeMapping == null || !range.equals(rangeGroup.nonEmptyRangeMapping.sourceRange)) {
                    throw new IllegalStateException();
                }
                rangeGroup.nonEmptyRangeMapping = null;
            }
            if (rangeGroup.nonEmptyRangeMapping == null && rangeGroup.emptyRangesAtStart == 0) {
                this.rangeMap.remove(range.start);
            }
        }

        private RangeGroup findRange(TextSectionMapping.TextPoint point) {
            Map.Entry<TextSectionMapping.TextPoint, RangeGroup> previousEntry = this.rangeMap.floorEntry(point);
            if (previousEntry == null) {
                return null;
            }
            RangeMapping nonEmptyRangeMapping = previousEntry.getValue().nonEmptyRangeMapping;
            if (nonEmptyRangeMapping == null) {
                return null;
            }
            if (point.compareTo(nonEmptyRangeMapping.sourceRange.end) >= 0) {
                return null;
            }
            return previousEntry.getValue();
        }
    }

    private static class Side {
        private final VmResourceIdMap<ResourceData> resourceIdToData = new VmResourceIdMap();
        private final TextSectionMapping.Direction direction;

        Side(TextSectionMapping.Direction direction) {
            this.direction = direction;
        }

        SourcePosition transformImpl(VmResourceId id, int line, int column) {
            TextSectionMapping.TextPoint originalPoint;
            SourcePosition resultPosition;
            ResourceData resourceData = this.resourceIdToData.get(id);
            if (resourceData != null && (resultPosition = resourceData.transform(originalPoint = new TextSectionMapping.TextPoint(line, column), this.direction)) != null) {
                return resultPosition;
            }
            return new SourcePosition(id, line, column);
        }

        private RangeAdder checkCanAddRange(SourcePositionMapBuilder.ResourceSection section) throws SourcePositionMapBuilder.CannotAddException {
            final VmResourceId resourceId = section.getResourceId();
            ResourceData data = this.resourceIdToData.get(resourceId);
            final Range range = Range.create(section);
            if (data != null) {
                data.checkCanAddRange(range);
            }
            return new RangeAdder(){

                @Override
                public RangeDeleter commit(TextSectionMapping mapTable, VmResourceId destinationResource) {
                    ResourceData commitData = (ResourceData)resourceIdToData.get(resourceId);
                    if (commitData == null) {
                        commitData = new ResourceData();
                        resourceIdToData.put(resourceId, commitData);
                    }
                    final ResourceData commitDataFinal = commitData;
                    commitDataFinal.addRange(range, mapTable, destinationResource);
                    return new RangeDeleter(){

                        @Override
                        public void delete() {
                            commitDataFinal.removeRange(range);
                            if (commitDataFinal.isEmpty()) {
                                resourceIdToData.remove(resourceId);
                            }
                        }
                    };
                }
            };
        }
    }

    private static class TokenImpl
    implements SourcePositionMap.Token {
        private volatile boolean updated = false;

        private TokenImpl() {
        }

        @Override
        public boolean isUpdated() {
            return this.updated;
        }
    }
}

