/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.type;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartType;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DescriptorTypeVisitor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDescriptorVisitor;
import org.eclipse.tracecompass.internal.tmf.chart.ui.type.IChartTypeDefinition;

public class BarChartTypeDefinition
implements IChartTypeDefinition {
    private static final String BAR_CHART_ICON = "icons/barchart.png";

    @Override
    public ChartType getType() {
        return ChartType.BAR_CHART;
    }

    @Override
    public ImageData getImageData() {
        return new ImageData(this.getClass().getClassLoader().getResourceAsStream(BAR_CHART_ICON));
    }

    @Override
    public boolean checkIfXDescriptorValid(IDataChartDescriptor<?, ?> desc, @Nullable IDataChartDescriptor<?, ?> filter) {
        DescriptorTypeVisitor visitor = new DescriptorTypeVisitor();
        desc.accept((IDescriptorVisitor)visitor);
        if (!visitor.isIndividualType(DescriptorTypeVisitor.DescriptorType.STRING)) {
            return false;
        }
        if (filter != null) {
            return desc.getName().equals(filter.getName());
        }
        return true;
    }

    @Override
    public boolean checkIfYDescriptorValid(IDataChartDescriptor<?, ?> desc, @Nullable IDataChartDescriptor<?, ?> filter) {
        DescriptorTypeVisitor visitor = new DescriptorTypeVisitor();
        desc.accept((IDescriptorVisitor)visitor);
        if (visitor.isIndividualType(DescriptorTypeVisitor.DescriptorType.STRING)) {
            return false;
        }
        return IChartTypeDefinition.filterSameDescriptor(desc, filter);
    }

    @Override
    public boolean checkIfXLogscalePossible(@Nullable IDataChartDescriptor<?, ?> filter) {
        return false;
    }

    @Override
    public boolean checkIfYLogscalePossible(@Nullable IDataChartDescriptor<?, ?> filter) {
        if (filter == null) {
            return true;
        }
        return IChartTypeDefinition.checkIfNumerical(filter) && !IChartTypeDefinition.checkIfTimestamp(filter);
    }
}

