/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.utils;

import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.PapyrusToolkit;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PapyrusControlsFactory {
    public static Composite createCompositeWithType(Shell shell, FormToolkit toolkit, Composite parent, Type type, Image image, String message, boolean useHTML) {
        return PapyrusControlsFactory.createCompositeWithType(shell, toolkit, parent, type, image, message, useHTML, null, null);
    }

    public static Composite createCompositeWithType(Shell shell, FormToolkit toolkit, Composite parent, Type type, Image image, String message, boolean useHTML, ICompositeCreator creator, IContext context) {
        Composite top = null;
        top = toolkit == null ? new Composite(parent, 0) : toolkit.createComposite(parent, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        Image anImage = image;
        switch (type) {
            case ERROR: {
                anImage = NotificationBuilder.getSWTImage(1, shell);
                break;
            }
            case INFO: {
                anImage = NotificationBuilder.getSWTImage(2, shell);
                break;
            }
            case WARNING: {
                anImage = NotificationBuilder.getSWTImage(8, shell);
                break;
            }
            case QUESTION: {
                anImage = NotificationBuilder.getSWTImage(4, shell);
            }
        }
        Label labelImage = new Label(top, 0);
        if (anImage != null) {
            labelImage.setImage(anImage);
        }
        if (creator == null) {
            if (toolkit != null) {
                FormText label = toolkit.createFormText(top, false);
                label.setText(message, useHTML, true);
                label.setLayoutData((Object)new GridData(1808));
            } else {
                Label label = new Label(top, 0);
                label.setText(message);
                label.setLayoutData((Object)new GridData(1808));
            }
        } else {
            if (toolkit == null) {
                toolkit = PapyrusToolkit.INSTANCE;
            }
            Composite compo = creator.createComposite(top, toolkit);
            if (context != null) {
                context.put("composite_created_please_check_IContext_Constant", compo);
            }
        }
        return top;
    }
}

