/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.emf.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.StringUtils;
import org.eclipse.papyrus.emf.facet.util.emf.core.internal.Activator;

public final class ModelUtils {
    private static final String MM_QNAME_SEPARATOR = "::";

    private ModelUtils() {
    }

    public static List<EObject> computeAssignableElements(EStructuralFeature feature, EObject source) {
        EClassifier eType = feature.getEType();
        ArrayList<EObject> list = new ArrayList<EObject>();
        Resource eResource = source.eResource();
        ResourceSet resourceSet = eResource.getResourceSet();
        TreeIterator allContents = resourceSet.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject;
            Notifier notifier = (Notifier)allContents.next();
            if (!(notifier instanceof EObject) || !eType.isInstance((Object)(eObject = (EObject)notifier))) continue;
            list.add(eObject);
        }
        return list;
    }

    public static boolean isBooleanDataType(EClassifier classifier) {
        if (classifier instanceof EDataType) {
            EDataType dataType = (EDataType)classifier;
            Class instanceClass = dataType.getInstanceClass();
            return instanceClass == Boolean.class || instanceClass == Boolean.TYPE;
        }
        return false;
    }

    public static List<EClass> allSubClasses(EClass context) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        ArrayList uris = new ArrayList(EPackage.Registry.INSTANCE.keySet());
        for (String ePackageURI : uris) {
            try {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(ePackageURI);
                EList eClassifiers = ePackage.getEClassifiers();
                for (EClassifier eClassifier : eClassifiers) {
                    EClass eClass;
                    if (!(eClassifier instanceof EClass) || !ModelUtils.isSuperTypeOf(context, eClass = (EClass)eClassifier)) continue;
                    result.add(eClass);
                }
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    public static boolean isSuperTypeOf(EClass self, EClass typeDeclaration) {
        return typeDeclaration.getEAllSuperTypes().contains((Object)self);
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append((String)qualifiedNameParts.get(i) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }

    public static String getName(EObject eObject) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        try {
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
            if (itemLabelProvider != null) {
                String string = itemLabelProvider.getText((Object)eObject);
                return string;
            }
        }
        finally {
            adapterFactory.dispose();
        }
        return ModelUtils.getDefaultName(eObject);
    }

    public static String getDefaultName(EObject eObject) {
        Object value;
        EStructuralFeature feature = ModelUtils.getLabelFeature(eObject.eClass());
        if (feature != null && (value = eObject.eGet(feature)) != null) {
            return StringUtils.truncateBeforeNewline((String)value.toString());
        }
        return "";
    }

    private static EStructuralFeature getLabelFeature(EClass eClass) {
        EAttribute result = null;
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            if (eAttribute.isMany() || eAttribute.getEType().getInstanceClass() == FeatureMap.Entry.class) continue;
            if ("name".equalsIgnoreCase(eAttribute.getName())) {
                result = eAttribute;
                break;
            }
            if (result == null) {
                result = eAttribute;
                continue;
            }
            if (eAttribute.getEAttributeType().getInstanceClass() != String.class || result.getEAttributeType().getInstanceClass() == String.class) continue;
            result = eAttribute;
        }
        return result;
    }

    public static String getQualifiedName(ENamedElement namedElement) {
        Object parentQName = "";
        if (namedElement.eContainer() instanceof ENamedElement) {
            ENamedElement parent = (ENamedElement)namedElement.eContainer();
            parentQName = ModelUtils.getQualifiedName(parent) + MM_QNAME_SEPARATOR;
        }
        return (String)parentQName + namedElement.getName();
    }

    public static ResourceSet getOrCreateResourceSet(EObject eObject) {
        Object resourceSet = null;
        resourceSet = eObject.eResource() == null ? new ResourceSetImpl() : eObject.eResource().getResourceSet();
        return resourceSet;
    }

    public static IProject getProject(EObject eObject) {
        IProject result = null;
        Resource resource = eObject.eResource();
        URI uri = resource.getURI();
        if (uri.isPlatformResource()) {
            String projectName = uri.segment(1);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            result = workspace.getRoot().getProject(projectName);
        }
        return result;
    }
}

