/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.formula.function.AbstractMathFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionException;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionValue;

public class QuotientFunction
extends AbstractMathFunction {
    public QuotientFunction() {
    }

    public QuotientFunction(List<FunctionValue> values) {
        super(values);
    }

    @Override
    public BigDecimal getValue() {
        if (this.values.isEmpty()) {
            return new BigDecimal(0);
        }
        BigDecimal result = null;
        for (FunctionValue value : this.values) {
            if (result == null) {
                result = this.convertValue(value.getValue());
                continue;
            }
            try {
                BigDecimal divisor = this.convertValue(value.getValue());
                if (BigDecimal.ZERO.equals(divisor)) {
                    throw new FunctionException("#DIV/0!", Messages.getString("FormulaParser.error.divisionByZero"));
                }
                result = result.divide(divisor);
            }
            catch (ArithmeticException e) {
                if (e.getMessage().startsWith("Non-terminating")) {
                    result = result.divide(this.convertValue(value.getValue()), 9, RoundingMode.HALF_UP);
                    continue;
                }
                throw e;
            }
        }
        return result;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "/";
        }
        if (this.values.size() == 1) {
            return "/ " + this.values.get(0);
        }
        StringBuilder builder = new StringBuilder();
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            FunctionValue v = (FunctionValue)it.next();
            builder.append(v);
            if (!it.hasNext()) continue;
            builder.append(" / ");
        }
        return builder.toString();
    }
}

