/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.zest.core.widgets.DefaultSubgraph;
import org.eclipse.zest.core.widgets.InternalLayoutContext;
import org.eclipse.zest.core.widgets.InternalNodeLayout;
import org.eclipse.zest.core.widgets.SubgraphFactory;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.ContextListener;
import org.eclipse.zest.layouts.interfaces.ExpandCollapseManager;
import org.eclipse.zest.layouts.interfaces.GraphStructureListener;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.NodeLayout;

public class DAGExpandCollapseManager
implements ExpandCollapseManager {
    private InternalLayoutContext context;
    private final Set<NodeLayout> expandedNodes = new HashSet<NodeLayout>();
    private final Set<NodeLayout> nodesToPrune = new HashSet<NodeLayout>();
    private final Set<NodeLayout> nodesToUnprune = new HashSet<NodeLayout>();
    private final Set<NodeLayout> nodesToUpdate = new HashSet<NodeLayout>();
    private boolean cleanLayoutScheduled = false;

    public void initExpansion(LayoutContext context2) {
        if (!(context2 instanceof InternalLayoutContext)) {
            throw new RuntimeException("This manager works only with org.eclipse.zest.core.widgets.InternalLayoutContext");
        }
        this.context = (InternalLayoutContext)context2;
        this.context.addGraphStructureListener(new GraphStructureListener(){

            public boolean nodeRemoved(LayoutContext context, NodeLayout node) {
                if (DAGExpandCollapseManager.this.isExpanded(node)) {
                    DAGExpandCollapseManager.this.collapse(node);
                }
                DAGExpandCollapseManager.this.flushChanges(false, true);
                return false;
            }

            public boolean nodeAdded(LayoutContext context, NodeLayout node) {
                DAGExpandCollapseManager.this.resetState(node);
                DAGExpandCollapseManager.this.flushChanges(false, true);
                return false;
            }

            public boolean connectionRemoved(LayoutContext context, ConnectionLayout connection) {
                NodeLayout target = connection.getTarget();
                if (!DAGExpandCollapseManager.this.isExpanded(target) && target.getIncomingConnections().length == 0) {
                    DAGExpandCollapseManager.this.expand(target);
                }
                DAGExpandCollapseManager.this.flushChanges(false, true);
                return false;
            }

            public boolean connectionAdded(LayoutContext context, ConnectionLayout connection) {
                DAGExpandCollapseManager.this.resetState(connection.getTarget());
                DAGExpandCollapseManager.this.updateNodeLabel(connection.getSource());
                DAGExpandCollapseManager.this.flushChanges(false, true);
                return false;
            }
        });
        this.context.addContextListener((ContextListener)new ContextListener.Stub(){

            public void backgroundEnableChanged(LayoutContext context) {
                DAGExpandCollapseManager.this.flushChanges(false, false);
            }
        });
    }

    public boolean canCollapse(LayoutContext context, NodeLayout node) {
        return this.isExpanded(node) && !node.isPruned() && node.getOutgoingConnections().length > 0;
    }

    public boolean canExpand(LayoutContext context, NodeLayout node) {
        return !this.isExpanded(node) && !node.isPruned() && node.getOutgoingConnections().length > 0;
    }

    private void collapseAllConnections(NodeLayout node) {
        ConnectionLayout[] outgoingConnections;
        ConnectionLayout[] connectionLayoutArray = outgoingConnections = node.getOutgoingConnections();
        int n = outgoingConnections.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionLayout outgoingConnection = connectionLayoutArray[n2];
            outgoingConnection.setVisible(false);
            ++n2;
        }
        this.flushChanges(true, true);
    }

    private void expandAllConnections(NodeLayout node) {
        ConnectionLayout[] outgoingConnections;
        ConnectionLayout[] connectionLayoutArray = outgoingConnections = node.getOutgoingConnections();
        int n = outgoingConnections.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionLayout outgoingConnection = connectionLayoutArray[n2];
            outgoingConnection.setVisible(true);
            ++n2;
        }
        this.flushChanges(true, true);
    }

    public void setExpanded(LayoutContext context, NodeLayout node, boolean expanded) {
        if (expanded) {
            if (this.canExpand(context, node)) {
                this.expand(node);
            }
            this.expandAllConnections(node);
        } else {
            if (this.canCollapse(context, node)) {
                this.collapse(node);
            }
            this.collapseAllConnections(node);
        }
        this.flushChanges(true, true);
    }

    private void expand(NodeLayout node) {
        NodeLayout[] successingNodes;
        this.setExpanded(node, true);
        NodeLayout[] nodeLayoutArray = successingNodes = node.getSuccessingNodes();
        int n = successingNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout successingNode = nodeLayoutArray[n2];
            this.unpruneNode(successingNode);
            ++n2;
        }
        this.updateNodeLabel(node);
    }

    private void collapse(NodeLayout node) {
        NodeLayout[] successors;
        if (!this.isExpanded(node)) {
            return;
        }
        this.setExpanded(node, false);
        NodeLayout[] nodeLayoutArray = successors = node.getSuccessingNodes();
        int n = successors.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout successor = nodeLayoutArray[n2];
            this.checkPruning(successor);
            if (this.isPruned(successor)) {
                this.collapse(successor);
            }
            ++n2;
        }
        this.updateNodeLabel(node);
    }

    private void checkPruning(NodeLayout node) {
        NodeLayout[] predecessors;
        boolean prune = true;
        NodeLayout[] nodeLayoutArray = predecessors = node.getPredecessingNodes();
        int n = predecessors.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout predecessor = nodeLayoutArray[n2];
            if (this.isExpanded(predecessor)) {
                prune = false;
                break;
            }
            ++n2;
        }
        if (prune) {
            this.pruneNode(node);
        } else {
            this.unpruneNode(node);
        }
    }

    private void resetState(NodeLayout node) {
        NodeLayout[] predecessors = node.getPredecessingNodes();
        if (predecessors.length == 0) {
            this.expand(node);
        } else {
            this.collapse(node);
            this.checkPruning(node);
        }
    }

    private void updateNodeLabel(NodeLayout node) {
        this.nodesToUpdate.add(node);
    }

    private static void updateNodeLabel2(InternalNodeLayout node) {
        SubgraphFactory subgraphFactory = node.getOwnerLayoutContext().getSubgraphFactory();
        if (subgraphFactory instanceof DefaultSubgraph.PrunedSuccessorsSubgraphFactory) {
            ((DefaultSubgraph.PrunedSuccessorsSubgraphFactory)subgraphFactory).updateLabelForNode(node);
        }
    }

    private void pruneNode(NodeLayout node) {
        if (this.isPruned(node)) {
            return;
        }
        this.nodesToUnprune.remove(node);
        this.nodesToPrune.add(node);
    }

    private void unpruneNode(NodeLayout node) {
        if (!this.isPruned(node)) {
            return;
        }
        this.nodesToPrune.remove(node);
        this.nodesToUnprune.add(node);
    }

    private boolean isPruned(NodeLayout node) {
        if (this.nodesToUnprune.contains(node)) {
            return false;
        }
        if (this.nodesToPrune.contains(node)) {
            return true;
        }
        return node.isPruned();
    }

    private void flushChanges(boolean force, boolean clean) {
        NodeLayout node;
        boolean bl = this.cleanLayoutScheduled = this.cleanLayoutScheduled || clean;
        if (!force && !this.context.isBackgroundLayoutEnabled()) {
            return;
        }
        Iterator<NodeLayout> iterator = this.nodesToUnprune.iterator();
        while (iterator.hasNext()) {
            NodeLayout element;
            node = element = iterator.next();
            node.prune(null);
        }
        this.nodesToUnprune.clear();
        if (!this.nodesToPrune.isEmpty()) {
            this.context.createSubgraph(this.nodesToPrune.toArray(new NodeLayout[this.nodesToPrune.size()]));
            this.nodesToPrune.clear();
        }
        for (NodeLayout element : this.nodesToUpdate) {
            node = (InternalNodeLayout)element;
            DAGExpandCollapseManager.updateNodeLabel2((InternalNodeLayout)node);
        }
        this.nodesToUpdate.clear();
        this.context.applyLayout(this.cleanLayoutScheduled);
        this.cleanLayoutScheduled = false;
        this.context.flushChanges(true);
    }

    private boolean isExpanded(NodeLayout node) {
        return this.expandedNodes.contains(node);
    }

    private void setExpanded(NodeLayout node, boolean expanded) {
        if (expanded) {
            this.expandedNodes.add(node);
        } else {
            this.expandedNodes.remove(node);
        }
    }
}

