/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation.timely;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.aggregation.timely.FirstOnlyTimelyColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public class FirstOnlyParallelTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends FirstOnlyTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult> {
    public FirstOnlyParallelTimelyColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, TupleMask columnMask) {
        super(reteContainer, operator, groupMask, columnMask);
    }

    @Override
    public void update(Direction direction, Tuple update, Timestamp timestamp) {
        Tuple group = this.groupMask.transform((ITuple)update);
        Tuple value = this.columnMask.transform((ITuple)update);
        Object aggregand = this.runtimeContext.unwrapElement(value.get(0));
        boolean isInsertion = direction == Direction.INSERT;
        Object previousResult = this.getResultRaw(group, timestamp, true);
        Accumulator oldAccumulator = this.getAccumulator(group, timestamp);
        Object oldResult = this.operator.getAggregate(oldAccumulator);
        Object newAccumulator = this.operator.update(oldAccumulator, aggregand, isInsertion);
        Object newResult = this.operator.getAggregate(newAccumulator);
        this.storeIfNotNeutral(group, newAccumulator, newResult, timestamp);
        this.propagateWithChecks(group, timestamp, previousResult, previousResult, oldResult, newResult);
        Object previousOldResult = oldResult;
        Object previousNewResult = newResult;
        TreeMap groupEntries = (TreeMap)this.memory.get(group);
        Timestamp currentTimestamp = groupEntries == null ? null : groupEntries.higherKey(timestamp);
        while (currentTimestamp != null) {
            FirstOnlyTimelyColumnAggregatorNode.CumulativeAggregate groupEntry = (FirstOnlyTimelyColumnAggregatorNode.CumulativeAggregate)groupEntries.get(currentTimestamp);
            oldResult = groupEntry.result;
            oldAccumulator = groupEntry.accumulator;
            newAccumulator = this.operator.update(oldAccumulator, aggregand, isInsertion);
            newResult = this.operator.getAggregate(newAccumulator);
            this.storeIfNotNeutral(group, newAccumulator, newResult, currentTimestamp);
            this.propagateWithChecks(group, currentTimestamp, previousOldResult, previousNewResult, oldResult, newResult);
            previousOldResult = oldResult;
            previousNewResult = newResult;
            currentTimestamp = groupEntries.higherKey(currentTimestamp);
        }
    }

    @Override
    protected Accumulator getAccumulator(Tuple group, Timestamp timestamp) {
        TreeMap entryMap = (TreeMap)this.memory.get(group);
        if (entryMap == null) {
            return (Accumulator)this.operator.createNeutral();
        }
        FirstOnlyTimelyColumnAggregatorNode.CumulativeAggregate entry = (FirstOnlyTimelyColumnAggregatorNode.CumulativeAggregate)entryMap.get(timestamp);
        if (entry == null) {
            Map.Entry lowerEntry = entryMap.lowerEntry(timestamp);
            if (lowerEntry == null) {
                return (Accumulator)this.operator.createNeutral();
            }
            return (Accumulator)this.operator.clone(((FirstOnlyTimelyColumnAggregatorNode.CumulativeAggregate)lowerEntry.getValue()).accumulator);
        }
        return entry.accumulator;
    }
}

