/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.useractions.UserActionsResources;
import org.eclipse.rse.internal.useractions.api.files.compile.ISystemCompileManagerAdapter;
import org.eclipse.rse.internal.useractions.files.compile.UniversalCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompilableSource;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileProfile;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileType;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class SystemCompileMultipleSelectAction
extends SystemBaseAction {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SystemCompileMultipleSelectAction(Shell shell) {
        super(UserActionsResources.ACTION_COMPILE_NOPROMPT_LABEL, UserActionsResources.ACTION_COMPILE_NOPROMPT_TOOLTIP, null, shell);
        this.allowOnMultipleSelection(true);
        this.setAccelerator(393315);
    }

    public void run() {
        if (this.checkDirtyEditors()) {
            Object element = this.getFirstSelection();
            boolean ok = true;
            while (ok && element != null) {
                ISystemRemoteElementAdapter rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)element);
                ISubSystem subsystem = rmtAdapter.getSubSystem(element);
                String srcType = null;
                srcType = rmtAdapter.getRemoteSourceType(element);
                if (srcType == null) {
                    srcType = "null";
                } else if (srcType.equals("")) {
                    srcType = "blank";
                }
                SystemCompileManager compileManager = null;
                if (element instanceof IAdaptable) {
                    ISystemCompileManagerAdapter adapter;
                    IAdaptable iAdaptable = (IAdaptable)element;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.internal.useractions.api.files.compile.ISystemCompileManagerAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (ISystemCompileManagerAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                        compileManager = adapter.getSystemCompileManager(subsystem.getSubSystemConfiguration());
                    }
                }
                if (compileManager == null) {
                    compileManager = new UniversalCompileManager();
                    compileManager.setSubSystemFactory(subsystem.getSubSystemConfiguration());
                }
                ISystemProfile profile = subsystem.getSystemProfile();
                SystemCompileProfile compileProfile = compileManager.getCompileProfile(profile);
                compileManager.setSystemConnection(subsystem.getHost());
                SystemCompileType compType = compileProfile.getCompileType(srcType);
                SystemCompileCommand compileCmd = compType.getLastUsedCompileCommand();
                SystemCompilableSource compilableSrc = compType.getParentProfile().getCompilableSourceObject(this.getShell(), element, compileCmd, false, this.viewer);
                ok = compilableSrc.runCompileCommand();
                if (!ok) continue;
                element = this.getNextSelection();
            }
        }
    }

    protected List getDirtyEditors() {
        IStructuredSelection sel = this.getSelection();
        List selection = sel.toList();
        ArrayList<ISystemEditableRemoteObject> dirtyEditors = new ArrayList<ISystemEditableRemoteObject>();
        int i = 0;
        while (i < selection.size()) {
            ISystemEditableRemoteObject editable;
            Object selected = selection.get(i);
            if (selected instanceof IAdaptable && (editable = this.getEditableFor((IAdaptable)selected)) != null) {
                try {
                    if (editable.checkOpenInEditor() == 0) {
                        editable.openEditor();
                        if (editable.isDirty()) {
                            dirtyEditors.add(editable);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return dirtyEditors;
    }

    protected ISystemEditableRemoteObject getEditableFor(IAdaptable selected) {
        ISystemRemoteElementAdapter adapter;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemRemoteElementAdapter)selected.getAdapter((Class)clazz)).canEdit((Object)selected)) {
            ISystemEditableRemoteObject editable = adapter.getEditableRemoteObject((Object)selected);
            try {
                editable.setLocalResourceProperties();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return editable;
        }
        return null;
    }

    protected boolean checkDirtyEditors() {
        List dirtyEditors = this.getDirtyEditors();
        if (dirtyEditors.size() > 0) {
            AdaptableList input = new AdaptableList();
            int i = 0;
            while (i < dirtyEditors.size()) {
                ISystemEditableRemoteObject rmtObj = (ISystemEditableRemoteObject)dirtyEditors.get(i);
                input.add(rmtObj.getRemoteObject());
                ++i;
            }
            WorkbenchContentProvider cprovider = new WorkbenchContentProvider();
            SystemTableViewProvider lprovider = new SystemTableViewProvider(null);
            ListSelectionDialog dlg = new ListSelectionDialog(this.getShell(), (Object)input, (IStructuredContentProvider)cprovider, (ILabelProvider)lprovider, SystemUDAResources.EditorManager_saveResourcesMessage);
            dlg.setInitialSelections(input.getChildren());
            dlg.setTitle(SystemUDAResources.EditorManager_saveResourcesTitle);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            Object[] filesToSave = dlg.getResult();
            int s = 0;
            while (s < filesToSave.length) {
                IAdaptable rmtObj = (IAdaptable)filesToSave[s];
                ISystemEditableRemoteObject editable = this.getEditableFor(rmtObj);
                editable.doImmediateSaveAndUpload();
                ++s;
            }
        }
        return true;
    }
}

