/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.manager.FlowAnalysis;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class FlowAnalysisDeducerFromFalseVisitor
extends FlowAnalysis.AbstractDeducer {
    public FlowAnalysisDeducerFromFalseVisitor(@NonNull FlowAnalysis flowAnalysis) {
        super(flowAnalysis);
    }

    @Override
    public @Nullable Boolean visitBooleanLiteralExp(@NonNull BooleanLiteralExp object) {
        return !object.isBooleanSymbol();
    }

    @Override
    public @Nullable Boolean visitOperationCallExp(@NonNull OperationCallExp object) {
        OperationId operationId = PivotUtil.getReferredOperation(object).getOperationId();
        if (PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_NOT)) {
            ((FlowAnalysis)this.context).addFalseExpression(object);
            return Boolean.TRUE;
        }
        if (PivotUtil.isSameOperation(operationId, OperationId.BOOLEAN_OR)) {
            ((FlowAnalysis)this.context).addFalseExpression(PivotUtil.getOwnedSource(object));
            ((FlowAnalysis)this.context).addFalseExpression(PivotUtil.getOwnedArgument(object, 0));
            return Boolean.TRUE;
        }
        if (PivotUtil.isSameOperation(operationId, OperationId.OCLANY_EQUALS)) {
            OCLExpression ownedSource = PivotUtil.getOwnedSource(object);
            OCLExpression ownedArgument = PivotUtil.getOwnedArgument(object, 0);
            if (this.isAlreadyNull(ownedSource)) {
                ((FlowAnalysis)this.context).addNonNullExpression(ownedArgument);
                return Boolean.TRUE;
            }
            if (this.isAlreadyNull(ownedArgument)) {
                ((FlowAnalysis)this.context).addNonNullExpression(ownedSource);
                return Boolean.TRUE;
            }
        } else if (PivotUtil.isSameOperation(operationId, OperationId.OCLANY_NOT_EQUALS)) {
            OCLExpression ownedSource = PivotUtil.getOwnedSource(object);
            OCLExpression ownedArgument = PivotUtil.getOwnedArgument(object, 0);
            if (this.isAlreadyNull(ownedSource)) {
                ((FlowAnalysis)this.context).addNullExpression(ownedArgument);
                return Boolean.TRUE;
            }
            if (this.isAlreadyNull(ownedArgument)) {
                ((FlowAnalysis)this.context).addNullExpression(ownedSource);
                return Boolean.TRUE;
            }
        }
        return (Boolean)super.visitOperationCallExp(object);
    }
}

