/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModelDeclarationTag implements Enumerator
{
    INPUT(0, "input", "input"),
    INOUT(1, "inout", "inout"),
    OUTPUT(2, "output", "output");

    public static final int INPUT_VALUE = 0;
    public static final int INOUT_VALUE = 1;
    public static final int OUTPUT_VALUE = 2;
    private static final ModelDeclarationTag[] VALUES_ARRAY;
    public static final List<ModelDeclarationTag> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModelDeclarationTag[]{INPUT, INOUT, OUTPUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModelDeclarationTag get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelDeclarationTag result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelDeclarationTag getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelDeclarationTag result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelDeclarationTag get(int value) {
        switch (value) {
            case 0: {
                return INPUT;
            }
            case 1: {
                return INOUT;
            }
            case 2: {
                return OUTPUT;
            }
        }
        return null;
    }

    private ModelDeclarationTag(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

