/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

public final class Stack {
    private final Object[] stack;
    private int sp = -1;

    public Stack(int maxStack) {
        this.stack = new Object[maxStack];
    }

    public void push(Object value) {
        this.stack[++this.sp] = value;
    }

    public Object pop() {
        return this.stack[this.sp--];
    }

    public void popv() {
        --this.sp;
    }

    public Object[] pop(int n) {
        Object[] result = new Object[n];
        this.sp -= n;
        System.arraycopy(this.stack, this.sp + 1, result, 0, n);
        return result;
    }

    public <T> T[] pop(int n, T[] result) {
        this.sp -= n;
        System.arraycopy(this.stack, this.sp + 1, result, 0, n);
        return result;
    }

    public Object peek() {
        return this.stack[this.sp];
    }

    public boolean stackEmpty() {
        return this.sp == -1;
    }

    public void dup() {
        ++this.sp;
        this.stack[this.sp] = this.stack[this.sp - 1];
    }

    public void dupX1() {
        ++this.sp;
        int sp1 = this.sp - 1;
        int sp2 = sp1 - 1;
        this.stack[this.sp] = this.stack[sp1];
        this.stack[sp1] = this.stack[sp2];
        this.stack[sp2] = this.stack[this.sp];
    }

    public void swap() {
        Object top = this.stack[this.sp];
        int sp1 = this.sp - 1;
        this.stack[this.sp] = this.stack[sp1];
        this.stack[sp1] = top;
    }

    public void swapX1() {
        Object top = this.stack[this.sp];
        int sp1 = this.sp - 1;
        int sp2 = this.sp - 2;
        this.stack[this.sp] = this.stack[sp2];
        this.stack[sp2] = this.stack[sp1];
        this.stack[sp1] = top;
    }
}

