/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.util.function.Predicate;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.BaseResourceAwareLaunchShortcut;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.DockerComposeUpDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.NewDockerConnection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DockerComposeUpShortcut
extends BaseResourceAwareLaunchShortcut {
    @Override
    protected void launch(IResource resource, String mode) {
        Predicate<ILaunchConfiguration> predicate = config -> {
            try {
                String sourcePath = config.getAttribute("workingDir", "");
                boolean workspaceRelative = config.getAttribute("workingDirWorkspaceRelativeLocation", false);
                IPath dockerfilePath = DockerComposeUpShortcut.getPath(sourcePath, workspaceRelative);
                return dockerfilePath.equals((Object)resource.getLocation().removeLastSegments(1));
            }
            catch (CoreException e) {
                Activator.log(e);
                return false;
            }
        };
        ILaunchConfiguration config2 = this.findLaunchConfiguration("org.eclipse.linuxtools.docker.ui.dockerComposeUpLaunchConfigurationType", resource, predicate);
        if (config2 != null) {
            DebugUITools.launch((ILaunchConfiguration)config2, (String)mode);
        } else {
            Activator.log(new DockerException(LaunchMessages.getString("DockerComposeUpShortcut.launchconfig.error")));
        }
    }

    @Override
    protected ILaunchConfiguration createConfiguration(IResource dockerComposeScript) {
        try {
            if (!DockerConnectionManager.getInstance().hasConnections()) {
                Display.getDefault().asyncExec(() -> {
                    boolean confirm = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)LaunchMessages.getString("DockerComposeUpShortcut.no.connections.msg"), (String)LaunchMessages.getString("DockerComposeUpShortcut.no.connections.desc"));
                    if (confirm) {
                        NewDockerConnection newConnWizard = new NewDockerConnection();
                        CommandUtils.openWizard((IWizard)newConnWizard, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    }
                });
                return null;
            }
            DockerComposeUpDialog dialog = new DockerComposeUpDialog(this.getActiveWorkbenchShell());
            int result = dialog.open();
            if (result == 0) {
                return LaunchConfigurationUtils.createDockerComposeUpLaunchConfiguration(dialog.getSelectedConnection(), dockerComposeScript);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return null;
    }
}

