/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.filesystem.diagram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.examples.filesystem.features.AddContainmentConnectionFeature;
import org.eclipse.graphiti.examples.filesystem.features.CreateContainmentConnectionFeature;
import org.eclipse.graphiti.examples.filesystem.features.CreateInnerFileFeature;
import org.eclipse.graphiti.examples.filesystem.features.DeleteInnerFileFeature;
import org.eclipse.graphiti.examples.filesystem.features.GradientColorFeature;
import org.eclipse.graphiti.examples.filesystem.patterns.FilePattern;
import org.eclipse.graphiti.examples.filesystem.patterns.FilesystemPattern;
import org.eclipse.graphiti.examples.filesystem.patterns.FolderPattern;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.pattern.DefaultFeatureProviderWithPatterns;

public class FilesystemFeatureProvider
extends DefaultFeatureProviderWithPatterns {
    static List<String> ALL_GRADIENT_IDS = Arrays.asList("green-white", "red-white", "blue-white", "blue-white-gloss");

    public FilesystemFeatureProvider(IDiagramTypeProvider dtp) {
        super(dtp);
        this.addPattern(new FilesystemPattern());
        this.addPattern(new FilePattern());
        this.addPattern(new FolderPattern());
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        return new ICreateConnectionFeature[]{new CreateContainmentConnectionFeature((IFeatureProvider)this)};
    }

    public IAddFeature getAddFeature(IAddContext context) {
        if (context instanceof IAddConnectionContext) {
            return new AddContainmentConnectionFeature((IFeatureProvider)this);
        }
        return super.getAddFeature(context);
    }

    public ICustomFeature[] getCustomFeatures(ICustomContext context) {
        ICustomFeature[] ret = super.getCustomFeatures(context);
        ArrayList<AbstractCustomFeature> retList = new ArrayList<AbstractCustomFeature>();
        for (String gid : ALL_GRADIENT_IDS) {
            retList.add(new GradientColorFeature((IFeatureProvider)this, gid));
        }
        retList.add(new CreateInnerFileFeature((IFeatureProvider)this));
        retList.add(new DeleteInnerFileFeature((IFeatureProvider)this));
        ret = retList.toArray(ret);
        return ret;
    }
}

