/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.IErrorItem;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.IResourceChangeEvent;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorHandler;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.NestedEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorPageDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.core.ErrorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ILogger;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.Images;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SchemaObjectEditor
extends FormEditor
implements ISchemaObjectEditor {
    public Object _data;
    private boolean _dirty = false;
    public Object _editModel;
    private IEditorDescriptor _exEditor;
    private ISchemaObjectEditorHandler _handler;
    private ILogger _logger = SOEUIPlugin.getLogger(null);
    private Map _nameToPages = new HashMap();
    private Map _idToPages = new HashMap();
    private List _ids = new ArrayList();
    private List _editorPages = new ArrayList();
    private boolean _syncSave = false;
    private boolean _needRefreshAfterSave = true;
    private ActivationListener _activationListener = null;
    private boolean _isEditModelAvailable = true;

    protected void createPages() {
        super.createPages();
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                final ISchemaObjectEditorPage page = SchemaObjectEditor.this.getActiveEditorPage();
                manager.add((IContributionItem)new Separator("refresh.revert.action.group"));
                IContributionItem item = SchemaObjectEditor.this.getEditorSite().getActionBars().getToolBarManager().find("revert.schema.editor.action.id");
                if (item != null && item instanceof ActionContributionItem) {
                    manager.appendToGroup("refresh.revert.action.group", ((ActionContributionItem)item).getAction());
                }
                if ((item = SchemaObjectEditor.this.getEditorSite().getActionBars().getToolBarManager().find("refresh.schema.editor.action.id")) != null && item instanceof ActionContributionItem) {
                    manager.appendToGroup("refresh.revert.action.group", ((ActionContributionItem)item).getAction());
                }
                manager.add((IContributionItem)new Separator("sav.preference.action.group"));
                Action prefAction = new Action(){

                    public void run() {
                        String[] subPages = page.getPreferencePageIds();
                        int pageNum = subPages == null ? 0 : subPages.length;
                        String[] preferencePages = new String[1 + pageNum];
                        preferencePages[0] = "org.eclipse.datatools.sqltools.schemaobjecteditor.page1";
                        int i = 0;
                        while (i < pageNum) {
                            preferencePages[i + 1] = subPages[i];
                            ++i;
                        }
                        PreferencesUtil.createPreferenceDialogOn(null, (String)preferencePages[0], (String[])preferencePages, null).open();
                    }
                };
                prefAction.setText(Messages.SchemaObjectEditor_preferences);
                manager.add((IAction)prefAction);
                Action saveAction = new Action(){

                    public void run() {
                        SOEUIPlugin.getActiveWorkbenchPage().saveEditor((IEditorPart)SchemaObjectEditor.this, false);
                    }
                };
                saveAction.setText(Messages.SchemaObjectEditor_save_to_server);
                saveAction.setImageDescriptor(Images.DESC_SAVE_TO_DB);
                saveAction.setEnabled(SchemaObjectEditor.this.isDirty());
                manager.appendToGroup("sav.preference.action.group", (IAction)saveAction);
                if (page != null) {
                    page.menuAboutToShow(manager);
                }
            }
        });
        Menu menu = manager.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(menu);
        this._activationListener = new ActivationListener(this.getEditorSite().getWorkbenchWindow().getPartService());
        try {
            SOEUIPlugin.getActiveWorkbenchPage().showView("org.eclipse.ui.views.ProblemView", null, 2);
        }
        catch (Exception e) {
            this._logger.error("SchemaObjectEditorUtils_error_open_problemview", (Throwable)e);
        }
    }

    protected void addPages() {
        if (this._exEditor == null || this._exEditor.getPageDescriptors() == null || this._exEditor.getPageDescriptors().length == 0) {
            this.setupErrorPage(new ErrorPage(Messages.SchemaObjectEditor_no_page), this._exEditor);
            return;
        }
        if (this._exEditor.getHandler() == null) {
            this.setupErrorPage(new ErrorPage(Messages.SchemaObjectEditor_no_handler), this._exEditor);
            return;
        }
        this._handler.setEditor(this);
        IEditorPageDescriptor[] pages = this._exEditor.getSortedPages();
        int i = 0;
        while (i < pages.length) {
            this.setupPage(pages[i], this._exEditor);
            ++i;
        }
        this._handler.hookInitialization();
    }

    @Override
    public void clearDirty() {
        this._dirty = false;
        for (Object obj : this._editorPages) {
            ISchemaObjectEditorPage page;
            if (!(obj instanceof ISchemaObjectEditorPage) || (page = (ISchemaObjectEditorPage)obj).getManagedForm() == null) continue;
            page.getManagedForm().commit(true);
        }
        this.fireDirtyPropertyChange();
    }

    public void dispose() {
        int i = this.pages.size() - 1;
        while (i >= 0) {
            Object page = this.pages.get(i);
            if (page instanceof NestedEditorPage) {
                this.disposePart((IWorkbenchPart)((NestedEditorPage)page).getNestedEditor());
                this.pages.remove(i);
            }
            --i;
        }
        super.dispose();
        if (this._handler != null) {
            this._handler.dispose();
        }
    }

    private boolean aboutToSave(IProgressMonitor monitor) {
        boolean goon = true;
        for (Object next : this.pages) {
            if (next instanceof SchemaObjectEditorPage && !(goon = ((SchemaObjectEditorPage)next).aboutToSave(monitor))) break;
        }
        return goon;
    }

    public void doSave(IProgressMonitor monitor) {
        boolean goon = this.aboutToSave(monitor);
        if (goon && this._handler != null) {
            this._handler.doSave(monitor);
            this._syncSave = false;
        }
    }

    public void doSaveAs() {
        if (this._handler != null) {
            this._handler.doSaveAs();
        }
    }

    @Override
    public void fireDirtyPropertyChange() {
        this.firePropertyChange(257);
    }

    public void fireSchemaEditorProperChanged(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    @Override
    public ISchemaObjectEditorPage getActiveEditorPage() {
        return (ISchemaObjectEditorPage)this.getActivePageInstance();
    }

    public Object getAdapter(Class adapter) {
        Object result = super.getAdapter(adapter);
        if (result != null && !IContentOutlinePage.class.equals((Object)adapter)) {
            return result;
        }
        if (this._handler != null) {
            return this._handler.getAdapter(adapter);
        }
        return null;
    }

    @Override
    public ISchemaObjectEditorPage[] getAllPages() {
        ArrayList ps = new ArrayList();
        for (Object obj : this._editorPages) {
            if (obj == null) continue;
            ps.add(obj);
        }
        return ps.toArray(new ISchemaObjectEditorPage[this._editorPages.size()]);
    }

    @Override
    public int getCurrentPageIndex() {
        return this.getCurrentPage();
    }

    @Override
    public Object getData() {
        return this._data;
    }

    @Override
    public Object getEditModel() {
        return this._editModel;
    }

    public Composite getEditorContainer() {
        return super.getContainer();
    }

    @Override
    public ISchemaObjectEditorHandler getEditorHandler() {
        return this._handler;
    }

    public Control getEditorPageControl(int pageIndex) {
        return super.getControl(pageIndex);
    }

    public int getEditorPageCount() {
        return super.getPageCount();
    }

    @Override
    public ISchemaObjectEditorPage getPageById(String id) {
        return (ISchemaObjectEditorPage)this._idToPages.get(id);
    }

    @Override
    public ISchemaObjectEditorPage getPageByName(String name) {
        return (ISchemaObjectEditorPage)this._nameToPages.get(name);
    }

    @Override
    public IEditorDescriptor getEditorDescriptor() {
        return this._exEditor;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof ISchemaObjectEditorInput) {
            ISchemaObjectEditorInput in = (ISchemaObjectEditorInput)input;
            this._exEditor = in.getEditorDescriptor();
            this._handler = in.getEditorDescriptor().getHandler();
            if (this._exEditor != null && this._exEditor.getEditorName() != null && this._exEditor.getEditorName().length() != 0) {
                this.setPartName(this._exEditor.getEditorName());
            }
            if (this._exEditor != null && this._exEditor.getIcon() != null) {
                this.setTitleImage(this._exEditor.getIcon());
            }
        } else {
            this._logger.error("SchemaObjectEditor_not_proper_iput");
            return;
        }
    }

    public boolean isDirty() {
        if (this._dirty) {
            return this._dirty;
        }
        return super.isDirty();
    }

    public boolean isSaveAsAllowed() {
        if (this._handler != null) {
            return this._handler.isSaveAsAllowed();
        }
        return false;
    }

    @Override
    public void markDirty() {
        this._dirty = true;
        this.fireDirtyPropertyChange();
    }

    protected void pageChange(int newPageIndex) {
        ISchemaObjectEditorPage oldFormPage;
        if (!this._isEditModelAvailable || !this._handler.checkSchemaObjectExistence(true)) {
            return;
        }
        int oldPage = this.getCurrentPage();
        if (oldPage != -1 && this._editorPages.size() > oldPage && this._editorPages.get(oldPage) instanceof ISchemaObjectEditorPage && oldPage != newPageIndex && (oldFormPage = (ISchemaObjectEditorPage)this._editorPages.get(oldPage)) instanceof NestedEditorPage) {
            ((NestedEditorPage)oldFormPage).aboutToLeave();
        }
        if (this._handler != null) {
            this._handler.pageChanged(newPageIndex);
        }
        super.pageChange(newPageIndex);
    }

    @Override
    public void resouceChanged(IResourceChangeEvent event) {
        this._handler.resouceChanged(event);
    }

    @Override
    public void setData(Object _data) {
        this._data = _data;
    }

    @Override
    public void setEditModel(Object model) {
        this._editModel = model;
    }

    public void setEditorPageImage(int pageIndex, Image image) {
        super.setPageImage(pageIndex, image);
    }

    public void setEditorPageText(int pageIndex, String text) {
        super.setPageText(pageIndex, text);
    }

    @Override
    public void setEditorPartName(final String name) {
        if (name != null && name.length() != 0) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SchemaObjectEditor.super.setPartName(name);
                }
            });
        }
    }

    public void addPage(int index, NestedEditorPage page) throws PartInitException {
        IEditorPart editor = page.getNestedEditor();
        IEditorInput input = page.getNestedEditorInput();
        IEditorSite site = this.createSite(editor);
        page.init(site, input);
        Composite parent2 = new Composite(this.getContainer(), this.getOrientation(editor));
        parent2.setLayout((Layout)new FillLayout());
        editor.createPartControl(parent2);
        page.setPartControl((Control)parent2);
        editor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propertyId) {
                SchemaObjectEditor.this.handlePropertyChange(propertyId);
            }
        });
        this.addPage(index, (Control)parent2);
        parent2.setData((Object)editor);
        this.configurePage(index, page);
    }

    protected IEditorSite createSite(IEditorPart editor) {
        if (editor.getEditorSite() != null) {
            return editor.getEditorSite();
        }
        return new MultiPageEditorSite((MultiPageEditorPart)this, editor){

            public String getId() {
                return "org.eclipse.datatools.sqltools.schemaobjecteditor.nested.editor";
            }
        };
    }

    private int getOrientation(IEditorPart editor) {
        if (editor instanceof IWorkbenchPartOrientation) {
            return ((IWorkbenchPartOrientation)editor).getOrientation();
        }
        return this.getOrientation();
    }

    private void setupErrorPage(ISchemaObjectEditorPage page, IEditorDescriptor editor) {
        try {
            page.setId(Messages.SchemaObjectEditor_error_id);
            page.setEditor(this);
            page.setEditorDescriptor(this._exEditor);
            page.setPartName(Messages.SchemaObjectEditor_error);
            this.addPage(page);
        }
        catch (Exception e) {
            this._logger.error("SchemaObjectEditor_error_set_errorpage", (Throwable)e);
        }
    }

    private void setupPage(IEditorPageDescriptor p, IEditorDescriptor editor) {
        if (!p.isSelectedToShow()) {
            return;
        }
        try {
            ISchemaObjectEditorPage page = p.getPageClass();
            page.setId(p.getPageId());
            page.setEditor(this);
            page.setEditorDescriptor(this._exEditor);
            page.setPageDescriptor(p);
            page.setPartName(p.getPageName());
            this._nameToPages.put(p.getPageName(), page);
            this._idToPages.put(p.getPageId(), page);
            this._ids.add(p.getPageId());
            if (page instanceof NestedEditorPage) {
                NestedEditorPage editorPage = (NestedEditorPage)page;
                this.addPage(this.getPageCount(), editorPage);
            } else {
                this.addPage(page);
            }
            this._editorPages.add(page);
        }
        catch (Exception e) {
            this._logger.error("SchemaObjectEditor_error_setup_page", (Throwable)e);
        }
    }

    @Override
    public Map validate() {
        HashMap<ISchemaObjectEditorPage, IErrorItem[]> pageErrors = new HashMap<ISchemaObjectEditorPage, IErrorItem[]>();
        ISchemaObjectEditorPage[] pages = this.getAllPages();
        int i = 0;
        while (i < pages.length) {
            IErrorItem[] items;
            if (pages[i] != null && (items = pages[i].validateOnline(null)) != null && items.length != 0) {
                pageErrors.put(pages[i], items);
            }
            ++i;
        }
        return pageErrors;
    }

    @Override
    public String getDisplayName() {
        if (this._handler != null && this._handler.getDisplayName() != null && !this._handler.getDisplayName().equals(Messages.SavePreviewDialog_noname_sql)) {
            return this._handler.getDisplayName();
        }
        String partName = this.getPartName();
        if (partName != null && !partName.equals("") && partName.indexOf(92) < 0 && partName.indexOf(47) < 0 && partName.indexOf(58) < 0 && partName.indexOf(42) < 0 && partName.indexOf(63) < 0 && partName.indexOf(34) < 0 && partName.indexOf(60) < 0 && partName.indexOf(62) < 0 && partName.indexOf(124) < 0) {
            return partName;
        }
        return Messages.SavePreviewDialog_noname_sql;
    }

    public IFormPage setActivePage(String pageId) {
        IFormPage page = super.setActivePage(pageId);
        if (page != null) {
            return page;
        }
        int i = 0;
        for (String id : this._ids) {
            if (id.equals(pageId)) {
                this.setActivePage(i);
                return (IFormPage)this._idToPages.get(id);
            }
            ++i;
        }
        return null;
    }

    public void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
    }

    private void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                if (part.getSite() instanceof MultiPageEditorSite) {
                    MultiPageEditorSite partSite = (MultiPageEditorSite)part.getSite();
                    partSite.dispose();
                }
                part.dispose();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    protected IEditorPart getEditor(int pageIndex) {
        IEditorPart editor = super.getEditor(pageIndex);
        if (editor != null) {
            return editor;
        }
        Control control = this.getControl(pageIndex);
        if (control != null && control.getData() instanceof IEditorPart) {
            return (IEditorPart)control.getData();
        }
        return null;
    }

    @Override
    public void setSyncSaveMode() {
        this._syncSave = true;
    }

    @Override
    public boolean isSyncSave() {
        return this._syncSave;
    }

    @Override
    public boolean needRefreshAfterSave() {
        return this._needRefreshAfterSave;
    }

    @Override
    public void setNeedRefreshAfterSave(boolean needRefresh) {
        this._needRefreshAfterSave = needRefresh;
    }

    class ActivationListener
    implements IPartListener {
        IPartService part;

        public ActivationListener(IPartService part) {
            this.part = part;
            part.addPartListener((IPartListener)this);
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == SchemaObjectEditor.this) {
                IPreferenceStore store = SOEUIPlugin.getDefault().getPreferenceStore();
                boolean isNeedCheck = store.getBoolean("SchemaObjectEditorPreferencePage.check.existence");
                if (!SchemaObjectEditor.this._handler.checkSchemaObjectExistence(isNeedCheck)) {
                    SchemaObjectEditor.this._isEditModelAvailable = false;
                    this.part.removePartListener((IPartListener)this);
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == SchemaObjectEditor.this) {
                this.part.removePartListener((IPartListener)this);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

